# 帳票設計書 20-OrphanReport

## 概要

本ドキュメントは、LLDリンカにおける孤立セクションレポート（Orphan Section Report）の設計仕様を定義する。このレポートは、リンカスクリプトで明示的に配置されていないセクション（孤立セクション）を検出し、報告する機能である。

### 本帳票の処理概要

OrphanReportは、リンカスクリプトを使用したリンク時に、スクリプトで明示的に配置されていない入力セクション（孤立セクション）を検出し、その配置先を報告する帳票である。

**業務上の目的・背景**：リンカスクリプトを使用する場合、開発者は全てのセクションの配置を明示的に制御したいことが多い。しかし、新しいセクションが追加されたり、既存のセクション名が変更されたりすると、リンカスクリプトでカバーされない「孤立セクション」が発生する。OrphanReportは、これらのセクションを検出・報告することで、リンカスクリプトの保守性を向上させる。

**帳票の利用シーン**：
- 組み込みシステム開発でのメモリマップ管理
- カーネル/ブートローダー開発でのセクション配置確認
- リンカスクリプトの完全性検証

**主要な出力内容**：
1. 孤立セクションのソース（ファイル名:セクション名）
2. 配置先の出力セクション名
3. 警告またはエラーメッセージ

**帳票の出力タイミング**：リンク時に`--orphan-handling`オプションが指定され、孤立セクションが検出された場合に出力される。

**帳票の利用者**：組み込みシステム開発者、OSカーネル開発者、ビルドエンジニア

## 帳票種別

警告/エラーレポート / リンカ診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | N/A | `ld.lld --orphan-handling={warn,error}` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | stderr |
| 文字コード | システムロケール依存 |

### オプション

| オプション値 | 説明 |
|-------------|------|
| `place` | 孤立セクションを自動配置（デフォルト、報告なし） |
| `warn` | 孤立セクションを警告として報告 |
| `error` | 孤立セクションをエラーとして報告 |

## 帳票レイアウト

### レイアウト概要

孤立セクション検出時に以下の形式でメッセージが出力される。

```
{ファイル名}:({セクション名}) is being placed in '{出力セクション名}'
```

### 出力例

```
test.o:(.text) is being placed in '.text'
test.o:(.text.2) is being placed in '.text.2'
<internal>:(.comment) is being placed in '.comment'
<internal>:(.symtab) is being placed in '.symtab'
<internal>:(.shstrtab) is being placed in '.shstrtab'
<internal>:(.strtab) is being placed in '.strtab'
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ファイル名 | 入力ファイル名 | InputFile | ファイル名または`<internal>` |
| 2 | セクション名 | 入力セクション名 | InputSection | 括弧内に表示 |
| 3 | 出力セクション名 | 配置先出力セクション | OutputSection | シングルクォート内に表示 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リンカスクリプト使用 | `-T`オプションでスクリプト指定 | Yes |
| orphan-handling指定 | `warn`または`error`を指定 | Yes |
| 孤立セクション存在 | スクリプトで未処理のセクションがある | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 検出順 | セクション処理順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、リンカの内部データ構造から情報を取得する。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| InputSection | 入力セクション情報 | リンカ内部データ |
| OutputSection | 出力セクション情報 | リンカ内部データ |
| LinkerScript | スクリプト情報 | パース結果 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| - | - | - | 計算項目なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[リンク開始] --> B{リンカスクリプト使用?}
    B -->|No| C[通常リンク]
    B -->|Yes| D{orphan-handling?}
    D -->|place| E[自動配置のみ]
    D -->|warn/error| F[セクション配置処理]
    F --> G{スクリプトで定義?}
    G -->|Yes| H[スクリプト通り配置]
    G -->|No| I[孤立セクション検出]
    I --> J[メッセージ出力]
    J --> K{error?}
    K -->|Yes| L[リンク失敗]
    K -->|No| M[自動配置して続行]
    E --> N[リンク完了]
    H --> N
    M --> N
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 孤立セクション（warn） | 未定義セクション発見 | `{file}:({section}) is being placed in '{output}'` | リンカスクリプトに追加 |
| 孤立セクション（error） | 未定義セクション発見 | 同上（エラー扱い） | リンカスクリプトに追加 |
| 不正なオプション値 | 未知の値を指定 | `unknown --orphan-handling mode: {value}` | 正しい値を指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 孤立セクション数に依存 |
| 目標出力時間 | 即座 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 入力ファイルのパス情報が出力に含まれる
- セクション名からコード構造が推測される可能性がある

## 備考

- `--strip-all`オプション使用時は`.strtab`と`.symtab`は報告されない
- `-shared`オプション使用時は`.dynsym`関連セクションも報告される
- `-r`（relocatable）オプション時はorphan-handlingは無効

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テストケースから動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | orphan-report.s | `lld/test/ELF/linkerscript/orphan-report.s` | orphan-handlingの各モード動作 |

**読解のコツ**:
- RUNディレクティブでオプションの組み合わせを確認
- CHECKディレクティブで期待される出力形式を確認
- `--strip-all`との組み合わせに注意

#### Step 2: オプション定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Options.td | `lld/ELF/Options.td` | `--orphan-handling`オプション定義（370-371行目） |

#### Step 3: 実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Writer.cpp | `lld/ELF/Writer.cpp` | sortOrphanSections関数 |
| 3-2 | LinkerScript.cpp | `lld/ELF/LinkerScript.cpp` | diagnoseOrphanHandling関数 |

**主要処理フロー**:
- `sortOrphanSections`で孤立セクションをソート
- `diagnoseOrphanHandling`で警告/エラーを出力
- `findOrphanPos`で配置位置を決定

### プログラム呼び出し階層図

```
Writer::run
    │
    ├─ sortSections
    │      └─ sortOrphanSections (Writer.cpp:1335)
    │             ├─ findOrphanPos (Writer.cpp:980)
    │             └─ 孤立セクション配置
    │
    └─ finalizeSections
           └─ LinkerScript::diagnoseOrphanHandling
                  └─ 警告/エラー出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リンカスクリプト ──────▶ セクション定義抽出 ───────────┐
                              │                        │
入力オブジェクト ──────▶ セクション収集 ────────────────┤
                              │                        │
                        孤立セクション検出               │
                              │                        ▼
--orphan-handling ─────▶ diagnoseOrphanHandling ──▶ stderr
                              │
                        warn/error判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| orphan-report.s | `lld/test/ELF/linkerscript/orphan-report.s` | テスト | テストケース |
| Options.td | `lld/ELF/Options.td` | 定義 | オプション定義 |
| Writer.cpp | `lld/ELF/Writer.cpp` | ソース | 孤立セクション処理 |
| LinkerScript.cpp | `lld/ELF/LinkerScript.cpp` | ソース | 診断出力 |
| LinkerScript.h | `lld/ELF/LinkerScript.h` | ヘッダー | LinkerScript定義 |
| Config.h | `lld/ELF/Config.h` | ヘッダー | 設定定義 |
| Driver.cpp | `lld/ELF/Driver.cpp` | ソース | オプション処理 |
