# 帳票設計書 5-scan-build HTML Report

## 概要

本ドキュメントは、scan-buildツールの静的解析HTMLレポート機能の設計仕様を記載する。scan-buildによる解析結果をHTML形式で出力し、バグサマリー、バグ詳細、クラッシュレポートを含むレポートを生成する。

### 本帳票の処理概要

scan-build HTML Reportは、Clang Static Analyzerの解析結果を収集し、開発者が閲覧しやすいHTML形式のレポートを生成するPythonモジュールである。index.htmlを中心とした複数のHTMLファイルで構成される。

**業務上の目的・背景**：コマンドラインでの解析結果は一時的で読みにくいため、永続的で視覚的に分かりやすいレポートが必要である。本機能は、解析結果をブラウザで閲覧可能なHTML形式に変換し、バグの種類別集計、ソースコード上でのバグ位置の可視化、解析中のクラッシュ情報の記録を提供する。チーム内での共有やCI/CDアーティファクトとしての保存に適している。

**帳票の利用シーン**：scan-build実行後のレポート確認、CI/CDパイプラインでの解析結果アーカイブ、チーム内でのバグ情報共有、コードレビュー時の参考資料として利用される。

**主要な出力内容**：
1. index.html（メインページ：実行情報、バグサマリー、バグ一覧、クラッシュ一覧）
2. バグ種別ごとの件数集計表
3. ファイル別・関数別のバグ一覧テーブル
4. 個別バグの詳細HTMLファイルへのリンク
5. 解析中のクラッシュ情報（プリプロセッサ出力、stderr）

**帳票の出力タイミング**：scan-buildコマンド実行完了時に、指定された出力ディレクトリにHTMLファイル群が生成される。

**帳票の利用者**：ソフトウェア開発者、QAエンジニア、プロジェクトマネージャー、DevOpsエンジニア

## 帳票種別

HTMLレポート（インデックスページ + 詳細ページ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `scan-build make` | ビルド完了時 |
| - | ブラウザ | `file:///output/index.html` | ファイル閲覧 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | index.html（メイン）、*.html（個別バグ） |
| 出力方法 | ファイル出力 |
| 文字コード | UTF-8 |

### HTML固有設定

| 項目 | 内容 |
|-----|------|
| スタイルシート | scanview.css |
| JavaScript | sorttable.js（ソート機能）、selectable.js（選択機能） |
| 外部リソース | なし（自己完結） |

## 帳票レイアウト

### レイアウト概要

index.htmlは以下の構造で構成される。

```
┌─────────────────────────────────────────────────────────────────┐
│ <head>                                                           │
│   - title, stylesheet, script                                    │
├─────────────────────────────────────────────────────────────────┤
│ <body>                                                           │
│   <h1>タイトル</h1>                                              │
│   <table>実行情報</table>                                        │
│   ├─ User, Working Directory, Command Line                      │
│   ├─ Clang Version, Date                                         │
│   │                                                              │
│   <h2>Bug Summary</h2>                                           │
│   <table>バグ種別集計</table>                                    │
│   │                                                              │
│   <h2>Reports</h2>                                               │
│   <table class="sortable">バグ一覧</table>                       │
│   │                                                              │
│   <h2>Analyzer Failures</h2> (オプション)                        │
│   <table>クラッシュ一覧</table>                                  │
└─────────────────────────────────────────────────────────────────┘
```

### ヘッダー部（実行情報テーブル）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | User | 実行ユーザー | getpass.getuser() | user@hostname |
| 2 | Working Directory | 作業ディレクトリ | prefix（共通パス） | パス文字列 |
| 3 | Command Line | 実行コマンド | sys.argv | コマンド文字列 |
| 4 | Clang Version | Clangバージョン | get_version(clang) | バージョン文字列 |
| 5 | Date | 実行日時 | datetime.today() | 日時文字列 |

### バグサマリー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Bug Type | バグ種別名 | bug_counter.categories | 文字列 |
| 2 | Quantity | 件数 | bug_count | 数値 |
| 3 | Display? | 表示トグル | - | チェックボックス |

### バグ一覧部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Bug Group | バグカテゴリ | bug_category | 文字列 | 自動 |
| 2 | Bug Type | バグ種別 | bug_type | 文字列 | 自動 |
| 3 | File | ファイル名 | bug_file | 文字列 | 自動 |
| 4 | Function/Method | 関数名 | bug_function | 文字列 | 自動 |
| 5 | Line | 行番号 | bug_line | 数値 | 自動 |
| 6 | Path Length | パス長 | bug_path_length | 数値 | 自動 |
| 7 | View Report | 詳細リンク | report_file | リンク | 自動 |

### クラッシュ一覧部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Problem | 問題内容 | crash.problem | 文字列 |
| 2 | Source File | ソースファイル | crash.source | 文字列 |
| 3 | Preprocessed File | プリプロセッサ出力 | crash.file | リンク |
| 4 | STDERR Output | 標準エラー出力 | crash.stderr | リンク |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| output_format | html, plist-html, sarif-html | Yes |
| バグまたはクラッシュ存在 | result > 0 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Bug Type | 昇順（デフォルト、sorttable.js） |

### 重複排除条件

duplicate_check()により、同一ファイル・行・パス長のバグは重複排除。

## データベース参照仕様

### 参照データソース一覧

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| *.html（個別バグ） | バグ詳細情報 | parse_bug_html() |
| *.plist | plist形式バグ | parse_bug_plist() |
| failures/*.info.txt | クラッシュ情報 | parse_crash() |

### バグ情報パース（HTMLから）

| パターン | 抽出項目 |
|---------|---------|
| `<!-- BUGTYPE .* -->` | bug_type |
| `<!-- BUGFILE .* -->` | bug_file |
| `<!-- BUGLINE .* -->` | bug_line |
| `<!-- BUGPATHLENGTH .* -->` | bug_path_length |
| `<!-- BUGCATEGORY .* -->` | bug_category |
| `<!-- BUGDESC .* -->` | bug_description |
| `<!-- FUNCTIONNAME .* -->` | bug_function |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| result | crash_count + bug_counter.total | - | 総エラー数 |
| bug_type_class | "bt_" + category + "_" + type | - | CSSクラス名 |
| commonprefix | os.path.commonprefix() | - | 共通パス |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[document関数呼出] --> B[output_format判定]
    B --> C{HTML形式?}
    C -->|Yes| D[クラッシュ数カウント]
    C -->|No| N[終了]
    D --> E[バグ読込・カウント]
    E --> F{result > 0?}
    F -->|No| N
    F -->|Yes| G[commonprefix計算]
    G --> H[fragments生成]
    H --> I[bug_summary生成]
    I --> J[bug_report生成]
    J --> K[crash_report生成]
    K --> L[assemble_cover]
    L --> M[copy_resource_files]
    M --> N
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パースエラー | HTMLバグファイル不正 | logging.warning | スキップ |
| ファイル読込エラー | ファイルアクセス不可 | OSError | 例外発生 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百バグ |
| 目標出力時間 | 数秒 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

- ソースコードパスがレポートに含まれる
- HTMLエスケープ処理あり（escape関数）

## 備考

- sorttable.jsでテーブルソート機能を提供
- selectable.jsで選択機能を提供
- バグ表示のオン/オフがチェックボックスで切り替え可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | report.py | `clang/tools/scan-build-py/lib/libscanbuild/report.py` | document()関数（行26-66）がエントリーポイント |

**読解のコツ**: document()はoutput_formatに応じてHTML生成とSARIF生成を切り替える。html_reports_availableフラグで判定。

#### Step 2: HTMLアセンブリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | report.py | 同上 | assemble_cover()（行69-129）でindex.html生成 |

**主要処理フロー**:
- **行75-76**: html_titleの設定
- **行78-129**: index.htmlへの書き込み（ヘッダー、実行情報、フラグメント、フッター）

#### Step 3: フラグメント生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | report.py | 同上 | bug_summary()（行132-206）でバグサマリーHTML生成 |
| 3-2 | report.py | 同上 | bug_report()（行209-268）でバグ一覧HTML生成 |
| 3-3 | report.py | 同上 | crash_report()（行271-321）でクラッシュ一覧HTML生成 |

#### Step 4: データパースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | report.py | 同上 | read_bugs()（行333-357）でバグ情報読込 |
| 4-2 | report.py | 同上 | parse_bug_html()（行482-519）でHTMLからバグ情報抽出 |
| 4-3 | report.py | 同上 | parse_crash()（行522-536）でクラッシュ情報抽出 |

### プログラム呼び出し階層図

```
document()
    │
    ├─ read_crashes() ──▶ parse_crash()
    │
    ├─ create_counters() ──▶ predicate()
    │
    ├─ read_bugs() ──▶ parse_bug_html() / parse_bug_plist()
    │      └─ duplicate_check()
    │
    ├─ commonprefix_from()
    │
    ├─ bug_summary() ──▶ reindent(), comment()
    │
    ├─ bug_report() ──▶ prettify_bug()
    │
    ├─ crash_report() ──▶ prettify_crash()
    │
    ├─ assemble_cover()
    │      ├─ get_version()
    │      └─ reindent()
    │
    └─ copy_resource_files()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

*.html (バグ詳細) ──────▶ parse_bug_html()
                                │
*.plist ────────────────▶ parse_bug_plist()
                                │
failures/*.info.txt ────▶ parse_crash()
                                │
                         ┌──────┴──────┐
                         ▼             ▼
                    bug_counter   crash_info
                         │             │
                         └──────┬──────┘
                                │
                    ┌───────────┼───────────┐
                    ▼           ▼           ▼
              bug_summary   bug_report   crash_report
              (.fragment)   (.fragment)   (.fragment)
                    │           │           │
                    └───────────┴───────────┘
                                │
                                ▼
                        assemble_cover()
                                │
                                ▼
                           index.html
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| report.py | `clang/tools/scan-build-py/lib/libscanbuild/report.py` | ソース | レポート生成メイン |
| duplicate_check.py | `clang/tools/scan-build-py/lib/libscanbuild/` | ソース | 重複チェック（import） |
| clang.py | `clang/tools/scan-build-py/lib/libscanbuild/clang.py` | ソース | get_version()提供 |
| scanview.css | resources/ | リソース | スタイルシート |
| sorttable.js | resources/ | リソース | テーブルソート |
| selectable.js | resources/ | リソース | 選択機能 |
