# 帳票設計書 9-ASan Report

## 概要

本ドキュメントは、AddressSanitizer（ASan）のエラーレポート機能の設計仕様を記載する。メモリエラー（ダブルフリー、バッファオーバーフロー等）の詳細レポートを生成する。

### 本帳票の処理概要

ASan Reportは、AddressSanitizerランタイムがメモリエラーを検出した際に、エラーの種類、発生位置、スタックトレース、メモリ状態などの詳細情報を出力する機能である。

**業務上の目的・背景**：C/C++プログラムでのメモリエラーは、セキュリティ脆弱性やクラッシュの主要な原因である。AddressSanitizerは実行時にメモリアクセスを監視し、不正アクセスを検出する。本機能は、検出したエラーを開発者が理解・修正できるよう、詳細な診断情報を提供する。エラーの発生箇所、メモリ割り当て/解放の履歴、影響を受けるメモリ領域の状態を報告することで、デバッグを支援する。

**帳票の利用シーン**：開発中のテスト実行時、CI/CDパイプラインでのサニタイザーテスト、セキュリティ監査、プロダクションでのエラー検出時に利用される。

**主要な出力内容**：
1. エラー種別（heap-buffer-overflow, double-free, use-after-free等）
2. エラー発生位置（PC, BP, SP, アドレス）
3. スタックトレース
4. メモリ領域の説明（ヒープ/スタック/グローバル）
5. シャドウメモリの状態表示
6. スレッド情報

**帳票の出力タイミング**：ASan有効でコンパイルされたプログラム実行中に、メモリエラーが検出された瞬間に標準エラー出力に出力される。

**帳票の利用者**：ソフトウェア開発者、セキュリティエンジニア、QAエンジニア、DevSecOpsエンジニア

## 帳票種別

ランタイムエラーレポート（標準エラー出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル | stderr | エラー検出時自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（stderr） |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | - |
| 出力方法 | 標準エラー出力 |
| 文字コード | UTF-8 |

### 出力固有設定

| 項目 | 内容 |
|-----|------|
| カラー出力 | サポート（Decorator） |
| 区切り線 | `====...====` |
| フォーマット | SUMMARY: AddressSanitizer: {error_type} |

## 帳票レイアウト

### レイアウト概要

エラーレポートは以下の構造で出力される。

```
=================================================================
{Error Description}
    {Stack Trace}

{Address Description}

{Shadow Memory Layout}

SUMMARY: AddressSanitizer: {error_type} {location}
```

### エラー種別一覧

| エラー種別 | 関数名 | 説明 |
|-----------|--------|------|
| SEGV/BUS | ReportDeadlySignal | 致命的シグナル |
| double-free | ReportDoubleFree | 二重解放 |
| new-delete-type-mismatch | ReportNewDeleteTypeMismatch | new/delete型不一致 |
| alloc-dealloc-mismatch | ReportAllocTypeMismatch | 割当/解放種別不一致 |
| free-not-malloced | ReportFreeNotMalloced | 非ヒープメモリ解放 |
| heap-buffer-overflow | ReportGenericError | ヒープバッファオーバーフロー |
| stack-buffer-overflow | ReportGenericError | スタックバッファオーバーフロー |
| global-buffer-overflow | ReportGenericError | グローバルバッファオーバーフロー |
| use-after-free | ReportGenericError | 解放後使用 |
| use-after-poison | ReportGenericError | ポイズン後使用 |
| stack-use-after-return | ReportGenericError | リターン後スタック使用 |

### エラー情報

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Error Type | エラー種別 | ErrorDescription.kind | 文字列 |
| 2 | PC | プログラムカウンタ | pc | 16進数 |
| 3 | BP | ベースポインタ | bp | 16進数 |
| 4 | SP | スタックポインタ | sp | 16進数 |
| 5 | Address | アクセスアドレス | addr | 16進数 |
| 6 | Access Type | 読み/書き | is_write | READ/WRITE |
| 7 | Access Size | アクセスサイズ | access_size | バイト数 |

### スタックトレース

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Frame # | フレーム番号 | - | #N |
| 2 | Address | 命令アドレス | - | 16進数 |
| 3 | Function | 関数名 | シンボライザ | デマングル名 |
| 4 | File:Line | ソース位置 | シンボライザ | path:line:col |

### アドレス説明

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Memory Type | メモリ種別 | HeapAddressDescription等 | ヒープ/スタック/グローバル |
| 2 | Offset | オフセット | - | バイト数 |
| 3 | Allocation Size | 割当サイズ | - | バイト数 |
| 4 | Allocation Stack | 割当時スタック | StackDepot | スタックトレース |
| 5 | Free Stack | 解放時スタック | StackDepot | スタックトレース |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| メモリエラー検出 | ASanがエラーを検出 | Yes |
| halt_on_error | エラー時停止フラグ | No（デフォルトtrue） |

### 出力制御

| オプション | 説明 | デフォルト |
|-----------|------|-----------|
| halt_on_error | エラー時にプログラム停止 | true |
| print_stats | 統計情報出力 | false |
| suppress_equal_pcs | 同一PCエラー抑制 | false |

## データベース参照仕様

### 参照データソース一覧

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| シャドウメモリ | メモリ状態 | MEM_TO_SHADOW() |
| StackDepot | スタック履歴 | StackDepotGet() |
| ThreadRegistry | スレッド情報 | asanThreadRegistry() |
| Symbolizer | シンボル解決 | Symbolizer::GetOrInit() |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Shadow Address | addr >> 3 | - | シャドウメモリアドレス |
| Scariness Score | 各種要因の重み付け合計 | - | 危険度スコア |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[メモリエラー検出] --> B[ScopedInErrorReport開始]
    B --> C[区切り線出力]
    C --> D[ErrorDescription作成]
    D --> E[ReportError]
    E --> F[ScopedInErrorReport終了]
    F --> G[ASAN_ON_ERROR]
    G --> H[ErrorDescription.Print]
    H --> I[DescribeThread]
    I --> J{print_stats?}
    J -->|Yes| K[統計出力]
    J -->|No| L[エラーメッセージコピー]
    K --> L
    L --> M[LogFullErrorReport]
    M --> N{callback登録?}
    N -->|Yes| O[callback呼出]
    N -->|No| P{halt_on_error?}
    O --> P
    P -->|Yes| Q[Die]
    P -->|No| R[処理継続]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 再帰エラー | エラー報告中のエラー | (デッドロック防止) | スキップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1エラー |
| 目標出力時間 | 即時 |
| 同時出力数上限 | 1（ロック） |

## セキュリティ考慮事項

- メモリアドレスがレポートに含まれる（ASLR無効化に利用可能）
- スタックトレースにソースパスが含まれる

## 備考

- __asan_set_error_report_callback()でカスタムコールバック設定可能
- __asan_on_error()でユーザー定義のエラーハンドリング可能
- AsanBuggyPcPoolで同一PCのエラー重複を防止

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | asan_report.h | `compiler-rt/lib/asan/asan_report.h` | レポート関数宣言（行49-104）を確認 |
| 1-2 | asan_errors.h | `compiler-rt/lib/asan/asan_errors.h` | ErrorDescription構造体（推定） |

**読解のコツ**: 各Report*関数がエラー種別に対応。StackVarDescr構造体がスタック変数情報を保持。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | asan_report.cpp | `compiler-rt/lib/asan/asan_report.cpp` | ReportGenericError()（行514-536） |

**主要処理フロー**:
- **行520**: SuppressErrorReport()で重複チェック
- **行532**: ScopedInErrorReport開始
- **行533-534**: ErrorGeneric作成
- **行535**: ReportError呼出

#### Step 3: ScopedInErrorReportを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | asan_report.cpp | 同上 | ScopedInErrorReportクラス（行126-241） |

**主要処理フロー**:
- **行128-164**: コンストラクタ（ロック取得、区切り線出力）
- **行166-223**: デストラクタ（エラー出力、クリーンアップ）
- **行225-229**: ReportError()でエラー登録

#### Step 4: 個別レポート関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | asan_report.cpp | 同上 | ReportDoubleFree等（行251-414） |

### プログラム呼び出し階層図

```
__asan_report_error() [インターフェース]
    │
    └─ ReportGenericError()
           │
           ├─ SuppressErrorReport()
           │      └─ AsanBuggyPcPool照合
           │
           └─ ScopedInErrorReport
                  │
                  ├─ asanThreadRegistry().Lock()
                  │
                  ├─ ReportError(ErrorDescription)
                  │
                  └─ ~ScopedInErrorReport()
                         │
                         ├─ ErrorDescription.Print()
                         │      └─ PrintAddressDescription()
                         │
                         ├─ DescribeThread()
                         │
                         ├─ LogFullErrorReport()
                         │
                         └─ error_report_callback()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

pc, bp, sp, addr ──────▶ ReportGenericError()
                              │
is_write, access_size ──────▶│
                              │
                              ▼
                    ScopedInErrorReport
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              ErrorGeneric         シンボライザ
                    │                   │
                    └─────────┬─────────┘
                              │
                              ▼
                    ErrorDescription.Print()
                              │
                              ▼
                       [stderr出力]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| asan_report.h | `compiler-rt/lib/asan/asan_report.h` | ヘッダ | レポート関数宣言 |
| asan_report.cpp | `compiler-rt/lib/asan/asan_report.cpp` | ソース | レポート関数実装 |
| asan_errors.h | `compiler-rt/lib/asan/asan_errors.h` | ヘッダ | エラー型定義 |
| asan_descriptions.h | `compiler-rt/lib/asan/asan_descriptions.h` | ヘッダ | アドレス説明 |
| asan_scariness_score.h | `compiler-rt/lib/asan/asan_scariness_score.h` | ヘッダ | 危険度スコア |
| sanitizer_report_decorator.h | `compiler-rt/lib/sanitizer_common/sanitizer_report_decorator.h` | ヘッダ | 装飾出力 |
