---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-MSan Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `compiler-rt/lib/msan/msan_report.cpp` 行1-287
- E-02: `compiler-rt/lib/msan/msan_report.h` 行1-34
- E-03: 帳票一覧.csv 行11

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReportUMR()がメインレポート関数 | E-01 (行106-120), E-02 (行23) | ○ |
| C-02 | report_umrsフラグでレポート制御 | E-01 (行107) | ○ |
| C-03 | ScopedErrorReportLockでロック取得 | E-01 (行109) | ○ |
| C-04 | Decoratorでカラー出力 | E-01 (行32-37, 111-114) | ○ |
| C-05 | Origin()でマゼンタ色 | E-01 (行35) | ○ |
| C-06 | Name()でグリーン色 | E-01 (行36) | ○ |
| C-07 | DescribeOrigin()でOrigin説明 | E-01 (行56-104) | ○ |
| C-08 | Origin::FromRawId()でOrigin取得 | E-01 (行59) | ○ |
| C-09 | isChainedOrigin()でチェーン判定 | E-01 (行60) | ○ |
| C-10 | getNextChainedOrigin()でチェーン取得 | E-01 (行62) | ○ |
| C-11 | isStackOrigin()でスタック起源判定 | E-01 (行67) | ○ |
| C-12 | DescribeStackOrigin()でスタック起源説明 | E-01 (行39-54) | ○ |
| C-13 | GetStackOriginDescr()で変数名取得 | E-01 (行69) | ○ |
| C-14 | getStackTraceForHeapOrigin()でヒープ起源取得 | E-01 (行72) | ○ |
| C-15 | stack.tagでヒープ起源種別判定 | E-01 (行73-101) | ○ |
| C-16 | TAG_ALLOC/TAG_DEALLOC等の種別 | E-01 (行74-96) | ○ |
| C-17 | DescribeMemoryRange()でシャドウメモリ表示 | E-01 (行191-272), E-02 (行27) | ○ |
| C-18 | OriginSetでA-Z文字による起源識別 | E-01 (行158-189) | ○ |
| C-19 | 16バイト単位でのダンプ | E-01 (行220, 247-258) | ○ |
| C-20 | ReportExpectedUMRNotFound()で期待UMRなし報告 | E-01 (行122-127), E-02 (行24) | ○ |
| C-21 | ReportStats()で統計出力 | E-01 (行129-145), E-02 (行25) | ○ |
| C-22 | ReportAtExitStatistics()で終了時統計 | E-01 (行147-156), E-02 (行26) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな実装で全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ReportUMR()の処理フローが正確か確認
- [ ] DescribeOrigin()のチェーン起源ループが正確か確認
- [ ] stack.tagの値とメッセージの対応が正確か確認
- [ ] DescribeMemoryRange()のフォーマットが正確か確認
