---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-TSan_Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の目標出力時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportType列挙型（24-41行目）
- E-02: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportDesc構造体（113-134行目）
- E-03: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportMop構造体（53-65行目）
- E-04: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportLocation構造体（75-87行目）
- E-05: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportThread構造体（89-99行目）
- E-06: `compiler-rt/lib/tsan/rtl/tsan_report.h` - ReportMutex構造体（101-106行目）
- E-07: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintReport関数（282-361行目）
- E-08: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - ReportTypeString関数（62-101行目）
- E-09: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintStack関数（103-118行目）
- E-10: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintMop関数（142-162行目）
- E-11: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintLocation関数（164-207行目）
- E-12: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintThread関数（230-254行目）
- E-13: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - PrintMutex関数（221-228行目）
- E-14: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - Decorator class（22-30行目）
- E-15: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - Go言語向け実装（363-456行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TSanは16種類のエラータイプをサポート | E-01 | ○ |
| C-02 | ReportDescがレポート全体のコンテナ | E-02 | ○ |
| C-03 | レポートは`==================`で区切られる | E-07 (284, 360行目) | ○ |
| C-04 | エラー種別はReportTypeString関数で文字列変換 | E-08 | ○ |
| C-05 | PrintReport関数がエントリーポイント | E-07 | ○ |
| C-06 | カラー出力はDecorator classで制御 | E-14 | ○ |
| C-07 | スタックトレース出力はPrintStack関数 | E-09 | ○ |
| C-08 | メモリ操作情報出力はPrintMop関数 | E-10 | ○ |
| C-09 | メモリ位置情報出力はPrintLocation関数 | E-11 | ○ |
| C-10 | スレッド情報出力はPrintThread関数 | E-12 | ○ |
| C-11 | ミューテックス情報出力はPrintMutex関数 | E-13 | ○ |
| C-12 | Go言語向けの出力形式も別途サポート | E-15 | ○ |
| C-13 | ReportMop構造体にアクセス情報が含まれる | E-03 | ○ |
| C-14 | ReportLocationに位置タイプ情報が含まれる | E-04 | ○ |
| C-15 | ReportThreadにスレッドID等が含まれる | E-05 | ○ |
| C-16 | ReportMutexにミューテックス情報が含まれる | E-06 | ○ |
| C-17 | ChooseSummaryStack関数でサマリースタック選択 | E-07 (264-274行目) | ○ |
| C-18 | 目標出力時間は即座（ミリ秒単位） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値についてはソースコードに明記がなく、一般的な想定値として記載
  - 候補：ベンチマーク結果 / 設計ドキュメント / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術仕様は高い信頼性
- 1: 中リスク - パフォーマンス要件は実測値に基づく検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ReportType列挙型の16種類すべてが正しく文書化されているか確認
- [ ] PrintReport関数の処理フローが実装と一致しているか確認
- [ ] Go言語向け実装との差異が正しく記載されているか確認
- [ ] Decorator classのカラー定義が最新か確認
