---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-HWASan_Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間「数百ミリ秒」**：具体的な計測値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `compiler-rt/lib/hwasan/hwasan_report.h` - 公開API宣言（23-30行目）
- E-02: `compiler-rt/lib/hwasan/hwasan_report.cpp` - ScopedReportクラス（40-86行目）
- E-03: `compiler-rt/lib/hwasan/hwasan_report.cpp` - BaseReportクラス（477-561行目）
- E-04: `compiler-rt/lib/hwasan/hwasan_report.cpp` - TagMismatchReport（1021-1078行目）
- E-05: `compiler-rt/lib/hwasan/hwasan_report.cpp` - InvalidFreeReport（902-938行目）
- E-06: `compiler-rt/lib/hwasan/hwasan_report.cpp` - TailOverwrittenReport（940-1019行目）
- E-07: `compiler-rt/lib/hwasan/hwasan_report.cpp` - PrintAddressDescription（791-892行目）
- E-08: `compiler-rt/lib/hwasan/hwasan_report.cpp` - PrintTags（894-900行目）
- E-09: `compiler-rt/lib/hwasan/hwasan_report.cpp` - PrintTagsAroundAddr（415-469行目）
- E-10: `compiler-rt/lib/hwasan/hwasan_report.cpp` - PrintStackAllocations（205-346行目）
- E-11: `compiler-rt/lib/hwasan/hwasan_report.cpp` - FindHeapAllocation（166-203行目）
- E-12: `compiler-rt/lib/hwasan/hwasan_report.cpp` - ReportRegisters（1098-1135行目）
- E-13: `compiler-rt/lib/hwasan/hwasan_report.cpp` - MaybePrintAndroidHelpUrl（104-111行目）
- E-14: `compiler-rt/lib/hwasan/hwasan_report.cpp` - error_message_lock_（82行目）
- E-15: `compiler-rt/lib/hwasan/hwasan_report.cpp` - kShadowAlignment定数使用箇所
- E-16: `compiler-rt/lib/hwasan/hwasan_report.cpp` - Decoratorクラス（154-163行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HWASanは3種類のエラータイプをサポート | E-01, E-04, E-05, E-06 | ○ |
| C-02 | ScopedReportがレポート出力のライフサイクル管理 | E-02 | ○ |
| C-03 | BaseReportが共通処理を提供 | E-03 | ○ |
| C-04 | TagMismatchReportがタグ不一致を報告 | E-04 | ○ |
| C-05 | InvalidFreeReportが無効な解放を報告 | E-05 | ○ |
| C-06 | TailOverwrittenReportがテール上書きを報告 | E-06 | ○ |
| C-07 | PrintAddressDescriptionでアドレス詳細を出力 | E-07 | ○ |
| C-08 | PrintTagsでタグダンプを出力 | E-08 | ○ |
| C-09 | PrintTagsAroundAddrでタグ周辺情報を整形 | E-09 | ○ |
| C-10 | PrintStackAllocationsでスタック変数を検索 | E-10 | ○ |
| C-11 | FindHeapAllocationでヒープ履歴を検索 | E-11 | ○ |
| C-12 | ReportRegistersでCPUレジスタを出力 | E-12 | ○ |
| C-13 | Android向けにヘルプURLを自動表示 | E-13 | ○ |
| C-14 | error_message_lock_で排他制御 | E-14 | ○ |
| C-15 | 16バイトのグラニュール単位でタグ付け | E-15 | ○ |
| C-16 | カラー出力はDecoratorクラスで制御 | E-16 | ○ |
| C-17 | ポインタタグは上位8ビットから取得 | E-03 (GetTagFromPointer) | ○ |
| C-18 | デストラクタでレポート出力 | E-04 (1036-1078行目) | ○ |
| C-19 | halt_on_errorフラグで終了制御 | E-02 (57-63行目) | ○ |
| C-20 | 目標出力時間は数百ミリ秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値についてはソースコードに明記がなく、シンボル解決のオーバーヘッドを考慮した推定値
  - 候補：ベンチマーク結果 / プロファイリングデータ / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術仕様は高い信頼性
- 1: 中リスク - パフォーマンス要件は実測値に基づく検証が必要
- 0: 低リスク - ARM64固有の実装詳細はアーキテクチャドキュメントと整合

## 6) レビュアーチェックリスト（最小）
- [ ] 3種類のレポートクラスの処理フローが正確か確認
- [ ] シャドウメモリマッピングの説明が正確か確認
- [ ] Android固有の処理（ヘルプURL等）が網羅されているか確認
- [ ] AArch64とRISC-V64両方のレジスタ出力形式が正確か確認
