---
generated_at: 2026-02-01 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ProfileQualityStats

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `bolt/include/bolt/Passes/ProfileQualityStats.h` - クラス定義（84-93行目）
- E-02: `bolt/lib/Passes/ProfileQualityStats.cpp` - FlowInfo構造体（47-53行目）
- E-03: `bolt/lib/Passes/ProfileQualityStats.cpp` - runOnFunctions（676-689行目）
- E-04: `bolt/lib/Passes/ProfileQualityStats.cpp` - printCFGContinuityStats（94-195行目）
- E-05: `bolt/lib/Passes/ProfileQualityStats.cpp` - printCallGraphFlowConservationStats（197-284行目）
- E-06: `bolt/lib/Passes/ProfileQualityStats.cpp` - printCFGFlowConservationStats（286-404行目）
- E-07: `bolt/lib/Passes/ProfileQualityStats.cpp` - printExceptionHandlingStats（406-472行目）
- E-08: `bolt/lib/Passes/ProfileQualityStats.cpp` - computeFlowMappings（474-606行目）
- E-09: `bolt/lib/Passes/ProfileQualityStats.cpp` - printAll（608-666行目）
- E-10: `bolt/lib/Passes/ProfileQualityStats.cpp` - TopFunctionsForProfileQualityCheck（27-31行目）
- E-11: `bolt/lib/Passes/ProfileQualityStats.cpp` - PercentileForProfileQualityCheck（32-36行目）
- E-12: `bolt/lib/Passes/ProfileQualityStats.cpp` - MinBlockCount定数（63行目）
- E-13: `bolt/lib/Passes/ProfileQualityStats.cpp` - MinLPECSum定数（58行目）
- E-14: `bolt/include/bolt/Passes/ProfileQualityStats.h` - ヘッダーコメント（9-67行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PrintProfileQualityStatsはBinaryFunctionPassを継承 | E-01 | ○ |
| C-02 | FlowInfo構造体が各種フローマップを保持 | E-02 | ○ |
| C-03 | runOnFunctionsがエントリーポイント | E-03 | ○ |
| C-04 | デフォルト対象関数数は1000 | E-10 | ○ |
| C-05 | デフォルトパーセンタイルは95 | E-11 | ○ |
| C-06 | printCFGContinuityStatsでCFG継続性を計算 | E-04 | ○ |
| C-07 | BFSで到達可能性を計算 | E-04 (119-152行目) | ○ |
| C-08 | printCallGraphFlowConservationStatsでフロー保存を計算 | E-05 | ○ |
| C-09 | printCFGFlowConservationStatsでブロック別フローを計算 | E-06 | ○ |
| C-10 | printExceptionHandlingStatsで例外処理統計を計算 | E-07 | ○ |
| C-11 | computeFlowMappingsでフローマップを構築 | E-08 | ○ |
| C-12 | printAllで全統計を出力 | E-09 | ○ |
| C-13 | MinBlockCountは500 | E-12 | ○ |
| C-14 | MinLPECSumは50 | E-13 | ○ |
| C-15 | 重みはlog(EC * NumNonPseudos)で計算 | E-06 (344-347行目) | ○ |
| C-16 | 5つのバケットに分割した詳細統計 | E-09 (634-664行目) | ○ |
| C-17 | CFG継続性チェックの説明 | E-14 (10-22行目) | ○ |
| C-18 | フロー保存チェックの説明 | E-14 (24-56行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘッダーファイルのコメントに詳細な説明あり
- 0: 低リスク - 実装が明確で追跡しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] FlowInfo構造体の各フィールドの用途を確認
- [ ] BFSアルゴリズムの正確性を確認
- [ ] フロー保存ギャップ計算式の正確性を確認
- [ ] パーセンタイル計算の実装を確認
