---
generated_at: 2026-02-01 11:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：18-TimeReport

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **出力形式の詳細**：Timer.cppの詳細解析が必要
  2. **パーセント計算式**：具体的な実装箇所の特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `clang/test/Driver/time-report.c` - テストケース
- E-02: `flang/test/Driver/time-report.f90` - Flangテストケース
- E-03: `clang/include/clang/Options/Options.td` - オプション定義
- E-04: `clang/include/clang/Basic/CodeGenOptions.def` - CodeGenオプション
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -ftime-reportオプションでレポート有効化 | E-01, E-02 | ○ |
| C-02 | per-passとper-pass-runオプションがある | E-01 | ○ |
| C-03 | User Time, System Time, Wall Timeを出力 | 一般知識 | ○ |
| C-04 | 出力は標準エラー | E-01 | ○ |
| C-05 | llvm::Timerインフラストラクチャを使用 | 一般知識 | ○ |
| C-06 | TimePassesIsEnabledで制御 | 一般知識 | ○ |
| C-07 | TimeRegionでRAII計測 | 一般知識 | ○ |
| C-08 | TimerGroupでグループ管理 | 一般知識 | ○ |
| C-09 | テストケースの存在 | E-01, E-02 | ○ |
| C-10 | Flangでも使用可能 | E-02 | ○ |
| C-11 | 具体的な出力形式 | **詳細未確認** | △ |
| C-12 | パーセント計算の詳細 | **詳細未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Timer.cpp/Timer.hの詳細解析が必要
  - 候補：printAll関数の実装 / 出力フォーマット定義
- 出力レイアウトの正確な形式
  - 候補：実行結果のサンプル / ソースコード解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースで基本動作は確認可能
- 1: 中リスク - 出力形式の詳細はソースコード解析が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Timer.hのTimer, TimeRegion, TimerGroupクラスを確認
- [ ] printAll関数の出力形式を確認
- [ ] -ftime-report=per-pass-runの動作を確認
- [ ] 実際の出力例を取得して形式を検証
