---
generated_at: 2026-02-01 11:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-SymbolReporter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - インターフェース定義（18-24行目）
- E-02: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - SymbolReporterクラス（18-24行目）
- E-03: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - reportSymbols宣言（22-23行目）
- E-04: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - デストラクタ宣言（20行目）
- E-05: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - インクルード（13行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SymbolReporterは抽象クラス | E-02 | ○ |
| C-02 | reportSymbolsは純粋仮想関数 | E-03 (= 0) | ○ |
| C-03 | デストラクタはvirtual default | E-04 | ○ |
| C-04 | 引数はFileNameとSymbols | E-03 | ○ |
| C-05 | FileNameはllvm::StringRef型 | E-03 | ○ |
| C-06 | SymbolsはSymbolInfo::SignalMap型 | E-03 | ○ |
| C-07 | SymbolInfo.hをインクルード | E-05 | ○ |
| C-08 | clang名前空間内に定義 | E-02 (14-15行目) | ○ |
| C-09 | find_all_symbols名前空間内に定義 | E-02 (15行目) | ○ |
| C-10 | インターフェースパターンを使用 | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して十分な根拠が存在する。
- SymbolReporterの具体的な実装クラスについては、本インターフェース設計書の範囲外。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースがシンプルで明確
- 0: 低リスク - コードサイズが非常に小さい（30行未満）

## 6) レビュアーチェックリスト（最小）
- [ ] SymbolInfo::SignalMapの定義を確認
- [ ] 具体的な実装クラスの存在を確認
- [ ] find-all-symbolsツールでの使用箇所を確認
