---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-DirectoryCoverageReport

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **派生クラスの具体的な実装**：HTML出力等の具体的な派生クラス参照が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `llvm/tools/llvm-cov/CoverageReport.cpp` 行592-682
- E-02: `llvm/tools/llvm-cov/CoverageReport.h` 行78-135
- E-03: 帳票一覧.csv 行3

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectoryCoverageReportはCoverageReportを拡張した抽象クラス | E-02 (行78-86) | ○ |
| C-02 | ディレクトリ階層ごとにカバレッジサマリーを生成 | E-01 (行618-682) | ○ |
| C-03 | prepareDirectoryReports()がエントリーポイント | E-02 (行94-95), E-01 (行592-612) | ○ |
| C-04 | LCPStack でディレクトリ深度を管理 | E-02 (行114), E-01 (行607, 661, 680) | ○ |
| C-05 | ThreadPoolInterface* TPoolでスレッドプール保持 | E-02 (行107), E-01 (行606, 642, 656) | ○ |
| C-06 | SubFileReportsはstd::map型 | E-02 (行117) | ○ |
| C-07 | SubDirReportsはstd::map型（pair含む） | E-02 (行118-120) | ○ |
| C-08 | generateSubDirectoryReport()は純粋仮想関数 | E-02 (行128-130) | ○ |
| C-09 | prepareSubDirectoryReports()で再帰処理 | E-01 (行618-682), E-02 (行133-134) | ○ |
| C-10 | ファイルをSubFilesとSubDirsに分類 | E-01 (行628-647) | ○ |
| C-11 | 単一ファイルのサブディレクトリは親に統合 | E-01 (行652-657) | ○ |
| C-12 | getRedundantPrefixLen()でLCP計算 | E-01 (行596, 659) | ○ |
| C-13 | TPool->wait()でスレッド待機 | E-01 (行667) | ○ |
| C-14 | CurrentTotalsでディレクトリ集計 | E-01 (行669-674) | ○ |
| C-15 | Error型で再帰エラーを伝播 | E-01 (行618, 662, 676-678), E-02 (行133) | ○ |
| C-16 | ソースファイル2以上が必要（コメント記載） | E-02 (行91-93) | ○ |
| C-17 | std::mapでソート順保証 | E-02 (行116-120, コメント行125) | ○ |
| C-18 | テンプレートメソッドパターン使用 | E-02 (行77コメント) | ○ |
| C-19 | Options, Coverage, Filtersをprotectedで保持 | E-02 (行100-102) | ○ |
| C-20 | 派生クラスでHTML出力等を実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: DirectoryCoverageReportの具体的な派生クラスの実装ファイルを参照していない
  - 候補：`llvm/tools/llvm-cov/SourceCoverageViewHTML.cpp` / その他派生クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 抽象クラスとしての構造は完全に根拠あり
- 1: 中リスク - 具体的な出力形式は派生クラス依存のため別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] prepareSubDirectoryReports()の再帰ロジックが設計書と一致するか確認
- [ ] LCPStack操作（push_back/pop_back）が正しく記述されているか確認
- [ ] 単一ファイルディレクトリの統合条件が正確か確認
- [ ] generateSubDirectoryReport()を実装する派生クラスを特定して確認
