---
generated_at: 2026-02-01 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-OrphanReport

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lld/test/ELF/linkerscript/orphan-report.s` - テストケース
- E-02: `lld/ELF/Options.td` - orphan-handlingオプション定義（370-371行目）
- E-03: `lld/ELF/Writer.cpp` - sortOrphanSections関数（1335行目付近）
- E-04: `lld/ELF/Writer.cpp` - findOrphanPos関数（980行目付近）
- E-05: `lld/ELF/Writer.cpp` - diagnoseOrphanHandling呼び出し（2008行目）
- E-06: `lld/test/ELF/linkerscript/orphan-report.s` - 出力形式（33-44行目）
- E-07: `lld/test/ELF/linkerscript/orphan-report.s` - place/warn/errorモード（6-31行目）
- E-08: `lld/test/ELF/linkerscript/orphan-report.s` - strip-allとの組み合わせ（25-27行目）
- E-09: `lld/test/ELF/linkerscript/orphan-report.s` - 不正オプション値エラー（50-52行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --orphan-handlingオプションが存在 | E-02 | ○ |
| C-02 | place/warn/errorの3モード | E-07 | ○ |
| C-03 | placeがデフォルトで報告なし | E-01 (6-8行目) | ○ |
| C-04 | warnモードで警告出力 | E-01 (46-48行目) | ○ |
| C-05 | errorモードでエラー出力 | E-01 (21-24行目) | ○ |
| C-06 | 出力形式は`{file}:({section}) is being placed in '{output}'` | E-06 | ○ |
| C-07 | sortOrphanSections関数が存在 | E-03 | ○ |
| C-08 | findOrphanPos関数が存在 | E-04 | ○ |
| C-09 | diagnoseOrphanHandlingが呼び出される | E-05 | ○ |
| C-10 | --strip-allで.strtab/.symtabは報告されない | E-08 | ○ |
| C-11 | -sharedで.dynsym関連も報告 | E-01 (29-31行目) | ○ |
| C-12 | 不正オプション値でエラー | E-09 | ○ |
| C-13 | リンカスクリプト使用時のみ有効 | E-01 (14-19行目) | ○ |
| C-14 | -rオプション時は無効 | E-01 (18-19行目) | ○ |
| C-15 | `<internal>`は内部生成セクション | E-06 (35行目以降) | ○ |
| C-16 | テストケースの存在 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してテストケースまたはソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースが詳細で網羅的
- 0: 低リスク - オプション定義が明確

## 6) レビュアーチェックリスト（最小）
- [ ] orphan-handlingの3モード動作を確認
- [ ] 出力メッセージの形式がテストケースと一致するか確認
- [ ] --strip-allとの組み合わせ動作を確認
- [ ] -sharedオプション時の追加セクション報告を確認
