---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-scan-build HTML Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/scan-build-py/lib/libscanbuild/report.py` 行1-692
- E-02: 帳票一覧.csv 行6

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | document()がエントリーポイント | E-01 (行26-66) | ○ |
| C-02 | output_formatでhtml/plist-html/sarif-htmlを判定 | E-01 (行29-30) | ○ |
| C-03 | read_crashes()でクラッシュ数カウント | E-01 (行33) | ○ |
| C-04 | create_counters()でバグカウンター作成 | E-01 (行34) | ○ |
| C-05 | read_bugs()でバグ情報読込 | E-01 (行35-36, 333-357) | ○ |
| C-06 | commonprefix_from()で共通パス計算 | E-01 (行44, 667-671) | ○ |
| C-07 | bug_summary()でバグサマリーHTML生成 | E-01 (行49, 132-206) | ○ |
| C-08 | bug_report()でバグ一覧HTML生成 | E-01 (行50, 209-268) | ○ |
| C-09 | crash_report()でクラッシュ一覧HTML生成 | E-01 (行52, 271-321) | ○ |
| C-10 | assemble_cover()でindex.html組立 | E-01 (行53, 69-129) | ○ |
| C-11 | copy_resource_files()でCSS/JS複製 | E-01 (行55, 612-617) | ○ |
| C-12 | getpass.getuser()でユーザー名取得 | E-01 (行110) | ○ |
| C-13 | socket.gethostname()でホスト名取得 | E-01 (行111) | ○ |
| C-14 | get_version()でClangバージョン取得 | E-01 (行114) | ○ |
| C-15 | datetime.today()で日時取得 | E-01 (行115) | ○ |
| C-16 | バグ種別ごとの件数集計 | E-01 (行170-196) | ○ |
| C-17 | チェックボックスで表示トグル | E-01 (行162-166, 189-191) | ○ |
| C-18 | sortableクラスでソート機能 | E-01 (行222) | ○ |
| C-19 | parse_bug_html()でHTMLからバグ情報抽出 | E-01 (行482-519) | ○ |
| C-20 | 正規表現でBUGTYPE等をパース | E-01 (行485-493) | ○ |
| C-21 | parse_crash()でクラッシュ情報抽出 | E-01 (行522-536) | ○ |
| C-22 | duplicate_check()で重複排除 | E-01 (行344-346) | ○ |
| C-23 | escape()でHTMLエスケープ | E-01 (行634-644) | ○ |
| C-24 | reindent()でインデント整形 | E-01 (行647-654) | ○ |
| C-25 | comment()でHTMLコメント生成 | E-01 (行657-664) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Pythonコードで読みやすく、全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] document()関数の処理フローが設計書と一致するか確認
- [ ] HTML生成のreindent()による整形が正確か確認
- [ ] parse_bug_html()の正規表現パターンが正確か確認
- [ ] リソースファイル（CSS/JS）の存在を確認
