---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-SARIF Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `clang/tools/scan-build-py/lib/libscanbuild/report.py` 行360-458
- E-02: 帳票一覧.csv 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | merge_sarif_files()でSARIFマージ | E-01 (行360) | ○ |
| C-02 | sarif_reports_availableで出力形式判定 | E-01 (行30) | ○ |
| C-03 | glob.iglob("*.sarif")でファイル一覧取得 | E-01 (行428-431) | ○ |
| C-04 | 空ファイルをスキップ（empty関数） | E-01 (行367-369, 431) | ○ |
| C-05 | update_sarif_object()で再帰的更新 | E-01 (行371-402) | ○ |
| C-06 | messageプロパティ検出時にmatch_and_update_run呼出 | E-01 (行381-384) | ○ |
| C-07 | 辞書内の配列・オブジェクトを再帰処理 | E-01 (行386-400) | ○ |
| C-08 | match_and_update_run()で埋め込みリンク更新 | E-01 (行404-426) | ○ |
| C-09 | sarif:/runs/(\d+)パターンでマッチ | E-01 (行413) | ○ |
| C-10 | 右から左へ置換（文字長変化対応） | E-01 (行420-423) | ○ |
| C-11 | 初回ファイルでmerged初期化 | E-01 (行447-448) | ○ |
| C-12 | 2回目以降はrunsをappend | E-01 (行450-453) | ○ |
| C-13 | runs_countでオフセット管理 | E-01 (行438, 455) | ○ |
| C-14 | json.dump()で出力 | E-01 (行457-458) | ○ |
| C-15 | indent=4でフォーマット | E-01 (行458) | ○ |
| C-16 | sort_keys=Trueでキーソート | E-01 (行458) | ○ |
| C-17 | results-merged.sarifに出力 | E-01 (行457) | ○ |
| C-18 | sort_filesパラメータでテスト用ソート | E-01 (行360, 434-436) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 比較的シンプルなマージロジックで全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] merge_sarif_files()の再帰ロジックが正確か確認
- [ ] 埋め込みリンク更新の正規表現パターンが正確か確認
- [ ] runs_countオフセット計算が正確か確認
- [ ] json.dump()のオプションが正確か確認
