---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-HTMLReport (include-cleaner)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `clang-tools-extra/include-cleaner/lib/HTMLReport.cpp` 行1-538
- E-02: 帳票一覧.csv 行8

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ref構造体がOffset/Type/Sym等を保持 | E-01 (行147-156) | ○ |
| C-02 | CSS定数でスタイル定義 | E-01 (行33-70) | ○ |
| C-03 | JS定数でselect()/fillHover()定義 | E-01 (行72-94) | ○ |
| C-04 | .ref/.incクラスで下線・青色 | E-01 (行45) | ○ |
| C-05 | .ref.implicitで黄色背景 | E-01 (行47) | ○ |
| C-06 | .missingで赤背景 | E-01 (行59) | ○ |
| C-07 | .unusedで赤背景 | E-01 (行59) | ○ |
| C-08 | .insertedで緑背景 | E-01 (行60) | ○ |
| C-09 | .semiusedでグレー背景 | E-01 (行61) | ○ |
| C-10 | Reporterクラスがメイン実装 | E-01 (行135-495) | ○ |
| C-11 | addRef()で参照情報収集 | E-01 (行204-222) | ○ |
| C-12 | fillTarget()で提供元情報設定 | E-01 (行172-194) | ○ |
| C-13 | locateSymbol()でシンボル位置取得 | E-01 (行174-175) | ○ |
| C-14 | headersForSymbol()でヘッダー取得 | E-01 (行176) | ○ |
| C-15 | Includes.match()でマッチ | E-01 (行179) | ○ |
| C-16 | spellHeader()でインクルードパス生成 | E-01 (行192-193) | ○ |
| C-17 | write()でHTML出力 | E-01 (行224-252) | ○ |
| C-18 | writeCode()でソースコード出力 | E-01 (行408-494) | ○ |
| C-19 | escapeChar()/escapeString()でエスケープ | E-01 (行255-271) | ○ |
| C-20 | writeHTMLReport()がエントリーポイント | E-01 (行499-535) | ○ |
| C-21 | walkAST()でRoots走査 | E-01 (行506-528) | ○ |
| C-22 | ファイル外参照時に警告出力 | E-01 (行209-212) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルの実装で全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Ref構造体のフィールドが正確か確認
- [ ] CSSクラス名とスタイルが正確か確認
- [ ] writeHTMLReport()の処理フローが正確か確認
- [ ] escapeChar()のエスケープ対象文字が正確か確認
