---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Test Report (JUnit/Markdown)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `.ci/generate_test_report_lib.py` 行1-361
- E-02: 帳票一覧.csv 行9

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailureExplanation TypedDictを定義 | E-01 (行14-17) | ○ |
| C-02 | generate_report()がエントリーポイント | E-01 (行176-329) | ○ |
| C-03 | get_failures()でJUnitから失敗抽出 | E-01 (行141-156, 185) | ○ |
| C-04 | testsuite.tests/skipped/failuresで統計取得 | E-01 (行202-206) | ○ |
| C-05 | tests_run==0時のビルド失敗処理 | E-01 (行210-251) | ○ |
| C-06 | find_failure_in_ninja_logs()でninjaログ解析 | E-01 (行87-106, 219, 284) | ○ |
| C-07 | _parse_ninja_log()で"FAILED:"行解析 | E-01 (行31-84) | ○ |
| C-08 | NINJA_LOG_SIZE_THRESHOLD=500 | E-01 (行28) | ○ |
| C-09 | _format_failures()でHTML詳細タグ生成 | E-01 (行109-138) | ○ |
| C-10 | `<details>/<summary>`で折りたたみ | E-01 (行119, 129, 135) | ○ |
| C-11 | failure_explanationsで既知失敗識別 | E-01 (行117-127, 190-200) | ○ |
| C-12 | "Likely Already Failing"表示 | E-01 (行123) | ○ |
| C-13 | size_limit=1024*1024 | E-01 (行181) | ○ |
| C-14 | サイズ超過時list_failures=Falseで再生成 | E-01 (行319-328) | ○ |
| C-15 | UNRELATED_FAILURES_STR表示 | E-01 (行21-26, 234, 249, 316) | ○ |
| C-16 | SEE_BUILD_FILE_STR表示 | E-01 (行20, 231, 270, 295) | ○ |
| C-17 | are_all_failures_explained()で判定 | E-01 (行159-167) | ○ |
| C-18 | compute_platform_title()でタイトル生成 | E-01 (行353-361) | ○ |
| C-19 | load_info_from_files()でファイル読込 | E-01 (行332-345) | ○ |
| C-20 | JUnitXml.fromfile()でXML解析 | E-01 (行345) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Pythonコードで読みやすく、全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] generate_report()の処理フローが正確か確認
- [ ] _parse_ninja_log()のパースロジックが正確か確認
- [ ] サイズ制限の再帰呼出しロジックが正確か確認
- [ ] failure_explanationsの使用方法が正確か確認
