---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：9-ASan Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ErrorDescription構造体の詳細**：asan_errors.hの参照が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `compiler-rt/lib/asan/asan_report.cpp` 行1-625
- E-02: `compiler-rt/lib/asan/asan_report.h` 行1-108
- E-03: 帳票一覧.csv 行10

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReportGenericError()がメインレポート関数 | E-01 (行514-536), E-02 (行50-51) | ○ |
| C-02 | ScopedInErrorReportでロックとレポート管理 | E-01 (行126-241) | ○ |
| C-03 | コンストラクタで区切り線出力 | E-01 (行162-163) | ○ |
| C-04 | asanThreadRegistry().Lock()でロック取得 | E-01 (行161) | ○ |
| C-05 | ReportError()でエラー登録 | E-01 (行225-229) | ○ |
| C-06 | デストラクタでErrorDescription.Print() | E-01 (行172) | ○ |
| C-07 | DescribeThread()でスレッド情報出力 | E-01 (行175) | ○ |
| C-08 | LogFullErrorReport()でログ出力 | E-01 (行200) | ○ |
| C-09 | error_report_callback呼出 | E-01 (行202-204) | ○ |
| C-10 | halt_on_error時にDie() | E-01 (行219-222) | ○ |
| C-11 | ReportDoubleFree()で二重解放報告 | E-01 (行251-255), E-02 (行56) | ○ |
| C-12 | ReportDeadlySignal()で致命的シグナル報告 | E-01 (行245-249), E-02 (行52) | ○ |
| C-13 | SuppressErrorReport()で重複抑制 | E-01 (行502-512) | ○ |
| C-14 | AsanBuggyPcPoolで同一PC管理 | E-01 (行43-44, 504-511) | ○ |
| C-15 | __asan_report_error()がインターフェース | E-01 (行543-548) | ○ |
| C-16 | __asan_set_error_report_callback()でコールバック設定 | E-01 (行550-553) | ○ |
| C-17 | __asan_describe_address()でアドレス説明 | E-01 (行555-560) | ○ |
| C-18 | PrintMemoryByte()でメモリバイト表示 | E-01 (行62-68), E-02 (行41-42) | ○ |
| C-19 | ParseFrameDescription()でフレーム解析 | E-01 (行87-120), E-02 (行46-47) | ○ |
| C-20 | StackVarDescr構造体でスタック変数情報保持 | E-02 (行23-29) | ○ |
| C-21 | error_message_bufferでエラーメッセージ蓄積 | E-01 (行37-42, 46-58) | ○ |
| C-22 | Decoratorでカラー出力 | E-01 (行64-67) | ○ |
| C-23 | CheckForInvalidPointerPair()でポインタペアチェック | E-01 (行468-485) | ○ |
| C-24 | __asan_on_error()でユーザーハンドリング | E-01 (行624) | ○ |
| C-25 | ErrorDescription構造体の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: asan_errors.hの内容を参照していないため、ErrorDescriptionの詳細構造は要確認
  - 候補：`compiler-rt/lib/asan/asan_errors.h`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なレポート関数は十分な根拠あり
- 1: 中リスク - ErrorDescription構造体の詳細はasan_errors.h参照推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ScopedInErrorReportのロック/アンロックが正確か確認
- [ ] ReportGenericError()のパラメータが正確か確認
- [ ] エラー種別と対応するReport*関数の対応が正確か確認
- [ ] asan_errors.hを参照してErrorDescription構造体を確認
