---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **BR-036 SYCLサポート**：libsyclの詳細実装状況の確認が必要
  2. **BR-037 OpenCLサポート**：libclcの成熟度確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/README.txt` - LLVM Coreの概要説明
- E-02: `clang/README.txt` - Clang Frontendの概要説明
- E-03: `lld/README.md` - LLDリンカーの概要説明
- E-04: `lldb/README.md` - LLDBデバッガーの概要説明
- E-05: `flang/README.md` - Flang Fortranコンパイラの概要説明
- E-06: `bolt/README.md` - BOLTバイナリオプティマイザの概要説明
- E-07: `mlir/README.md` - MLIRの概要説明
- E-08: `libcxx/README.txt` - libc++標準ライブラリの説明
- E-09: `compiler-rt/README.txt` - compiler-rtランタイムの説明
- E-10: `openmp/README.rst` - OpenMPランタイムの説明
- E-11: `clang-tools-extra/README.txt` - Clang追加ツールの説明
- E-12: `clang/lib/Lex/` - 字句解析の実装ディレクトリ
- E-13: `clang/lib/Parse/` - 構文解析の実装ディレクトリ
- E-14: `clang/lib/Sema/` - セマンティック解析の実装ディレクトリ
- E-15: `clang/lib/CodeGen/` - LLVM IR生成の実装ディレクトリ
- E-16: `llvm/lib/Transforms/` - 最適化パスの実装ディレクトリ
- E-17: `llvm/lib/CodeGen/` - マシンコード生成の実装ディレクトリ
- E-18: `llvm/lib/Target/` - ターゲットアーキテクチャの実装ディレクトリ
- E-19: `lld/ELF/` - ELFリンカーの実装ディレクトリ
- E-20: `lld/COFF/` - COFFリンカーの実装ディレクトリ
- E-21: `lld/MachO/` - Mach-Oリンカーの実装ディレクトリ
- E-22: `lld/wasm/` - WebAssemblyリンカーの実装ディレクトリ
- E-23: `lldb/source/Breakpoint/` - ブレークポイント管理の実装
- E-24: `lldb/source/Expression/` - 式評価の実装
- E-25: `clang/lib/StaticAnalyzer/` - 静的解析の実装
- E-26: `clang-tools-extra/clang-tidy/` - clang-tidyの実装
- E-27: `clang-tools-extra/clang-format/` - clang-formatの実装
- E-28: `clang-tools-extra/clangd/` - clangdの実装
- E-29: `llvm/lib/ExecutionEngine/` - JIT実行エンジンの実装
- E-30: `llvm/tools/lli/` - LLVMインタープリタの実装
- E-31: `libcxxabi/` - C++ ABIの実装ディレクトリ
- E-32: `libunwind/` - スタックアンワインドの実装ディレクトリ
- E-33: `llvm/lib/DebugInfo/` - デバッグ情報処理の実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| BR-001 | ソースコードのコンパイル | E-01, E-02 | ○ |
| BR-002 | 複数言語対応 | E-02, E-05 | ○ |
| BR-003 | 字句解析処理 | E-12 | ○ |
| BR-004 | 構文解析処理 | E-13 | ○ |
| BR-005 | セマンティック解析 | E-14 | ○ |
| BR-006 | 中間表現生成 | E-15 | ○ |
| BR-007 | コード最適化 | E-16 | ○ |
| BR-008 | プロファイルガイド最適化 | E-09, E-16 | ○ |
| BR-009 | リンクタイム最適化 | E-03, E-16 | ○ |
| BR-010 | バイナリポスト最適化 | E-06 | ○ |
| BR-011 | マシンコード生成 | E-17 | ○ |
| BR-012 | 複数アーキテクチャ対応 | E-18 | ○ |
| BR-013 | 命令選択処理 | E-17 | ○ |
| BR-014 | レジスタ割り当て | E-17 | ○ |
| BR-015 | 命令スケジューリング | E-17 | ○ |
| BR-016 | オブジェクトファイルリンク | E-03, E-19 | ○ |
| BR-017 | 複数オブジェクト形式対応 | E-19, E-20, E-21, E-22 | ○ |
| BR-018 | シンボル解決 | E-19 | ○ |
| BR-019 | リロケーション処理 | E-19 | ○ |
| BR-020 | ソースレベルデバッグ | E-04 | ○ |
| BR-021 | デバッグ情報生成 | E-33 | ○ |
| BR-022 | ブレークポイント管理 | E-23 | ○ |
| BR-023 | 式評価 | E-24 | ○ |
| BR-024 | 静的コード分析 | E-25 | ○ |
| BR-025 | コーディング規約チェック | E-26 | ○ |
| BR-026 | コード整形 | E-27 | ○ |
| BR-027 | 言語サーバー機能 | E-28 | ○ |
| BR-028 | ドキュメント生成 | E-11 | ○ |
| BR-029 | JITコンパイル実行 | E-29 | ○ |
| BR-030 | LLVMインタープリタ実行 | E-30 | ○ |
| BR-031 | C++標準ライブラリ提供 | E-08 | ○ |
| BR-032 | C++ABI提供 | E-31 | ○ |
| BR-033 | コンパイラランタイム提供 | E-09 | ○ |
| BR-034 | スタックアンワインド機能 | E-32 | ○ |
| BR-035 | OpenMPサポート | E-10 | ○ |
| BR-036 | SYCLサポート | **根拠なし** | △ |
| BR-037 | OpenCLサポート | **根拠なし** | △ |
| BR-038 | 多層中間表現処理 | E-07 | ○ |
| BR-039 | ビットコード変換 | E-01 | ○ |
| BR-040 | アーカイブ操作 | E-01 | ○ |
| BR-041 | オブジェクトファイル解析 | E-01 | ○ |
| BR-042 | Linuxプラットフォーム対応 | E-19 | ○ |
| BR-043 | Windowsプラットフォーム対応 | E-20 | ○ |
| BR-044 | macOSプラットフォーム対応 | E-21 | ○ |
| BR-045 | WebAssembly対応 | E-22 | ○ |
| BR-046 | エラー・警告出力 | E-02 | ○ |
| BR-047 | ソースコード位置表示 | E-02 | ○ |
| BR-048 | 新言語フロントエンド追加 | E-01 | ○ |
| BR-049 | 新ターゲット追加 | E-18 | ○ |
| BR-050 | 最適化パス追加 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-036 SYCLサポート**: libsyclディレクトリは存在するが、詳細なREADMEやドキュメントが確認できなかった
  - 候補：libsycl/README.md / libsycl/docs/ / SYCL仕様書
- **BR-037 OpenCLサポート**: libclcディレクトリは存在するが、詳細な機能説明が確認できなかった
  - 候補：libclc/README.txt / libclc/docs/ / OpenCL仕様書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分の業務要件はソースコードとドキュメントで十分に裏付けられている
- **1: 中リスク** - BR-036, BR-037は実装の成熟度について追加確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 主要コンポーネント（Clang/LLVM/LLD/LLDB）の機能説明が正確か確認
- [ ] 各業務要件の優先度設定が適切か確認
- [ ] 複数アーキテクチャ対応の具体的なターゲット一覧が最新か確認
- [ ] BR-036(SYCL), BR-037(OpenCL)の実装状況を追加調査
- [ ] 関連機能列の記載がソースコードのディレクトリ構造と一致しているか確認
