---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-101 ClangIR（CIR）**：開発中機能のため詳細確認推奨
  2. **C-100 llvm-ir2vec**：新規ツールのため機能詳細の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルート）
- E-02: `llvm/README.txt`
- E-03: `clang/README.md`
- E-04: `lld/README.md`
- E-05: `lldb/Maintainers.md`
- E-06: `mlir/README.md`
- E-07: `flang/README.md`
- E-08: `bolt/README.md`
- E-09: `compiler-rt/README.txt`
- E-10: `polly/README`
- E-11: `llvm/tools/` ディレクトリ構造
- E-12: `clang/tools/` ディレクトリ構造
- E-13: `clang-tools-extra/` ディレクトリ構造
- E-14: `libcxx/` ディレクトリ構造
- E-15: `libc/` ディレクトリ構造
- E-16: `openmp/` ディレクトリ構造
- E-17: `offload/` ディレクトリ構造
- E-18: `libsycl/` ディレクトリ構造
- E-19: `libclc/` ディレクトリ構造
- E-20: `llvm-libgcc/` ディレクトリ構造
- E-21: `orc-rt/` ディレクトリ構造
- E-22: `flang-rt/` ディレクトリ構造
- E-23: `libcxxabi/` ディレクトリ構造
- E-24: `libunwind/` ディレクトリ構造

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLVM Core - 中間表現処理基盤 | E-01, E-02 | ○ |
| C-02 | llc - 静的コンパイラ | E-11 | ○ |
| C-03 | lli - JITコンパイラ/インタプリタ | E-11 | ○ |
| C-04 | opt - 最適化ツール | E-11 | ○ |
| C-05 | Clang - C/C++フロントエンド | E-01, E-03 | ○ |
| C-06 | Flang - Fortranフロントエンド | E-07 | ○ |
| C-07 | LLD - リンカ | E-01, E-04 | ○ |
| C-08 | LLDB - デバッガ | E-05 | ○ |
| C-09 | MLIR - 中間表現フレームワーク | E-06 | ○ |
| C-10 | Polly - ループ最適化 | E-10 | ○ |
| C-11 | BOLT - バイナリ最適化 | E-08 | ○ |
| C-12 | Compiler-RT - サポートルーチン | E-09 | ○ |
| C-13 | libc++ - C++標準ライブラリ | E-01, E-14 | ○ |
| C-14 | libc++abi - C++ ABIライブラリ | E-23 | ○ |
| C-15 | libc - Cライブラリ | E-15 | ○ |
| C-16 | libunwind - スタックアンワインド | E-24 | ○ |
| C-17 | OpenMP - 並列処理ランタイム | E-16 | ○ |
| C-18 | Offload - オフロードランタイム | E-17 | ○ |
| C-19 | libSYCL - SYCLランタイム | E-18 | ○ |
| C-20 | libclc - OpenCL Cライブラリ | E-19 | ○ |
| C-21 | llvm-libgcc - GCC互換レイヤー | E-20 | ○ |
| C-22 | ORC-RT - JITランタイム | E-21 | ○ |
| C-23 | Flang-RT - Flangランタイム | E-22 | ○ |
| C-24 | llvm-as - アセンブラ | E-11 | ○ |
| C-25 | llvm-dis - 逆アセンブラ | E-11 | ○ |
| C-26 | llvm-mc - MCツール | E-11 | ○ |
| C-27 | llvm-objdump - オブジェクトダンプ | E-11 | ○ |
| C-28 | llvm-readobj - オブジェクト読み取り | E-11 | ○ |
| C-29 | llvm-nm - シンボルテーブル表示 | E-11 | ○ |
| C-30 | llvm-size - サイズ表示 | E-11 | ○ |
| C-31 | llvm-objcopy - オブジェクトコピー | E-11 | ○ |
| C-32 | llvm-ar - アーカイブ管理 | E-11 | ○ |
| C-33 | llvm-link - モジュールリンク | E-11 | ○ |
| C-34 | llvm-split - モジュール分割 | E-11 | ○ |
| C-35 | llvm-extract - 関数抽出 | E-11 | ○ |
| C-36 | llvm-dwarfdump - DWARFダンプ | E-11 | ○ |
| C-37 | llvm-dwarfutil - DWARFユーティリティ | E-11 | ○ |
| C-38 | llvm-dwp - DWPツール | E-11 | ○ |
| C-39 | llvm-symbolizer - シンボル変換 | E-11 | ○ |
| C-40 | dsymutil - macOSデバッグシンボル | E-11 | ○ |
| C-41 | llvm-profdata - プロファイルデータ | E-11 | ○ |
| C-42 | llvm-profgen - プロファイル生成 | E-11 | ○ |
| C-43 | llvm-cov - カバレッジ可視化 | E-11 | ○ |
| C-44 | llvm-lto - LTOツール | E-11 | ○ |
| C-45 | llvm-lto2 - LTO2ツール | E-11 | ○ |
| C-46 | llvm-jitlink - JITリンカ | E-11 | ○ |
| C-47 | llvm-rtdyld - ランタイムリンカ | E-11 | ○ |
| C-48 | llvm-mca - パイプラインシミュレーション | E-11 | ○ |
| C-49 | llvm-exegesis - 命令ベンチマーク | E-11 | ○ |
| C-50 | llvm-xray - XRay解析 | E-11 | ○ |
| C-51 | llvm-bcanalyzer - ビットコード解析 | E-11 | ○ |
| C-52 | llvm-diff - モジュール差分 | E-11 | ○ |
| C-53 | llvm-sim - コード類似性検出 | E-11 | ○ |
| C-54 | llvm-reduce - テストケース削減 | E-11 | ○ |
| C-55 | bugpoint - バグ特定支援 | E-11 | ○ |
| C-56 | llvm-config - 設定情報出力 | E-11 | ○ |
| C-57 | llvm-cxxfilt - C++デマングル | E-11 | ○ |
| C-58 | llvm-undname - MSデマングル | E-11 | ○ |
| C-59 | llvm-rc - リソースコンパイラ | E-11 | ○ |
| C-60 | llvm-cvtres - リソース変換 | E-11 | ○ |
| C-61 | llvm-mt - マニフェストツール | E-11 | ○ |
| C-62 | llvm-pdbutil - PDB解析 | E-11 | ○ |
| C-63 | llvm-ifs - インターフェーススタブ | E-11 | ○ |
| C-64 | obj2yaml - YAML変換 | E-11 | ○ |
| C-65 | yaml2obj - オブジェクト変換 | E-11 | ○ |
| C-66 | llvm-lipo - ユニバーサルバイナリ | E-11 | ○ |
| C-67 | llvm-libtool-darwin - macOSライブラリ | E-11 | ○ |
| C-68 | llvm-readtapi - TAPI読み取り | E-11 | ○ |
| C-69 | llvm-gsymutil - GSYMユーティリティ | E-11 | ○ |
| C-70 | clang-format - コードフォーマット | E-12 | ○ |
| C-71 | Clang Static Analyzer - 静的解析 | E-03, E-12 | ○ |
| C-72 | clang-tidy - Linting | E-13 | ○ |
| C-73 | clangd - Language Server | E-13 | ○ |
| C-74 | clang-check - 構文チェック | E-12 | ○ |
| C-75 | clang-refactor - リファクタリング | E-12 | ○ |
| C-76 | clang-diff - AST差分 | E-12 | ○ |
| C-77 | clang-doc - ドキュメント生成 | E-13 | ○ |
| C-78 | include-cleaner - インクルード整理 | E-13 | ○ |
| C-79 | clang-include-fixer - インクルード修正 | E-13 | ○ |
| C-80 | clang-change-namespace - 名前空間変更 | E-13 | ○ |
| C-81 | clang-move - コード移動 | E-13 | ○ |
| C-82 | clang-reorder-fields - フィールド並替 | E-13 | ○ |
| C-83 | clang-query - ASTクエリ | E-13 | ○ |
| C-84 | pp-trace - プリプロセッサトレース | E-13 | ○ |
| C-85 | modularize - モジュール化支援 | E-13 | ○ |
| C-86 | clang-repl - C++ REPL | E-12 | ○ |
| C-87 | clang-scan-deps - 依存関係スキャン | E-12 | ○ |
| C-88 | clang-offload-bundler - オフロードバンドル | E-12 | ○ |
| C-89 | clang-linker-wrapper - リンカラッパー | E-12 | ○ |
| C-90 | clang-sycl-linker - SYCLリンカ | E-12 | ○ |
| C-91 | diagtool - 診断ツール | E-12 | ○ |
| C-92 | libclang - C言語API | E-12 | ○ |
| C-93 | llvm-cfi-verify - CFI検証 | E-11 | ○ |
| C-94 | sancov - サニタイザカバレッジ | E-11 | ○ |
| C-95 | sanstats - サニタイザ統計 | E-11 | ○ |
| C-96 | llvm-stress - ストレステスト | E-11 | ○ |
| C-97 | llvm-strings - 文字列検索 | E-11 | ○ |
| C-98 | spirv-tools - SPIR-Vツール | E-11 | ○ |
| C-99 | dxil-dis - DXIL逆アセンブラ | E-11 | ○ |
| C-100 | llvm-ir2vec - IR to Vector | E-11 | △ |
| C-101 | ClangIR（CIR） | E-12 | △ |
| C-102 | llvm-debuginfod - debuginfoサーバー | E-11 | ○ |
| C-103 | llvm-debuginfod-find - debuginfoクライアント | E-11 | ○ |
| C-104 | llvm-cas - CASツール | E-11 | ○ |
| C-105 | llvm-modextract - モジュール抽出 | E-11 | ○ |
| C-106 | llvm-remarkutil - 備考ユーティリティ | E-11 | ○ |
| C-107 | llvm-opt-report - 最適化レポート | E-11 | ○ |
| C-108 | llvm-tli-checker - TLI検証 | E-11 | ○ |
| C-109 | llvm-gpu-loader - GPUローダー | E-11 | ○ |
| C-110 | llvm-offload-binary - オフロードバイナリ | E-11 | ○ |
| C-111 | llvm-debuginfo-analyzer - デバッグ情報解析 | E-11 | ○ |
| C-112 | llvm-cxxdump - C++ダンプ | E-11 | ○ |
| C-113 | llvm-cxxmap - プロファイルマップ | E-11 | ○ |
| C-114 | llvm-ctxprof-util - コンテキストプロファイル | E-11 | ○ |
| C-115 | llvm-cgdata - コードグラフデータ | E-11 | ○ |
| C-116 | llvm-cat - ビットコード結合 | E-11 | ○ |
| C-117 | llvm-ml - MASMアセンブラ | E-11 | ○ |
| C-118 | gold - goldプラグイン | E-11 | ○ |
| C-119 | clang-nvlink-wrapper - NVIDIAラッパー | E-12 | ○ |
| C-120 | clang-installapi - Install API | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-100 llvm-ir2vec：新規機能のため詳細なドキュメントが不足
  - 候補：llvm/tools/llvm-ir2vec/README.md / 公式ドキュメント / 関連論文
- C-101 ClangIR（CIR）：開発中の実験的機能のため仕様が安定していない
  - 候補：clang/docs/ / MLIR連携ドキュメント / RFC/設計文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の機能はディレクトリ構造とREADMEから確認済み
- 1: 中リスク - 新規/実験的機能（IR2Vec, CIR）の説明精度
- 0: 低リスク - ツール名と機能の対応は公式命名規則に準拠

## 6) レビュアーチェックリスト（最小）
- [ ] 主要サブプロジェクト（LLVM, Clang, LLD, LLDB, MLIR, Flang）の説明が正確か
- [ ] ツール名とディレクトリパスの対応が正しいか
- [ ] カテゴリ分類が適切か（コアインフラ、フロントエンド、ツール等）
- [ ] 新規/実験的機能（IR2Vec, CIR）の説明を公式ドキュメントと照合
- [ ] 抜け漏れがある主要機能がないか確認
