# 機能設計書 1-LLVM Core

## 概要

本ドキュメントは、LLVM Coreライブラリの機能設計を記述する。LLVM Coreは、LLVM中間表現（IR）の処理、最適化、コード生成のための基盤ライブラリとツール群であり、LLVMプロジェクト全体の中核を成すコンポーネントである。

### 本機能の処理概要

LLVM Coreは、コンパイラインフラストラクチャの中心的な役割を担い、ソースコードから機械語への変換過程における中間表現の生成、変換、最適化を行う。

**業務上の目的・背景**：コンパイラ開発において、フロントエンド（言語解析）とバックエンド（コード生成）を分離し、共通の中間表現を介することで、複数の言語と複数のターゲットアーキテクチャをサポートする効率的なコンパイラ基盤を提供する。これにより、言語開発者はLLVM IRを生成するだけで、多数のプラットフォーム向けのコード生成と最適化を得られる。

**機能の利用シーン**：
- 新しいプログラミング言語のコンパイラ開発時のバックエンドとして
- 既存言語の新しいターゲットアーキテクチャへの移植時
- プログラム解析・最適化ツールの開発基盤として
- JITコンパイラの実行エンジンとして

**主要な処理内容**：
1. LLVM IR（中間表現）の生成・解析・変換
2. モジュール、関数、基本ブロック、命令の階層構造管理
3. 型システムと値のシンボルテーブル管理
4. メタデータとデバッグ情報の管理
5. パスマネージャによる最適化パイプラインの実行
6. ターゲット非依存の最適化パスの提供

**関連システム・外部連携**：
- Clang/Flang等のフロントエンドコンパイラとの連携
- ターゲット固有バックエンド（X86, ARM, RISC-V等）との連携
- LLD（リンカ）との連携
- LLDB（デバッガ）との連携

**権限による制御**：特になし（ライブラリとして利用される）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | LLVM Coreはライブラリであり、直接的なGUI画面は持たない |

## 機能種別

ライブラリ / コンパイラ基盤 / データ変換処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ModuleID | StringRef | Yes | モジュール識別子 | 空文字列可 |
| LLVMContext | LLVMContext& | Yes | LLVM実行コンテキスト | 有効なコンテキスト参照 |
| SourceFileName | StringRef | No | ソースファイル名 | 有効なファイルパス |
| TargetTriple | StringRef | No | ターゲットアーキテクチャ指定 | 有効なトリプル形式 |
| DataLayout | StringRef | No | データレイアウト文字列 | 有効なレイアウト形式 |

### 入力データソース

- LLVMビットコードファイル（.bc）
- LLVMアセンブリファイル（.ll）
- フロントエンドコンパイラからのIR生成API呼び出し
- IRBuilder APIによるプログラム的なIR構築

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Module | Module* | 最適化されたLLVMモジュール |
| Bitcode | raw_ostream | シリアライズされたビットコード |
| Assembly | raw_ostream | LLVM IR テキスト形式 |
| DiagnosticInfo | DiagnosticInfo | 診断情報（警告・エラー） |

### 出力先

- LLVMビットコードファイル（.bc）
- LLVMアセンブリファイル（.ll）
- 後続の最適化パスやコード生成パス
- 診断出力（stderr）

## 処理フロー

### 処理シーケンス

```
1. LLVMContext初期化
   └─ グローバルな型情報・メタデータ管理の初期化
2. Module生成
   └─ モジュール識別子とコンテキストの紐付け
3. IR構築
   └─ 関数・グローバル変数・型の定義
4. 検証（Verifier）
   └─ IR整合性チェック
5. 最適化パス適用
   └─ PassManagerによるパスパイプライン実行
6. 出力生成
   └─ ビットコードまたはアセンブリ形式での出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[LLVMContext初期化]
    B --> C[Module生成]
    C --> D[IR構築/読み込み]
    D --> E{Verifier実行}
    E -->|成功| F[最適化パス適用]
    E -->|失敗| G[エラー報告]
    F --> H{出力形式選択}
    H -->|ビットコード| I[Bitcode出力]
    H -->|アセンブリ| J[Assembly出力]
    H -->|継続処理| K[後続パスへ]
    I --> L[終了]
    J --> L
    K --> L
    G --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | SSA形式遵守 | すべての値はSSA（Static Single Assignment）形式で管理される | IR構築時 |
| BR-002 | 型安全性 | すべての命令は型チェックを通過する必要がある | Verifier実行時 |
| BR-003 | 支配関係 | 使用される値はその使用点を支配する定義を持つ必要がある | Verifier実行時 |
| BR-004 | PHI配置 | PHIノードは基本ブロックの先頭に配置される | IR構築時 |

### 計算ロジック

- 型サイズ計算：DataLayoutに基づくターゲット依存のサイズ算出
- アライメント計算：型とターゲットに基づくアライメント値決定
- 定数畳み込み：コンパイル時に評価可能な定数式の事前計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | LLVM Coreはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| VERIFY_FAIL | 検証エラー | IR整合性違反 | エラーメッセージを確認しIRを修正 |
| PARSE_ERROR | 解析エラー | 不正なビットコード/アセンブリ | 入力ファイルの形式を確認 |
| CONTEXT_ERROR | コンテキストエラー | 異なるコンテキスト間での値参照 | 同一コンテキストを使用 |
| OOM | メモリ不足 | 大規模モジュール処理時 | メモリ増加またはモジュール分割 |

### リトライ仕様

エラー発生時のリトライは行わない。エラーは診断情報として報告される。

## トランザクション仕様

LLVM Coreはデータベーストランザクションを使用しない。IR変換はメモリ上で行われ、明示的な保存操作により永続化される。

## パフォーマンス要件

- 大規模モジュール（数万関数）の処理が可能
- 増分コンパイルのサポート（ThinLTO）
- マルチスレッド対応（ThreadSafeContext）

## セキュリティ考慮事項

- 入力IRの検証によるバッファオーバーフロー防止
- 未定義動作の検出と報告
- サニタイザとの統合サポート

## 備考

LLVM Coreは継続的に開発が進められており、新しい最適化パスやターゲットアーキテクチャのサポートが追加されている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、LLVM IRの基本的なデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Value.h | `llvm/include/llvm/IR/Value.h` | すべてのIR値の基底クラス |
| 1-2 | Type.h | `llvm/include/llvm/IR/Type.h` | LLVM型システムの基本 |
| 1-3 | Module.h | `llvm/include/llvm/IR/Module.h` | モジュール構造の定義 |
| 1-4 | Function.h | `llvm/include/llvm/IR/Function.h` | 関数の表現 |
| 1-5 | BasicBlock.h | `llvm/include/llvm/IR/BasicBlock.h` | 基本ブロックの表現 |
| 1-6 | Instruction.h | `llvm/include/llvm/IR/Instruction.h` | 命令の基底クラス |

**読解のコツ**: LLVMのIR階層は `Module > Function > BasicBlock > Instruction` の順に入れ子になっている。それぞれがValueを継承しており、use-def関係で接続されている。

#### Step 2: エントリーポイントを理解する

Module.cppはモジュールの実装を含む中心的なファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Module.cpp | `llvm/lib/IR/Module.cpp` | モジュールの初期化と管理 |

**主要処理フロー**:
1. **73-77行目**: Moduleコンストラクタ - LLVMContextへの登録
2. **118-125行目**: デストラクタ - リソース解放処理
3. **177-179行目**: getNamedValue - シンボル検索
4. **211-226行目**: getOrInsertFunction - 関数の取得または挿入

#### Step 3: コンテキスト管理を理解する

LLVMContextはグローバルな状態を管理する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LLVMContext.cpp | `llvm/lib/IR/LLVMContext.cpp` | コンテキストの実装 |
| 3-2 | LLVMContextImpl.cpp | `llvm/lib/IR/LLVMContextImpl.cpp` | コンテキストの内部実装 |

**主要処理フロー**:
- コンテキスト内での型のユニーク化
- メタデータIDの管理
- 診断ハンドラの登録

#### Step 4: パスマネージャを理解する

最適化パイプラインの管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PassManager.cpp | `llvm/lib/IR/PassManager.cpp` | 新パスマネージャ |
| 4-2 | LegacyPassManager.cpp | `llvm/lib/IR/LegacyPassManager.cpp` | レガシーパスマネージャ |

### プログラム呼び出し階層図

```
LLVMContext
    │
    ├─ Module
    │      ├─ GlobalList (GlobalVariable)
    │      ├─ FunctionList (Function)
    │      │      ├─ BasicBlockList (BasicBlock)
    │      │      │      └─ InstList (Instruction)
    │      │      └─ ArgumentList (Argument)
    │      ├─ AliasList (GlobalAlias)
    │      └─ NamedMDList (NamedMDNode)
    │
    └─ TypeContext
           ├─ IntegerTypes
           ├─ PointerTypes
           └─ StructTypes
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ソースコード ──▶ フロントエンド ──▶ LLVM IR (Module)
                                           │
                                           ▼
                                    ┌─────────────┐
                                    │ PassManager │
                                    │ (最適化)     │
                                    └─────────────┘
                                           │
                                           ▼
                               最適化済み LLVM IR ──▶ ビットコード(.bc)
                                           │
                                           ▼
                                      アセンブリ(.ll)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Module.cpp | `llvm/lib/IR/Module.cpp` | ソース | モジュール実装 |
| Module.h | `llvm/include/llvm/IR/Module.h` | ヘッダ | モジュール定義 |
| Value.cpp | `llvm/lib/IR/Value.cpp` | ソース | 値の基本実装 |
| Type.cpp | `llvm/lib/IR/Type.cpp` | ソース | 型システム実装 |
| Function.cpp | `llvm/lib/IR/Function.cpp` | ソース | 関数実装 |
| BasicBlock.cpp | `llvm/lib/IR/BasicBlock.cpp` | ソース | 基本ブロック実装 |
| Instruction.cpp | `llvm/lib/IR/Instruction.cpp` | ソース | 命令基底クラス実装 |
| Instructions.cpp | `llvm/lib/IR/Instructions.cpp` | ソース | 各種命令実装 |
| Constants.cpp | `llvm/lib/IR/Constants.cpp` | ソース | 定数実装 |
| LLVMContext.cpp | `llvm/lib/IR/LLVMContext.cpp` | ソース | コンテキスト実装 |
| PassManager.cpp | `llvm/lib/IR/PassManager.cpp` | ソース | パスマネージャ実装 |
| Verifier.cpp | `llvm/lib/IR/Verifier.cpp` | ソース | IR検証器実装 |
| AsmWriter.cpp | `llvm/lib/IR/AsmWriter.cpp` | ソース | アセンブリ出力 |
| IRBuilder.cpp | `llvm/lib/IR/IRBuilder.cpp` | ソース | IR構築ヘルパー |
