# 機能設計書 100-llvm-ir2vec

## 概要

本ドキュメントは、LLVMプロジェクトにおけるllvm-ir2vec（IR2Vec/MIR2Vec埋め込み生成ツール）の機能設計書である。llvm-ir2vecは、LLVM IRおよびMachine IRから機械学習向けのベクトル表現（埋め込み）を生成するツールである。

### 本機能の処理概要

llvm-ir2vecは、LLVM IRまたはMachine IR（MIR）を入力として、機械学習モデルで使用可能なベクトル表現を生成する。語彙学習用のトリプレット生成とエンティティマッピング生成、および学習済み語彙を用いた埋め込み生成の3つのサブコマンドを提供する。

**業務上の目的・背景**：コンパイラ最適化やプログラム解析において、機械学習技術の活用が進んでいる。LLVM IR/MIRをベクトル空間に埋め込むことで、コード類似性分析、最適化予測、欠陥検出などの機械学習タスクが可能になる。

**機能の利用シーン**：
- 機械学習モデルの学習データ生成
- コード類似性分析
- コンパイラ最適化の予測
- プログラム解析・理解

**主要な処理内容**：
1. triplets: 語彙学習用トリプレット（head, tail, relation）生成
2. entities: エンティティマッピング生成
3. embeddings: 学習済み語彙を用いた埋め込み生成

**関連システム・外部連携**：IR2Vec/MIR2Vec分析パス（LLVMライブラリ）と連携する。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | 各サブコマンドの実行 |

## 機能種別

解析ツール / 機械学習支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| subcommand | enum | Yes | triplets/entities/embeddings | 3種から選択 |
| input file | string | No | 入力ファイル（デフォルト: 標準入力） | .bc/.mir |
| -mode | enum | No | llvm/mir（デフォルト: llvm） | - |
| -o | string | No | 出力ファイル（デフォルト: 標準出力） | - |
| --level | enum | No | inst/bb/func（デフォルト: func） | embeddingsサブコマンド時 |
| --function | string | No | 特定関数のみ処理 | embeddingsサブコマンド時 |
| --ir2vec-vocab-path | path | No | IR2Vec語彙ファイルパス | embeddings時必須 |
| --mir2vec-vocab-path | path | No | MIR2Vec語彙ファイルパス | MIRモードのembeddings時 |
| --ir2vec-kind | enum | No | symbolic/flow-aware（デフォルト: symbolic） | LLVMモード時 |

### 入力データソース

- LLVM IRファイル（.bc, .ll）
- Machine IRファイル（.mir）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| トリプレット | text | MAX_RELATION=N ヘッダ + head\ttail\trelation行 |
| エンティティ | text | 総数ヘッダ + entity\tid行 |
| 埋め込み | text | ベクトル表現（浮動小数点配列） |

### 出力先

標準出力または-oオプションで指定されたファイル

## 処理フロー

### 処理シーケンス

```
1. コマンドライン解析
   └─ サブコマンドとモード判定
2. 入力ファイル読込
   └─ LLVM IR: parseIRFile()
   └─ MIR: createMIRParserFromFile()
3. サブコマンド実行
   ├─ triplets: トリプレット生成
   ├─ entities: エンティティマッピング生成
   └─ embeddings: 埋め込み生成
4. 結果出力
   └─ 指定形式でストリーム出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C{モード判定}
    C -->|LLVM IR| D[parseIRFile]
    C -->|MIR| E[createMIRParserFromFile]
    D --> F{サブコマンド}
    E --> F
    F -->|triplets| G[トリプレット生成]
    F -->|entities| H[エンティティマッピング生成]
    F -->|embeddings| I{語彙初期化}
    G --> J[結果出力]
    H --> J
    I -->|成功| K[埋め込み生成]
    I -->|失敗| L[エラー]
    K --> J
    L --> M[終了]
    J --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | デフォルトモード | modeオプション未指定時はLLVM IR | 常時 |
| BR-100-02 | デフォルトレベル | levelオプション未指定時はfunction | embeddingsサブコマンド |
| BR-100-03 | 語彙必須 | embeddings実行時は語彙ファイルが必須 | embeddingsサブコマンド |
| BR-100-04 | 関係タイプ | Type=0, Next=1, Arg=2+ | トリプレット生成 |
| BR-100-05 | MIR関係タイプ | Next=0, Arg=1+ | MIRトリプレット生成 |

### 計算ロジック

- トリプレット: 命令→型/オペランド/次命令の関係をグラフ化
- 埋め込み: 語彙ベクトルの重み付き和

## データベース操作仕様

### 操作別データベース影響一覧

本ツールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力エラー | IRファイル解析失敗 | 有効なIR/MIRファイルを指定 |
| 1 | 引数エラー | embeddings時に語彙未指定 | --ir2vec-vocab-pathを指定 |
| 1 | 関数エラー | 指定関数が見つからない | 正しい関数名を指定 |
| 1 | 出力エラー | 出力ファイルオープン失敗 | パス/権限確認 |
| 1 | MIRエラー | MachineFunction取得失敗 | 有効なMIRを指定 |

### リトライ仕様

リトライは実装されていない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 処理時間はIR/MIRのサイズに比例
- 大規模モジュールでは関数単位処理（--function）を推奨

## セキュリティ考慮事項

- 入力ファイルの検証はLLVMのIRパーサーに依存
- 出力は数値データのみで機密情報は含まない

## 備考

IR2VecはLLVM IRの意味的埋め込み、MIR2VecはMachine IRの埋め込みを生成する。語彙ファイルは事前に学習が必要。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Utils.h | `llvm/tools/llvm-ir2vec/lib/Utils.h` | EmbeddingLevel, Triplet, IR2VecTool, MIR2VecTool |

**読解のコツ**: EmbeddingLevel列挙型が埋め込み粒度を定義し、Triplet構造体がグラフ表現の基本単位。IR2VecToolとMIR2VecToolがそれぞれの処理を担当。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-ir2vec.cpp | `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp` | main関数、サブコマンド定義 |

**主要処理フロー**:
1. **339-356行目**: main関数、初期化とコマンドライン解析
2. **365-388行目**: LLVMモード処理
3. **389-405行目**: MIRモード処理

#### Step 3: サブコマンド定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-ir2vec.cpp | `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp` | SubCommand定義 |

**主要処理フロー**:
- **110-117行目**: triplets/entities/embeddingsサブコマンド定義
- **136-145行目**: Level（inst/bb/func）オプション定義

#### Step 4: IR2Vec処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-ir2vec.cpp | `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp` | ir2vec::processModule |

**主要処理フロー**:
- **150-184行目**: processModule()関数
- **153-178行目**: embeddings処理（語彙初期化→埋め込み生成）
- **180-182行目**: triplets/entities処理

#### Step 5: MIR2Vec処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | llvm-ir2vec.cpp | `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp` | mir2vec名前空間 |

**主要処理フロー**:
- **190-231行目**: setupMIRContext()でMIRコンテキスト初期化
- **265-271行目**: processModuleForTriplets()
- **274-280行目**: processModuleForEntities()
- **283-311行目**: processModuleForEmbeddings()

### プログラム呼び出し階層図

```
main() [llvm-ir2vec.cpp:339]
    │
    ├─ InitLLVM() [344行目]
    │
    ├─ cl::ParseCommandLineOptions() [348行目]
    │
    ├─ [LLVM IRモード] [365行目]
    │      │
    │      ├─ [entitiesサブコマンド]
    │      │      └─ IR2VecTool::writeEntitiesToStream() [368行目]
    │      │
    │      └─ [triplets/embeddings]
    │             │
    │             ├─ parseIRFile() [375行目]
    │             │
    │             └─ ir2vec::processModule() [381行目]
    │                    │
    │                    ├─ IR2VecTool(M) [151行目]
    │                    │
    │                    ├─ [embeddingsサブコマンド]
    │                    │      │
    │                    │      ├─ initializeVocabulary() [164行目]
    │                    │      │
    │                    │      └─ writeEmbeddingsToStream() [170/177行目]
    │                    │
    │                    └─ [tripletsサブコマンド]
    │                           └─ writeTripletsToStream() [181行目]
    │
    └─ [MIRモード] [389行目]
           │
           ├─ InitializeAllTargets() [391行目]
           │
           └─ mir2vec::processModule() [397行目]
                  │
                  ├─ setupMIRContext() [318行目]
                  │      │
                  │      ├─ createMIRParserFromFile() [193行目]
                  │      ├─ createTargetMachineForTriple() [207行目]
                  │      └─ parseMachineFunctions() [224行目]
                  │
                  ├─ [tripletsサブコマンド]
                  │      └─ processModuleForTriplets() [323行目]
                  │
                  ├─ [entitiesサブコマンド]
                  │      └─ processModuleForEntities() [325行目]
                  │
                  └─ [embeddingsサブコマンド]
                         └─ processModuleForEmbeddings() [327行目]
```

### データフロー図

```
[入力]                        [処理]                        [出力]

LLVM IR (.bc/.ll) ────▶ parseIRFile()
        │                      │
        │                      ▼
        │                 IR2VecTool
        │                      │
        │         ┌────────────┼────────────┐
        │         │            │            │
        │         ▼            ▼            ▼
        │    triplets     entities    embeddings
        │         │            │            │
        │         │            │            ├─ initializeVocabulary()
        │         │            │            │
        │         ▼            ▼            ▼
        │    Triplet[]    EntityList   Embedding[]
        │         │            │            │
        └─────────┴────────────┴────────────┘
                               │
                               ▼
                        writeToStream()
                               │
                               ▼
                         出力ファイル/stdout

MIR (.mir) ──────────▶ createMIRParserFromFile()
                               │
                               ▼
                        MIR2VecTool
                               │
              ┌────────────────┼────────────────┐
              │                │                │
              ▼                ▼                ▼
         triplets         entities        embeddings
              │                │                │
              ▼                ▼                ▼
         Triplet[]        EntityList      Embedding[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-ir2vec.cpp | `llvm/tools/llvm-ir2vec/llvm-ir2vec.cpp` | ソース | メインエントリー、サブコマンド処理 |
| Utils.h | `llvm/tools/llvm-ir2vec/lib/Utils.h` | ヘッダ | IR2VecTool/MIR2VecToolクラス定義 |
| IR2Vec.h | `llvm/include/llvm/Analysis/IR2Vec.h` | ヘッダ | IR2Vec分析パス定義 |
| MIR2Vec.h | `llvm/include/llvm/CodeGen/MIR2Vec.h` | ヘッダ | MIR2Vec分析パス定義 |
