# 機能設計書 101-ClangIR（CIR）

## 概要

本ドキュメントは、ClangIR（CIR）機能の設計仕様を記述する。CIRはClangコンパイラ向けの新しい中間表現レイヤーであり、cir-optとcir-translateの2つの主要ツールで構成される。

### 本機能の処理概要

ClangIR（CIR）は、Clangコンパイラのための新しい中間表現（Intermediate Representation）レイヤーを提供する機能である。MLIRフレームワーク上に構築され、C/C++/Objective-Cコードの解析・最適化・変換を行うための高レベルな中間表現を実現する。

**業務上の目的・背景**：従来のLLVM IRは低レベルであり、高レベルな言語構造（ループ、条件分岐、オブジェクト指向構造など）の情報が失われてしまう。CIRはこれらの高レベル情報を保持したまま最適化を行うことができ、より効果的なコード解析と最適化を可能にする。また、MLIRの多層表現を活用することで、段階的な変換パイプラインを構築できる。

**機能の利用シーン**：コンパイラ開発者がClangの最適化パスを開発・デバッグする際に使用される。また、コード解析ツールの開発者がC/C++コードの構造を解析する際にも利用できる。研究目的での新しい最適化手法の実験にも適している。

**主要な処理内容**：
1. CIR方言のパースと検証（cir-opt）
2. CIR最適化パスの適用（Canonicalize、Simplify、FlattenCFG、HoistAllocas、GotoSolver）
3. CIRからLLVM IRへの変換（cir-to-llvm パイプライン）
4. CIRからLLVM IRへの直接翻訳（cir-translate）
5. ターゲットトリプルとデータレイアウトの自動設定

**関連システム・外部連携**：MLIRフレームワーク、LLVMコアライブラリ、Clangフロントエンドと連携する。特にMLIR方言システム（BuiltinDialect、LLVMDialect、DLTIDialect、MemRefDialect）を利用する。

**権限による制御**：特になし。コマンドラインツールとして実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIインターフェース | 主画面 | cir-optおよびcir-translateコマンドの実行 |

## 機能種別

コード変換処理 / 最適化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | ファイルパス | Yes | CIRモジュールファイル | 有効なCIRファイル |
| -target | 文字列 | No | ターゲットトリプル（未指定時はデフォルト使用） | 有効なトリプル形式 |
| -disable-cc-lowering | bool | No | 呼び出し規約変換パスの無効化 | - |
| -cir-to-llvm | フラグ | No | CIRからLLVMへの変換パイプライン適用 | - |

### 入力データソース

- CIR形式のMLIRファイル（.cir拡張子または標準入力）
- コマンドライン引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 最適化済みCIR | MLIRファイル | cir-optで最適化されたCIRモジュール |
| LLVM IR | テキスト/バイナリ | cir-translateで生成されたLLVM IR |

### 出力先

標準出力または指定されたファイル

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ MLIR方言レジストリへのCIR方言登録
2. パス登録
   └─ Canonicalize、Simplify、FlattenCFG、HoistAllocas、GotoSolverパスの登録
3. パイプライン登録
   └─ cir-to-llvmパイプラインの登録
4. モジュール読み込み
   └─ CIRモジュールのパース
5. ターゲット準備（cir-translate）
   └─ トリプルとデータレイアウトの設定
6. 変換実行
   └─ 指定された最適化パスまたは翻訳の実行
7. 出力
   └─ 結果の出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[方言レジストリ初期化]
    B --> C[パス登録]
    C --> D{ツール種別}
    D -->|cir-opt| E[MlirOptMain実行]
    D -->|cir-translate| F[ターゲット準備]
    F --> G[CIRモジュール検証]
    G --> H[LLVM IR生成]
    E --> I[最適化済みCIR出力]
    H --> J[LLVM IR出力]
    I --> K[終了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101 | トリプル自動設定 | ターゲットトリプルが未指定の場合、デフォルトターゲットを使用 | -targetオプション未指定時 |
| BR-102 | データレイアウト導出 | データレイアウトはトリプルから自動的に導出される | 常時 |
| BR-103 | 警告出力 | デフォルトトリプル使用時は警告メッセージを出力 | トリプル未指定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なトリプル | 指定されたトリプルが無効 | エラーメッセージ出力、プロセス終了 |
| - | パース失敗 | CIRファイルのパースに失敗 | エラーメッセージ出力、プロセス終了 |
| - | 変換失敗 | LLVM IRへの変換に失敗 | エラーメッセージ出力、プロセス終了 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし（コマンドラインツールとして通常の実行時間を想定）

## セキュリティ考慮事項

入力ファイルの検証が行われる。不正な形式のファイルはパースエラーとして拒否される。

## 備考

CIRは現在開発中の機能であり、APIや動作は将来変更される可能性がある。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CIR方言とMLIRの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CIRDialect.h | `clang/include/clang/CIR/Dialect/IR/CIRDialect.h` | CIR方言の定義、getTripleAttrName()メソッド |
| 1-2 | CIRDialect.cpp | `clang/lib/CIR/Dialect/IR/CIRDialect.cpp` | 方言の実装詳細 |

**読解のコツ**: MLIRの方言（Dialect）システムを理解していると読みやすい。CIRDialectはMLIR上にC/C++の高レベル構造を表現する方言として設計されている。

#### Step 2: エントリーポイントを理解する

cir-optとcir-translateの2つのツールのエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cir-opt.cpp | `clang/tools/cir-opt/cir-opt.cpp` | main関数、方言登録、パス登録 |
| 2-2 | cir-translate.cpp | `clang/tools/cir-translate/cir-translate.cpp` | 翻訳登録、LLVM IR生成 |

**主要処理フロー**:
1. **33-69行目（cir-opt.cpp）**: main関数で方言とパスを登録し、MlirOptMainを呼び出す
2. **36-38行目**: BuiltinDialect、CIRDialect、MemRefDialect、LLVMDialect、DLTIDialectを登録
3. **40-64行目**: 各最適化パスを登録（Canonicalize、Simplify、FlattenCFG、HoistAllocas、GotoSolver）
4. **47-51行目**: cir-to-llvmパイプラインを登録

#### Step 3: CIR最適化パスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Passes.h | `clang/include/clang/CIR/Dialect/Passes.h` | パスの宣言 |
| 3-2 | Passes.td | `clang/include/clang/CIR/Dialect/Passes.td` | パスのTableGen定義 |

**主要処理フロー**:
- createCIRCanonicalizePass(): 正規化パス
- createCIRSimplifyPass(): 簡略化パス
- createCIRFlattenCFGPass(): 制御フロー平坦化パス
- createHoistAllocasPass(): Alloca巻き上げパス
- createGotoSolverPass(): Goto解決パス

#### Step 4: CIRからLLVM IRへの変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LowerToLLVM.h | `clang/include/clang/CIR/LowerToLLVM.h` | 変換インターフェース |
| 4-2 | cir-translate.cpp | `clang/tools/cir-translate/cir-translate.cpp` | 67-80行目: prepareCIRModuleTriple関数 |

**主要処理フロー**:
- **67-80行目（cir-translate.cpp）**: トリプルが未設定の場合、デフォルトトリプルを設定
- **82-115行目**: データレイアウトをトリプルから導出
- **144-171行目**: registerToLLVMTranslation関数でMLIRからLLVM IRへの翻訳を登録
- **159-164行目**: lowerDirectlyFromCIRToLLVMIR関数を呼び出してLLVM IRを生成

### プログラム呼び出し階層図

```
main (cir-opt.cpp:33)
    │
    ├─ mlir::DialectRegistry::insert
    │      └─ CIRDialect, BuiltinDialect, LLVMDialect等を登録
    │
    ├─ mlir::registerPass
    │      ├─ createCIRCanonicalizePass
    │      ├─ createCIRSimplifyPass
    │      ├─ createCIRFlattenCFGPass
    │      ├─ createHoistAllocasPass
    │      └─ createGotoSolverPass
    │
    ├─ mlir::PassPipelineRegistration
    │      └─ cir::direct::populateCIRToLLVMPasses
    │
    └─ mlir::MlirOptMain
           └─ パスマネージャによる最適化実行

main (cir-translate.cpp:173)
    │
    ├─ registerToLLVMTranslation
    │      └─ mlir::TranslateFromMLIRRegistration
    │             ├─ cir::prepareCIRModuleForTranslation
    │             │      ├─ prepareCIRModuleTriple
    │             │      └─ prepareCIRModuleDataLayout
    │             └─ cir::direct::lowerDirectlyFromCIRToLLVMIR
    │
    └─ mlir::mlirTranslateMain
```

### データフロー図

```
[入力]               [処理]                    [出力]

CIRファイル ───▶ cir-opt ───▶ 最適化済みCIR
   (.cir)         │
                  ├─ パース
                  ├─ 最適化パス適用
                  └─ 出力

CIRファイル ───▶ cir-translate ───▶ LLVM IR
   (.cir)         │                    (.ll)
                  ├─ パース
                  ├─ トリプル/データレイアウト設定
                  ├─ CIR→LLVM変換
                  └─ LLVM IR出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cir-opt.cpp | `clang/tools/cir-opt/cir-opt.cpp` | ソース | CIR最適化ツールのエントリーポイント |
| cir-translate.cpp | `clang/tools/cir-translate/cir-translate.cpp` | ソース | CIR翻訳ツールのエントリーポイント |
| CMakeLists.txt | `clang/tools/cir-opt/CMakeLists.txt` | ビルド設定 | cir-optのビルド設定 |
| CMakeLists.txt | `clang/tools/cir-translate/CMakeLists.txt` | ビルド設定 | cir-translateのビルド設定 |
| CIRDialect.h | `clang/include/clang/CIR/Dialect/IR/CIRDialect.h` | ヘッダ | CIR方言の定義 |
| Passes.h | `clang/include/clang/CIR/Dialect/Passes.h` | ヘッダ | CIRパスの宣言 |
| LowerToLLVM.h | `clang/include/clang/CIR/LowerToLLVM.h` | ヘッダ | LLVM変換インターフェース |
