# 機能設計書 103-llvm-debuginfod-find

## 概要

本ドキュメントは、llvm-debuginfod-find機能の設計仕様を記述する。llvm-debuginfod-findは、debuginfodサーバーからデバッグ情報を取得するコマンドラインクライアントである。

### 本機能の処理概要

llvm-debuginfod-findは、Build IDを指定してdebuginfodサーバーから実行ファイル、デバッグ情報、またはソースファイルを取得するCLIツールである。DEBUGINFOD_URLS環境変数で設定されたサーバーに問い合わせを行い、ローカルディレクトリも検索対象とすることができる。

**業務上の目的・背景**：デバッグ作業において、ストリップされたバイナリからデバッグシンボルを取得する必要がある場合がある。llvm-debuginfod-findは、Build IDを使用してネットワーク上のdebuginfodサーバーやローカルのデバッグファイルディレクトリからデバッグ情報を自動的に検索・取得する。これにより、デバッガが自動的にシンボルを解決できるようになる。

**機能の利用シーン**：デバッガ（LLDB、GDB）のバックエンドとして自動的に呼び出される場合が多い。また、手動でデバッグ情報を取得したい場合にも使用できる。CI/CDパイプラインでのテスト検証にも利用される。

**主要な処理内容**：
1. Build ID（16進数文字列）の解析
2. 取得対象の選択（実行ファイル/デバッグ情報/ソースファイル）
3. ローカルデバッグファイルディレクトリの検索
4. debuginfodサーバーへのHTTPリクエスト
5. 取得したファイルのキャッシュまたは出力

**関連システム・外部連携**：debuginfodサーバー（DEBUGINFOD_URLS環境変数）、ローカルファイルシステム、キャッシュディレクトリ（DEBUGINFOD_CACHE_PATH）と連携する。

**権限による制御**：特になし。ネットワークアクセスとファイルシステム書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIインターフェース | 主画面 | コマンドライン実行とオプション指定 |

## 機能種別

データ取得処理 / ネットワーク通信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| build_id | 16進数文字列 | Yes | 取得対象のBuild ID | 有効な16進数文字列 |
| --executable | フラグ | No* | 実行ファイルを取得 | 排他オプション |
| --debuginfo | フラグ | No* | デバッグ情報を取得 | 排他オプション |
| --source | 文字列 | No* | 指定パスのソースファイルを取得 | 排他オプション |
| --dump-to-stdout | フラグ | No | 内容を標準出力に出力 | - |
| --debug-file-directory | 文字列リスト | No | ローカル検索ディレクトリ | - |

*--executable、--debuginfo、--source=のいずれか1つを指定する必要がある

### 入力データソース

- コマンドライン引数
- 環境変数（DEBUGINFOD_URLS、DEBUGINFOD_CACHE_PATH、DEBUGINFOD_TIMEOUT）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルパス | 文字列 | キャッシュされたファイルのパス |
| ファイル内容 | バイナリ/テキスト | --dump-to-stdout時のファイル内容 |

### 出力先

標準出力（パスまたはファイル内容）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ HTTPClientの初期化
2. 引数解析
   └─ Build ID、取得対象の解析
3. Build ID検証
   └─ 16進数文字列の検証と変換
4. 取得処理分岐
   ├─ ソースファイル: getCachedOrDownloadSource
   ├─ 実行ファイル: getCachedOrDownloadExecutable
   └─ デバッグ情報: fetchDebugInfo（DebuginfodFetcher使用）
5. 出力
   ├─ --dump-to-stdout: ファイル内容を出力
   └─ 通常: ファイルパスを出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[HTTP Client初期化]
    B --> C[引数解析]
    C --> D{オプション検証}
    D -->|無効| E[ヘルプ表示/エラー]
    D -->|有効| F[Build ID解析]
    F --> G{16進数検証}
    G -->|失敗| H[エラー終了]
    G -->|成功| I{取得対象}
    I -->|source| J[getCachedOrDownloadSource]
    I -->|executable| K[getCachedOrDownloadExecutable]
    I -->|debuginfo| L[fetchDebugInfo]
    J --> M{成功?}
    K --> M
    L --> M
    M -->|失敗| N[エラー終了]
    M -->|成功| O{dump-to-stdout?}
    O -->|Yes| P[ファイル内容出力]
    O -->|No| Q[パス出力]
    P --> R[終了]
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-103-1 | 排他オプション | executable/debuginfo/sourceは1つのみ指定可能 | 常時 |
| BR-103-2 | キャッシュ優先 | ローカルキャッシュを先に検索 | 常時 |
| BR-103-3 | タイムアウト | DEBUGINFOD_TIMEOUTで設定（デフォルト90秒） | サーバーリクエスト時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。ファイルシステムにキャッシュを保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 不正なBuild ID | Build IDが16進数文字列でない | エラーメッセージ出力、終了 |
| - | オプション不正 | 排他オプションの重複/不足 | ヘルプ表示、終了 |
| - | Not Found | Build IDが見つからない | エラーメッセージ出力、終了 |

### リトライ仕様

HTTPクライアントの設定に従う。

## トランザクション仕様

該当なし

## パフォーマンス要件

DEBUGINFOD_TIMEOUT環境変数でタイムアウト制御（デフォルト90秒）。

## セキュリティ考慮事項

- debuginfodサーバーへの通信はHTTPS推奨
- キャッシュディレクトリのパーミッション管理が必要

## 備考

LLDB/GDBから自動的に呼び出されることが多い。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildIDFetcher.h | `llvm/include/llvm/Debuginfod/BuildIDFetcher.h` | DebuginfodFetcherクラス |
| 1-2 | Debuginfod.h | `llvm/include/llvm/Debuginfod/Debuginfod.h` | getCachedOrDownload系関数 |

**読解のコツ**: DebuginfodFetcherがローカルディレクトリとネットワークの両方を検索する仕組みを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-debuginfod-find.cpp | `llvm/tools/llvm-debuginfod-find/llvm-debuginfod-find.cpp` | main関数の処理フロー |
| 2-2 | Opts.td | `llvm/tools/llvm-debuginfod-find/Opts.td` | コマンドラインオプション定義 |

**主要処理フロー**:
1. **112-116行目**: llvm_debuginfod_find_main関数がエントリーポイント
2. **115行目**: HTTPClient::initialize()でHTTPクライアント初期化
3. **116行目**: parseArgs()で引数解析
4. **118-119行目**: 排他オプションの検証
5. **121-126行目**: Build IDの16進数検証と変換
6. **128-138行目**: 取得対象に応じた処理分岐
7. **140-148行目**: 出力処理（dump-to-stdout または パス出力）

#### Step 3: 取得処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-debuginfod-find.cpp | `llvm/tools/llvm-debuginfod-find/llvm-debuginfod-find.cpp` | fetchDebugInfo関数（154-161行目） |

**主要処理フロー**:
- **130-131行目**: ソースファイル取得 - getCachedOrDownloadSource
- **132-133行目**: 実行ファイル取得 - getCachedOrDownloadExecutable
- **134-135行目**: デバッグ情報取得 - fetchDebugInfo
- **154-161行目**: fetchDebugInfo関数 - DebuginfodFetcher.fetch()を呼び出し

### プログラム呼び出し階層図

```
llvm_debuginfod_find_main (112行目)
    │
    ├─ HTTPClient::initialize (115行目)
    │
    ├─ parseArgs (116行目)
    │      ├─ InputBuildID
    │      ├─ FetchExecutable
    │      ├─ FetchDebuginfo
    │      ├─ FetchSource
    │      ├─ DumpToStdout
    │      └─ DebugFileDirectory
    │
    ├─ tryGetFromHex (122行目)
    │      └─ Build ID検証
    │
    ├─ getCachedOrDownloadSource (130-131行目)
    │
    ├─ getCachedOrDownloadExecutable (132-133行目)
    │
    ├─ fetchDebugInfo (134-135行目)
    │      └─ DebuginfodFetcher::fetch (156行目)
    │
    └─ MemoryBuffer::getFile (142-144行目)
           └─ dump-to-stdout時のファイル読み込み
```

### データフロー図

```
[入力]               [処理]                    [出力]

Build ID ───▶ llvm-debuginfod-find ───▶ ファイルパス/内容
(16進数)      │
              ├─ ローカルディレクトリ検索
              │     (--debug-file-directory)
              │
              └─ debuginfodサーバー問い合わせ
                    (DEBUGINFOD_URLS)
                    │
                    └─ キャッシュ保存
                        (DEBUGINFOD_CACHE_PATH)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-debuginfod-find.cpp | `llvm/tools/llvm-debuginfod-find/llvm-debuginfod-find.cpp` | ソース | メインエントリーポイント |
| Opts.td | `llvm/tools/llvm-debuginfod-find/Opts.td` | TableGen | コマンドラインオプション定義 |
| CMakeLists.txt | `llvm/tools/llvm-debuginfod-find/CMakeLists.txt` | ビルド設定 | ビルド構成 |
| BuildIDFetcher.h | `llvm/include/llvm/Debuginfod/BuildIDFetcher.h` | ヘッダ | DebuginfodFetcherクラス |
| Debuginfod.h | `llvm/include/llvm/Debuginfod/Debuginfod.h` | ヘッダ | debuginfodライブラリAPI |
