# 機能設計書 106-llvm-remarkutil

## 概要

本ドキュメントは、llvm-remarkutil機能の設計仕様を記述する。llvm-remarkutilは、LLVM最適化備考（Remarks）データを操作するための多機能ユーティリティである。

### 本機能の処理概要

llvm-remarkutilは、LLVMコンパイラが出力する最適化備考（Optimization Remarks）データに対する各種操作を行うツール群である。YAMLとBitstream形式間の変換、フィルタリング、カウント、サイズ比較、命令ミックス解析などの機能を提供する。

**業務上の目的・背景**：コンパイラの最適化判断を理解し、パフォーマンスチューニングを行う際に、最適化備考は重要な情報源となる。llvm-remarkutilは、大量の備考データを効率的に処理・分析するためのツールを提供し、開発者がボトルネックを特定したり、最適化の効果を評価したりするのを支援する。

**機能の利用シーン**：コンパイラ最適化の分析、パフォーマンスリグレッション調査、ビルド間の最適化差分比較、備考データ形式の変換に使用される。

**主要な処理内容**：
1. YAML形式からBitstream形式への変換（yaml2bitstream）
2. Bitstream形式からYAML形式への変換（bitstream2yaml）
3. 備考のフィルタリング（filter）
4. 備考のカウント（count）
5. サイズ差分レポート（size-diff）
6. 命令ミックス解析（instruction-mix）

**関連システム・外部連携**：LLVMコンパイラ（Clang等）が生成する備考ファイルと連携する。

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIインターフェース | 主画面 | サブコマンドによる各種操作 |

## 機能種別

データ変換処理 / 分析処理

## 入力仕様

### 入力パラメータ

共通オプション:

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | ファイルパス | Yes | 入力備考ファイル | - |
| -o | 文字列 | No | 出力ファイル（デフォルト: -） | - |
| --parser | 列挙 | No | 入力形式（auto/yaml/bitstream） | デフォルト: auto |

フィルタリングオプション（filter、count等）:

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --function | 文字列 | No | 関数名でフィルタ | - |
| --rfunction | 文字列 | No | 関数名（正規表現）でフィルタ | - |
| --remark-name | 文字列 | No | 備考名でフィルタ | - |
| --rremark-name | 文字列 | No | 備考名（正規表現）でフィルタ | - |
| --pass-name | 文字列 | No | パス名でフィルタ | - |
| --rpass-name | 文字列 | No | パス名（正規表現）でフィルタ | - |
| --remark-type | 列挙 | No | 備考種別でフィルタ | passed/missed/analysis等 |
| --filter-arg-by | 文字列 | No | 引数値でフィルタ | - |
| --rfilter-arg-by | 文字列 | No | 引数値（正規表現）でフィルタ | - |

### サブコマンド一覧

| サブコマンド | 説明 |
|-------------|------|
| yaml2bitstream | YAML形式をBitstream形式に変換 |
| bitstream2yaml | Bitstream形式をYAML形式に変換 |
| filter | 条件に合致する備考を抽出 |
| count | 備考数をカウント |
| size-diff | 2つの備考ファイルのサイズ差分を表示 |
| instruction-mix | 命令ミックス解析 |

### 入力データソース

- 備考ファイル（YAML形式またはBitstream形式）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換後備考 | YAML/Bitstream | yaml2bitstream/bitstream2yaml時 |
| フィルタ結果 | YAML/Bitstream | filter時 |
| カウント結果 | テキスト | count時の統計情報 |
| 差分レポート | テキスト | size-diff時の差分情報 |
| 命令ミックス | テキスト | instruction-mix時の解析結果 |

### 出力先

指定された出力ファイルまたは標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ InitLLVM
2. サブコマンド解析
   └─ ParseCommandLineOptions
3. サブコマンドディスパッチ
   └─ dispatch()で登録済みコマンドを検索・実行
4. コマンド固有処理
   └─ 各サブコマンドの実装を実行
5. 結果出力
   └─ 変換結果または分析結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[InitLLVM]
    B --> C[ParseCommandLineOptions]
    C --> D[handleSubOptions]
    D --> E{サブコマンド検出?}
    E -->|No| F[エラー: サブコマンド未指定]
    E -->|Yes| G[dispatch]
    G --> H{コマンド種別}
    H -->|yaml2bitstream| I[tryYAML2Bitstream]
    H -->|bitstream2yaml| J[tryBitstream2YAML]
    H -->|filter| K[tryFilter]
    H -->|count| L[count処理]
    H -->|size-diff| M[size-diff処理]
    H -->|instruction-mix| N[instruction-mix処理]
    I --> O[終了]
    J --> O
    K --> O
    L --> O
    M --> O
    N --> O
    F --> P[エラー終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-106-1 | 形式自動検出 | --parser autoで入力形式を自動検出 | デフォルト |
| BR-106-2 | 正規表現フィルタ | r接頭辞オプションで正規表現パターン使用 | rfunctionなど |
| BR-106-3 | 排他フィルタ | 同一属性に対して完全一致と正規表現は排他 | filter時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | サブコマンド未指定 | サブコマンドなしで実行 | ヘルプ表示 |
| - | パース失敗 | 入力ファイル形式不正 | エラーメッセージ出力 |
| - | 正規表現エラー | 正規表現パターンが不正 | エラーメッセージ出力 |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし。

## セキュリティ考慮事項

入力ファイルは備考形式として検証される。

## 備考

各サブコマンドは個別のソースファイルで実装されている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Remark.h | `llvm/include/llvm/Remarks/Remark.h` | Remarkクラス、Type列挙 |
| 1-2 | RemarkParser.h | `llvm/include/llvm/Remarks/RemarkParser.h` | RemarkParserクラス |
| 1-3 | RemarkSerializer.h | `llvm/include/llvm/Remarks/RemarkSerializer.h` | RemarkSerializerクラス |

**読解のコツ**: Remarkがパス名、備考名、関数名、引数リストなどを持つデータ構造であることを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RemarkUtil.cpp | `llvm/tools/llvm-remarkutil/RemarkUtil.cpp` | main関数、handleSubOptions |
| 2-2 | RemarkUtilRegistry.h | `llvm/tools/llvm-remarkutil/RemarkUtilRegistry.h` | CommandRegistration、dispatch |

**主要処理フロー**:
1. **36-41行目（RemarkUtil.cpp）**: main関数
2. **38行目**: ParseCommandLineOptions
3. **40行目**: handleSubOptions()でサブコマンド処理
4. **18-34行目**: handleSubOptions関数 - 登録済みサブコマンドをループして実行

#### Step 3: サブコマンド実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RemarkConvert.cpp | `llvm/tools/llvm-remarkutil/RemarkConvert.cpp` | yaml2bitstream、bitstream2yaml |
| 3-2 | RemarkFilter.cpp | `llvm/tools/llvm-remarkutil/RemarkFilter.cpp` | filter処理 |
| 3-3 | RemarkUtilHelpers.h | `llvm/tools/llvm-remarkutil/RemarkUtilHelpers.h` | FilterMatcher、Filtersクラス |

**主要処理フロー（RemarkConvert.cpp）**:
- **21-26行目**: サブコマンド定義（YAML2Bitstream、Bitstream2YAML）
- **50-70行目**: tryParseRemarksFromYAMLFile - YAMLパースとStringTable構築
- **76-92行目**: tryReserializeYAML2Bitstream - Bitstreamへの再シリアライズ
- **107-137行目**: tryBitstream2YAML - パースしながらYAMLへ再シリアライズ

**主要処理フロー（RemarkFilter.cpp）**:
- **27-28行目**: FilterSubサブコマンド定義
- **37-78行目**: tryFilter関数
- **38-41行目**: getRemarkFilters()でフィルタ条件構築
- **64-69行目**: Filter.filterRemark()でフィルタリング

### プログラム呼び出し階層図

```
main (RemarkUtil.cpp:36)
    │
    ├─ InitLLVM (37行目)
    │
    ├─ ParseCommandLineOptions (38行目)
    │
    └─ handleSubOptions (40行目)
           │
           ├─ cl::getRegisteredSubcommands()
           │
           └─ dispatch(SC)
                  │
                  ├─ yaml2bitstream
                  │      ├─ tryParseRemarksFromYAMLFile
                  │      │      └─ createRemarkParser
                  │      └─ tryReserializeYAML2Bitstream
                  │             └─ createRemarkSerializer
                  │
                  ├─ bitstream2yaml
                  │      ├─ createRemarkParser
                  │      ├─ createRemarkSerializer
                  │      └─ Parser.next() / Serializer.emit()
                  │
                  ├─ filter
                  │      ├─ getRemarkFilters
                  │      ├─ createRemarkParser
                  │      ├─ createRemarkSerializer
                  │      └─ Filter.filterRemark()
                  │
                  └─ (その他のサブコマンド)
```

### データフロー図

```
[入力]               [処理]                    [出力]

YAML備考 ───▶ yaml2bitstream ───▶ Bitstream備考
                  │
                  ├─ パース
                  ├─ StringTable構築
                  └─ シリアライズ

Bitstream備考 ───▶ bitstream2yaml ───▶ YAML備考
                     │
                     ├─ パース
                     └─ シリアライズ

任意備考 ───▶ filter ───▶ フィルタ済み備考
                │
                ├─ パース
                ├─ Filters.filterRemark()
                └─ マッチした備考をシリアライズ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RemarkUtil.cpp | `llvm/tools/llvm-remarkutil/RemarkUtil.cpp` | ソース | メインエントリーポイント |
| RemarkUtilRegistry.h | `llvm/tools/llvm-remarkutil/RemarkUtilRegistry.h` | ヘッダ | コマンド登録システム |
| RemarkUtilRegistry.cpp | `llvm/tools/llvm-remarkutil/RemarkUtilRegistry.cpp` | ソース | コマンド登録実装 |
| RemarkUtilHelpers.h | `llvm/tools/llvm-remarkutil/RemarkUtilHelpers.h` | ヘッダ | ユーティリティ関数、フィルタクラス |
| RemarkUtilHelpers.cpp | `llvm/tools/llvm-remarkutil/RemarkUtilHelpers.cpp` | ソース | ユーティリティ実装 |
| RemarkConvert.cpp | `llvm/tools/llvm-remarkutil/RemarkConvert.cpp` | ソース | 形式変換サブコマンド |
| RemarkFilter.cpp | `llvm/tools/llvm-remarkutil/RemarkFilter.cpp` | ソース | フィルタサブコマンド |
| RemarkCount.cpp | `llvm/tools/llvm-remarkutil/RemarkCount.cpp` | ソース | カウントサブコマンド |
| RemarkSizeDiff.cpp | `llvm/tools/llvm-remarkutil/RemarkSizeDiff.cpp` | ソース | サイズ差分サブコマンド |
| RemarkInstructionMix.cpp | `llvm/tools/llvm-remarkutil/RemarkInstructionMix.cpp` | ソース | 命令ミックスサブコマンド |
| CMakeLists.txt | `llvm/tools/llvm-remarkutil/CMakeLists.txt` | ビルド設定 | ビルド構成 |
