# 機能設計書 107-llvm-opt-report

## 概要

本ドキュメントは、llvm-opt-report機能の設計仕様を記述する。llvm-opt-reportは、YAML形式の最適化備考データからソースコード注釈付きの最適化レポートを生成するツールである。

### 本機能の処理概要

llvm-opt-reportは、LLVMコンパイラが生成する最適化備考（Optimization Remarks）ファイルを解析し、元のソースコードに最適化情報（インライン化、ループアンロール、ベクトル化）を注釈として付加したレポートを生成する。各ソース行に対して、どの最適化が適用されたか、または適用を検討されたかを視覚的に表示する。

**業務上の目的・背景**：コンパイラがどのような最適化を行ったかを理解することは、パフォーマンスチューニングにおいて重要である。llvm-opt-reportは、最適化備考データをソースコードと関連付けて表示することで、開発者が最適化の効果を直感的に把握できるようにする。ボトルネックの特定や最適化を促すコード変更の判断に活用できる。

**機能の利用シーン**：パフォーマンス解析、最適化阻害要因の特定、コンパイラ最適化動作の学習に使用される。

**主要な処理内容**：
1. 最適化備考ファイル（YAML/Bitstream）の読み込み
2. 備考データの位置情報（ファイル、行、列）による分類
3. 元ソースファイルの読み込み
4. ソースコード行への最適化情報注釈付加
5. 注釈付きレポートの出力

**関連システム・外部連携**：LLVMコンパイラ（Clang等）が生成する備考ファイル、元のソースファイルと連携する。

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIインターフェース | 主画面 | コマンドライン実行 |
| - | テキストレポート | 出力画面 | 注釈付きソースコード表示 |

## 機能種別

レポート生成処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | ファイルパス | Yes | 最適化備考ファイル | - |
| -o | 文字列 | No | 出力ファイル（デフォルト: 標準出力） | - |
| -r | 文字列 | No | 相対パスのルートディレクトリ | - |
| -s | フラグ | No | 簡潔モード（ベクトル化係数等を省略） | - |
| --no-demangle | フラグ | No | 関数名のデマングルを無効化 | - |
| --format | 文字列 | No | 備考形式（デフォルト: yaml） | - |

### 入力データソース

- 最適化備考ファイル（YAML形式またはBitstream形式）
- 元のソースファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 注釈付きソースコード | テキスト | 最適化情報を含むソースコードレポート |

### 出力形式

各行に以下の情報が付加される：
- 行番号
- インライン化マーカー（I: 適用、空白: 未適用または対象外）
- アンロールマーカー（U + アンロール回数）
- ベクトル化マーカー（V + ベクトル化係数、インターリーブ回数）
- 元のソースコード

### 出力先

指定された出力ファイルまたは標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ InitLLVM
2. 引数解析
   └─ ParseCommandLineOptions
3. 備考ファイル読み込み
   └─ readLocationInfo - ファイル別・行別・関数別・列別に分類
4. ソースファイル処理
   └─ writeReport - 各ソースファイルごとに処理
5. レポート出力
   └─ 行ごとに最適化マーカーとソースコードを出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[InitLLVM]
    B --> C[ParseCommandLineOptions]
    C --> D[readLocationInfo]
    D --> E{パース成功?}
    E -->|No| F[エラー終了]
    E -->|Yes| G[writeReport]
    G --> H{ファイルごとにループ}
    H --> I[ソースファイル読み込み]
    I --> J{行ごとにループ}
    J --> K[最適化情報取得]
    K --> L[マーカー生成]
    L --> M[行出力]
    M --> N{次の行?}
    N -->|Yes| J
    N -->|No| O{次のファイル?}
    O -->|Yes| H
    O -->|No| P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-1 | 位置ベース分類 | 備考はファイル→行→関数→列で階層化 | 常時 |
| BR-107-2 | 複数関数対応 | 同一行に複数関数がある場合は個別表示 | 複数関数時 |
| BR-107-3 | 簡潔モード | -s指定時はベクトル化係数等を省略 | -s指定時 |

### 計算ロジック

最適化情報の集約：
- 同一位置の複数備考はOR演算で集約
- VectorizationFactorは最大値を採用
- InterleaveCount、UnrollCountも最大値を採用

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 備考ファイル読み込み失敗 | ファイルが存在しないまたは形式不正 | エラーメッセージ出力、終了 |
| - | ソースファイル読み込み失敗 | 参照されたソースファイルが見つからない | エラーメッセージ出力、終了 |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし。

## セキュリティ考慮事項

入力ファイルは備考形式として検証される。

## 備考

-rオプションで相対パスのルートを指定することで、ビルドディレクトリとソースディレクトリが異なる場合に対応できる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OptReport.cpp | `llvm/tools/llvm-opt-report/OptReport.cpp` | OptReportLocationItemInfo、OptReportLocationInfo構造体 |

**読解のコツ**:
- OptReportLocationItemInfo（75-96行目）: Analyzed（解析済み）とTransformed（変換済み）のフラグ
- OptReportLocationInfo（99-149行目）: Inlined、Unrolled、Vectorizedの情報と各種係数

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OptReport.cpp | `llvm/tools/llvm-opt-report/OptReport.cpp` | main関数（479-495行目） |

**主要処理フロー**:
1. **479-480行目**: InitLLVM
2. **482-486行目**: ParseCommandLineOptions
3. **488-490行目**: readLocationInfo呼び出し
4. **491-492行目**: writeReport呼び出し

#### Step 3: 備考読み込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OptReport.cpp | `llvm/tools/llvm-opt-report/OptReport.cpp` | readLocationInfo関数（155-262行目） |

**主要処理フロー**:
- **156-162行目**: 備考ファイルをMemoryBufferで読み込み
- **164-171行目**: 備考形式を解析
- **173-182行目**: RemarkParserを作成
- **184-198行目**: 備考をループ処理
- **202-224行目**: VectorizationFactor、InterleaveCount、UnrollCountを抽出
- **226-232行目**: 位置情報（ファイル、行、列）を取得
- **237-241行目**: UpdateLLIIラムダでAnalyzed/Transformedを設定
- **243-258行目**: パス名に応じてInlined/Unrolled/Vectorizedに情報を格納

#### Step 4: レポート出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OptReport.cpp | `llvm/tools/llvm-opt-report/OptReport.cpp` | writeReport関数（264-477行目） |

**主要処理フロー**:
- **265-271行目**: 出力ファイルをオープン
- **274-294行目**: ファイル名を構築（InputRelDirを使用）
- **296-306行目**: 最大値を収集（表示幅計算用）
- **323-473行目**: 行ごとにループしてレポート出力
- **327-345行目**: 行の最適化情報を収集
- **347-371行目**: 関数名をデマングルして出力
- **412-420行目**: マーカー（I/U/V）を出力

### プログラム呼び出し階層図

```
main (479行目)
    │
    ├─ InitLLVM (480行目)
    │
    ├─ ParseCommandLineOptions (483行目)
    │
    ├─ readLocationInfo (489行目)
    │      ├─ MemoryBuffer::getFile (156行目)
    │      ├─ remarks::parseFormat (164行目)
    │      ├─ remarks::createRemarkParserFromMeta (173行目)
    │      └─ Parser.next() ループ (184行目)
    │             └─ LocationInfo[File][Line][Function][Column]に格納
    │
    └─ writeReport (491行目)
           ├─ raw_fd_ostream (266行目)
           ├─ ファイルごとのループ (274行目)
           │      ├─ MemoryBuffer::getFile (281行目)
           │      ├─ MaxLI集計 (299-302行目)
           │      └─ line_iterator (323行目)
           │             ├─ PrintLine ラムダ (327行目)
           │             │      ├─ ColsInfo構築
           │             │      ├─ デマングル (359-363行目)
           │             │      └─ マーカー出力 (412-420行目)
           │             └─ UniqueLIs処理 (446-472行目)
           └─ 出力完了
```

### データフロー図

```
[入力]                    [処理]                    [出力]

備考ファイル  ───▶  readLocationInfo  ───▶  LocationInfo
(YAML/Bitstream)        │                    (4階層マップ)
                        │
                        └─ ファイル→行→関数→列

ソースファイル ───▶  writeReport  ───▶  注釈付きレポート
                        │
                        ├─ LocationInfoと照合
                        ├─ マーカー生成 (I/U/V)
                        └─ ソースコード行と結合
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OptReport.cpp | `llvm/tools/llvm-opt-report/OptReport.cpp` | ソース | メインエントリーポイント（496行） |
| CMakeLists.txt | `llvm/tools/llvm-opt-report/CMakeLists.txt` | ビルド設定 | ビルド構成 |
| Remark.h | `llvm/include/llvm/Remarks/Remark.h` | ヘッダ | Remarkクラス |
| RemarkParser.h | `llvm/include/llvm/Remarks/RemarkParser.h` | ヘッダ | RemarkParserクラス |
