# 機能設計書 108-llvm-tli-checker

## 概要

本ドキュメントは、llvm-tli-checker機能の設計仕様を記述する。llvm-tli-checkerは、LLVMのTargetLibraryInfo（TLI）設定とSDKライブラリの実装を比較・検証するツールである。

### 本機能の処理概要

llvm-tli-checkerは、LLVMコンパイラのTargetLibraryInfo（TLI）が認識しているライブラリ関数と、実際のSDKライブラリ（libc等）に存在するシンボルを比較するツールである。TLIの設定が実際のターゲット環境と一致しているかを検証し、不一致を報告する。

**業務上の目的・背景**：LLVMコンパイラは、ターゲットプラットフォームで利用可能な標準ライブラリ関数を把握し、それに基づいて最適化を行う。例えば、memcpyが利用可能であれば、ループをmemcpy呼び出しに変換できる。しかし、TLIの設定が実際のライブラリと一致しない場合、存在しない関数を呼び出すコードを生成したり、利用可能な最適化を見逃したりする可能性がある。llvm-tli-checkerは、このような問題を検出するためのツールである。

**機能の利用シーン**：新しいターゲットプラットフォームのサポート開発時、TLI設定の検証、ライブラリ実装の確認に使用される。

**主要な処理内容**：
1. ターゲットトリプルに基づくTLI初期化
2. 入力ライブラリファイル（ELF形式）の解析
3. エクスポートされたシンボルの抽出
4. TLI認識関数とライブラリシンボルの比較
5. 一致/不一致レポートの生成

**関連システム・外部連携**：SDKライブラリファイル（.so、.a等）、ELFオブジェクトファイルと連携する。

**権限による制御**：特になし。ファイルシステムへの読み取り権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLIインターフェース | 主画面 | コマンドライン実行 |
| - | 比較レポート | 出力画面 | TLIとSDKの比較結果表示 |

## 機能種別

検証処理 / レポート生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| library-files | ファイルパスリスト | Yes* | SDKライブラリファイル | ELF形式 |
| --triple | 文字列 | No | ターゲットトリプル | - |
| --libdir | 文字列 | No | ライブラリディレクトリ | - |
| --dump-tli | フラグ | No | TLI設定をダンプ（入力ファイル不要） | - |
| --separate | フラグ | No | ライブラリごとに個別レポート | - |
| --report | 列挙 | No | レポートレベル（summary/discrepancy/full） | - |

*--dump-tli指定時は不要

### 入力データソース

- ELFオブジェクトファイル
- ELFアーカイブ（静的ライブラリ）
- コマンドライン引数
- @レスポンスファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TLIエントリ数 | テキスト | TLIが認識している関数数 |
| ライブラリシンボル数 | テキスト | SDKで見つかったシンボル数 |
| 比較結果 | テキスト | 一致/不一致のサマリー |
| 詳細レポート | テキスト | 個別関数の状態（フルモード時） |

### 出力形式

```
TLI knows N symbols, M available for 'triple'
Found X global function symbols in 'library'
<< Total TLI yes SDK no:  Y
>> Total TLI no  SDK yes: Z
== Total TLI yes SDK yes: W
PASS/FAIL: LLVM TLI matched/doesn't match SDK libraries.
```

### 出力先

標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ InitLLVM、引数解析
2. TLI初期化
   └─ ターゲットトリプルに基づくTLI作成
3. TLIエントリ数報告
   └─ reportNumberOfEntries
4. ライブラリ読み込み（dump-tli以外）
   └─ populateFromFile - シンボル抽出
5. 比較実行
   └─ TLI認識関数とSDKシンボルを照合
6. レポート出力
   └─ 一致/不一致の統計と詳細
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[InitLLVM]
    B --> C[引数解析]
    C --> D[TLI初期化]
    D --> E[reportNumberOfEntries]
    E --> F{dump-tli?}
    F -->|Yes| G[dumpTLIEntries]
    F -->|No| H[ライブラリファイルループ]
    H --> I[populateFromFile]
    I --> J[シンボル抽出]
    J --> K{separate?}
    K -->|Yes| L[個別比較レポート]
    K -->|No| M[全体比較]
    L --> N{次のファイル?}
    N -->|Yes| H
    N -->|No| O[終了]
    M --> P[比較レポート]
    P --> Q[PASS/FAIL判定]
    Q --> O
    G --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-108-1 | ELF形式限定 | 現在はELF形式のみサポート | 常時 |
| BR-108-2 | 動的シンボル優先 | ET_REL以外では動的シンボルテーブルを使用 | 共有ライブラリ時 |
| BR-108-3 | IFunc対応 | ST_Other + SF_Indirectも関数として認識 | 常時 |

### 計算ロジック

比較カテゴリ：
- TLI yes SDK yes (==): 両方で利用可能
- TLI yes SDK no (<<): TLIは認識するがSDKにない
- TLI no SDK yes (>>): SDKにあるがTLIは認識しない
- TLI no SDK no: 両方で利用不可

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 入力ファイルなし | ライブラリファイル未指定（dump-tli以外） | エラーメッセージ、終了 |
| - | ファイル読み込み失敗 | ファイルが存在しないまたは形式不正 | 警告出力、続行 |
| - | 非ELF形式 | ELF以外の形式 | 警告出力、スキップ |

### リトライ仕様

なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に定義なし。

## セキュリティ考慮事項

入力ファイルはELF形式として検証される。

## 備考

現在はELF形式のみサポート。将来的にCOFF/MachOサポートの可能性あり。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TargetLibraryInfo.h | `llvm/include/llvm/Analysis/TargetLibraryInfo.h` | TargetLibraryInfo、LibFunc列挙 |
| 1-2 | llvm-tli-checker.cpp | `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp` | SDKNameMapクラス（150-157行目） |

**読解のコツ**: TargetLibraryInfoがターゲットで利用可能な標準ライブラリ関数を管理し、SDKNameMapがELFからシンボルを収集することを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-tli-checker.cpp | `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp` | main関数（255-377行目） |
| 2-2 | Opts.td | `llvm/tools/llvm-tli-checker/Opts.td` | コマンドラインオプション定義 |

**主要処理フロー**:
1. **256-261行目**: InitLLVM、引数解析
2. **263-271行目**: ヘルプ表示
3. **273-278行目**: TLI初期化（TargetLibraryInfoImpl、TargetLibraryInfo）
4. **280-284行目**: dump-tli処理
5. **286-302行目**: ライブラリリスト取得、レポートレベル設定
6. **304-376行目**: ライブラリ処理とレポート生成

#### Step 3: シンボル抽出処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-tli-checker.cpp | `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp` | SDKNameMapクラスのメソッド群 |

**主要処理フロー**:
- **161-175行目**: maybeInsertSymbol - シンボルの種別とフラグをチェックして挿入
- **178-194行目**: populateFromObject - ELFオブジェクトからシンボル抽出
- **198-218行目**: populateFromArchive - アーカイブを展開してオブジェクト処理
- **221-253行目**: populateFromFile - ファイルを開いてバイナリ種別に応じた処理

#### Step 4: 比較処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-tli-checker.cpp | `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp` | 比較ループ（329-354行目） |

**主要処理フロー**:
- **329-330行目**: LibFunc列挙をループ
- **333-335行目**: TLIHasとSDKHasを判定
- **336-342行目**: Whichで4カテゴリに分類
- **344-353行目**: レポートレベルに応じて詳細出力

### プログラム呼び出し階層図

```
main (255行目)
    │
    ├─ InitLLVM (256行目)
    │
    ├─ TLICheckerOptTable::parseArgs (260行目)
    │
    ├─ TargetLibraryInfoImpl (275行目)
    │      └─ ターゲットトリプルからTLI初期化
    │
    ├─ reportNumberOfEntries (278行目)
    │      └─ TLI.has()でカウント
    │
    ├─ dumpTLIEntries (282行目) [--dump-tli時]
    │      └─ 全LibFuncをダンプ
    │
    └─ ライブラリ処理ループ (304行目)
           │
           ├─ SDKNames.populateFromFile (310または315行目)
           │      ├─ createBinary (230行目)
           │      ├─ populateFromArchive (240行目)
           │      │      └─ populateFromObject (213行目)
           │      └─ populateFromObject (242行目)
           │             └─ maybeInsertSymbol (188-192行目)
           │
           └─ 比較ループ (329行目)
                  ├─ TLI.has(LF)
                  ├─ SDKNames.count(TLIName)
                  └─ レポート出力 (344-353行目)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

ターゲットトリプル ───▶ TargetLibraryInfo ───▶ TLI認識関数リスト
    (--triple)                                    (has/getName)

ELFライブラリ ───▶ SDKNameMap ───▶ SDKシンボルマップ
    (.so/.a)          │
                      ├─ populateFromFile
                      ├─ ELFObjectFile解析
                      └─ シンボル抽出

TLI関数リスト ───▶ 比較処理 ───▶ レポート
SDKシンボル        │              (PASS/FAIL)
                   └─ 4カテゴリ分類
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-tli-checker.cpp | `llvm/tools/llvm-tli-checker/llvm-tli-checker.cpp` | ソース | メインエントリーポイント（378行） |
| Opts.td | `llvm/tools/llvm-tli-checker/Opts.td` | TableGen | コマンドラインオプション定義 |
| CMakeLists.txt | `llvm/tools/llvm-tli-checker/CMakeLists.txt` | ビルド設定 | ビルド構成 |
| TargetLibraryInfo.h | `llvm/include/llvm/Analysis/TargetLibraryInfo.h` | ヘッダ | TLIクラス |
| ELFObjectFile.h | `llvm/include/llvm/Object/ELFObjectFile.h` | ヘッダ | ELF解析クラス |
| Archive.h | `llvm/include/llvm/Object/Archive.h` | ヘッダ | アーカイブ解析クラス |
