# 機能設計書 111-llvm-debuginfo-analyzer

## 概要

本ドキュメントは、LLVMプロジェクトにおけるデバッグ情報解析ツール「llvm-debuginfo-analyzer」の機能設計を記述する。

### 本機能の処理概要

llvm-debuginfo-analyzerは、オブジェクトファイルやdSYMバンドルに含まれるデバッグ情報を論理的なビュー形式で表示・解析するツールである。DWARF形式やCodeView形式などの低レベルデバッグ情報を読み取り、人間が理解しやすい論理的な表現に変換して出力する。

**業務上の目的・背景**：コンパイラ開発やデバッガ開発において、生成されたデバッグ情報の正確性を検証することは重要な作業である。従来のツール（llvm-dwarfdump等）は低レベルな形式でデバッグ情報を表示するため、論理的な構造の理解や複数オブジェクト間の比較が困難であった。本ツールは、デバッグ情報を抽象化された論理ビューとして表示することで、開発者がデバッグ情報の品質を効率的に評価・比較できるようにする。

**機能の利用シーン**：
- コンパイラ開発時のデバッグ情報生成の検証
- 異なるコンパイラ間でのデバッグ情報の比較
- デバッグ情報の欠落やギャップの検出
- 最適化によるデバッグ情報への影響分析

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. 入力ファイル（オブジェクトファイル、dSYMバンドル）の読み込み
3. デバッグ情報リーダーの作成（DWARF/CodeView対応）
4. 論理ビューへの変換と要素の選択・フィルタリング
5. 指定された形式（テキスト/JSON）での出力
6. 複数ファイル間の比較処理（オプション）

**関連システム・外部連携**：LLVM DebugInfo/LogicalViewライブラリと連携し、DWARF形式およびCodeView（PDB）形式のデバッグ情報を処理する。

**権限による制御**：特になし。ファイルシステムへのアクセス権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

バイナリ解析 / データ変換 / 比較処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InputFilenames | string[] | No | 入力オブジェクトファイルまたは.dSYMバンドル（デフォルト: a.out） | ファイル存在確認 |
| --output-file | string | No | 出力ファイル名（デフォルト: 標準出力） | パス妥当性確認 |
| --print | enum[] | No | 表示する要素種別（all/elements/lines/scopes/symbols/types等） | 定義済み値 |
| --attribute | enum[] | No | 追加表示する属性（all/filename/location/offset等） | 定義済み値 |
| --select | pattern[] | No | 表示するパターン（正規表現対応） | 正規表現妥当性 |
| --compare | enum[] | No | 比較する要素種別（all/lines/scopes/symbols/types） | 定義済み値 |
| --output | enum[] | No | 出力形式（text/json/split） | 定義済み値 |
| --output-sort | enum | No | 出力ソート方式（line/name/offset/kind） | 定義済み値 |

### 入力データソース

- オブジェクトファイル（ELF/Mach-O/COFF形式）
- dSYMバンドルディレクトリ（macOS）
- アーカイブファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LogicalView | text/json | デバッグ情報の論理的表現 |
| CompareResult | text | 比較モード時の差分情報 |
| Warnings | text | 検出された警告（ギャップ、無効なロケーション等） |
| Summary | text | 要素の統計情報 |

### 出力先

- 標準出力（デフォルト）
- 指定されたファイル（--output-fileオプション）
- 分割ファイル（--output=split時、コンパイルユニットごと）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ターゲット情報、逆アセンブラの初期化
2. コマンドライン解析
   └─ オプションの解析とReaderOptionsへの反映
3. 出力ファイル準備
   └─ 出力先ファイルのオープン
4. 入力ファイル展開
   └─ dSYMバンドルの場合は内部ファイルを列挙
5. オプション伝播
   └─ コマンドラインオプションをグローバル設定に反映
6. リーダーハンドラ作成
   └─ LVReaderHandler生成、ファイル形式に応じたリーダー選択
7. デバッグ情報処理
   └─ 各入力ファイルの読み込み、論理ビュー構築、出力
8. 終了処理
   └─ リソース解放、戻り値設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ターゲット初期化]
    B --> C[コマンドライン解析]
    C --> D[出力ファイル準備]
    D --> E{入力ファイル指定あり?}
    E -->|No| F[a.outをデフォルト設定]
    E -->|Yes| G[ファイルリスト取得]
    F --> G
    G --> H{dSYMバンドル?}
    H -->|Yes| I[バンドル内ファイル展開]
    H -->|No| J[ファイルをそのまま使用]
    I --> J
    J --> K[オプション伝播]
    K --> L[LVReaderHandler作成]
    L --> M[デバッグ情報処理実行]
    M --> N{エラー発生?}
    N -->|Yes| O[エラー出力・終了]
    N -->|No| P[正常終了]
    O --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | デフォルト入力 | 入力ファイル未指定時はa.outを使用 | InputFilenamesが空の場合 |
| BR-002 | dSYMバンドル展開 | .dSYM拡張子のディレクトリは内部のDWARFファイルに展開 | 入力がdSYMバンドルの場合 |
| BR-003 | 比較モード | --compare-context指定時は最初のファイルを基準として比較 | 比較オプション有効時 |
| BR-004 | 出力分割 | --output=split指定時はコンパイルユニットごとにファイル分割 | split出力モード時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（ファイルベースのツール）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルオープンエラー | 出力ファイルが開けない | エラーメッセージ出力後終了 |
| - | ファイル読み込みエラー | 入力ファイルが読めない | エラーメッセージ出力後終了 |
| - | 不正ファイル形式 | 対応していないファイル形式 | エラーメッセージ出力後終了 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に規定なし。大規模なオブジェクトファイルの処理には相応の時間を要する。

## セキュリティ考慮事項

- 入力ファイルの検証（不正な形式への対応）
- 出力パスの妥当性確認

## 備考

- LLVM LogicalViewライブラリを基盤として利用
- DWARF形式とCodeView（PDB）形式の両方に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LVOptions（DebugInfo/LogicalView/Core/LVOptions.h）がオプション設定を保持する中心的なデータ構造である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Options.h | `llvm/tools/llvm-debuginfo-analyzer/Options.h` | コマンドラインオプションの宣言を確認 |
| 1-2 | LVOptions.h | `llvm/include/DebugInfo/LogicalView/Core/LVOptions.h` | ReaderOptionsの構造を理解 |

**読解のコツ**: cl::listやcl::optはLLVMのCommandLineライブラリで、コマンドラインオプションを宣言的に定義する仕組みである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-debuginfo-analyzer.cpp | `llvm/tools/llvm-debuginfo-analyzer/llvm-debuginfo-analyzer.cpp` | main関数の処理フローを把握 |

**主要処理フロー**:
1. **85-91行目**: InitLLVMとターゲット初期化
2. **95-104行目**: コマンドラインオプション解析
3. **106-110行目**: 出力ファイル準備
4. **112-121行目**: 入力ファイル処理とdSYMバンドル展開
5. **123-138行目**: ReaderHandler作成と処理実行

#### Step 3: オプション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Options.cpp | `llvm/tools/llvm-debuginfo-analyzer/Options.cpp` | 各オプションカテゴリの定義とpropagateOptions関数 |

**主要処理フロー**:
- **40行目**: ReaderOptionsグローバル変数
- **45-130行目**: --attribute オプション定義
- **132-154行目**: --compare オプション定義
- **470-508行目**: propagateOptions関数でオプションをReaderOptionsに反映

#### Step 4: リーダーハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LVReaderHandler.h | `llvm/include/DebugInfo/LogicalView/LVReaderHandler.h` | リーダーハンドラのインターフェース |

**主要処理フロー**:
- LVReaderHandlerがファイル形式を判別し、適切なリーダー（LVDWARFReader/LVCodeViewReader）を作成
- process()メソッドで全入力ファイルを処理

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitLLVM / InitializeAllTargets系
    │
    ├─ cl::ParseCommandLineOptions
    │      └─ Options.cpp で定義されたオプション解析
    │
    ├─ expandBundle()
    │      └─ dSYMバンドルを個別ファイルに展開
    │
    ├─ propagateOptions()
    │      └─ ReaderOptionsへのオプション反映
    │
    └─ LVReaderHandler::process()
           ├─ createReader() - ファイル形式判別
           │      ├─ LVDWARFReader
           │      └─ LVCodeViewReader
           └─ 各リーダーでデバッグ情報処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

オブジェクトファイル ───▶ LVReaderHandler ───▶ 論理ビュー表示
    │                         │
    │                         ├─ DWARF解析
dSYMバンドル ────────────▶    ├─ CodeView解析        ───▶ テキスト/JSON
    │                         ├─ 論理ビュー構築
    │                         └─ フィルタリング・比較
コマンドラインオプション ──▶ ReaderOptions
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-debuginfo-analyzer.cpp | `llvm/tools/llvm-debuginfo-analyzer/` | ソース | メインエントリーポイント |
| Options.cpp | `llvm/tools/llvm-debuginfo-analyzer/` | ソース | コマンドラインオプション定義 |
| Options.h | `llvm/tools/llvm-debuginfo-analyzer/` | ヘッダ | オプション宣言 |
| LVReaderHandler.h | `llvm/include/DebugInfo/LogicalView/` | ヘッダ | リーダーハンドラインターフェース |
| LVOptions.h | `llvm/include/DebugInfo/LogicalView/Core/` | ヘッダ | オプション設定構造体 |
| CMakeLists.txt | `llvm/tools/llvm-debuginfo-analyzer/` | 設定 | ビルド設定 |
