# 機能設計書 112-llvm-cxxdump

## 概要

本ドキュメントは、LLVMプロジェクトにおけるC++ ABIデータダンプツール「llvm-cxxdump」の機能設計を記述する。

### 本機能の処理概要

llvm-cxxdumpは、オブジェクトファイルやアーカイブに含まれるC++ ABI（Application Binary Interface）関連のデータ構造を解析し、人間が読める形式でダンプするツールである。Microsoft Visual C++（MS-ABI）とItanium C++ ABI両方の実行時型情報（RTTI）、仮想関数テーブル（VFTable/VTable）、仮想基底テーブル（VBTable）などを表示できる。

**業務上の目的・背景**：C++コンパイラの開発やデバッグにおいて、生成されたC++ ABIデータ構造の正確性を検証することは重要である。ABIの不整合はリンクエラーや実行時クラッシュの原因となる。本ツールは、コンパイラが生成したABIデータを可視化することで、開発者がABIの実装を検証・デバッグできるようにする。

**機能の利用シーン**：
- コンパイラ開発時のC++ ABI実装の検証
- 異なるコンパイラ間でのABI互換性調査
- RTTIや仮想関数テーブルの構造確認
- C++例外処理機構のデバッグ

**主要な処理内容**：
1. コマンドライン引数の解析
2. 入力ファイル（オブジェクトファイル、アーカイブ）の読み込み
3. シンボルテーブルの走査とC++ ABIシンボルの識別
4. 各種ABIデータ構造の解析（VFTable、VBTable、RTTI等）
5. リロケーション情報の収集と解決
6. 解析結果の標準出力への表示

**関連システム・外部連携**：LLVM Object/SymbolSize ライブラリを利用してオブジェクトファイルを解析する。

**権限による制御**：特になし。ファイルシステムへのアクセス権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

バイナリ解析 / データダンプ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InputFilenames | string[] | No | 入力オブジェクトファイル（デフォルト: 標準入力） | ファイル存在確認 |

### 入力データソース

- オブジェクトファイル（ELF/COFF/Mach-O形式）
- アーカイブファイル（.a形式）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| VFTableEntries | text | MS-ABI仮想関数テーブルエントリ |
| VBTableData | text | MS-ABI仮想基底テーブルデータ |
| COLData | text | Complete Object Locatorデータ |
| CHDData | text | Class Hierarchy Descriptorデータ |
| BCDData | text | Base Class Descriptorデータ |
| TDData | text | Type Descriptorデータ |
| TIData | text | Throw Infoデータ（例外処理） |
| CTAData | text | Catchable Type Arrayデータ |
| CTData | text | Catchable Typeデータ |
| VTableEntries | text | Itanium ABI仮想テーブルエントリ |
| VTTEntries | text | Virtual Table Tableエントリ |
| TINames | text | Type Info名 |

### 出力先

- 標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ターゲット情報の初期化
2. コマンドライン解析
   └─ 入力ファイル名の取得
3. 入力ファイル処理ループ
   ├─ ファイルオープン（createBinary）
   ├─ アーカイブの場合：子要素を再帰処理
   └─ オブジェクトファイルの場合：dumpCXXData実行
4. C++データダンプ
   ├─ セクション→リロケーションマップの構築
   ├─ シンボル走査とサイズ計算
   ├─ シンボル名に基づくABIデータ識別
   │   ├─ ??_7: VFTable（MS-ABI）
   │   ├─ ??_8: VBTable（MS-ABI）
   │   ├─ ??_R0-R4: RTTI構造（MS-ABI）
   │   ├─ _TI/_CTA/_CT: 例外処理（MS-ABI）
   │   ├─ _ZTV/_ZTT/_ZTI/_ZTS: Itanium ABI
   │   └─ その他ABI構造
   └─ 収集データの出力
5. 終了処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ターゲット初期化]
    B --> C[コマンドライン解析]
    C --> D{入力ファイル指定?}
    D -->|No| E[stdin使用]
    D -->|Yes| F[ファイルリスト取得]
    E --> G[dumpInput呼び出し]
    F --> G
    G --> H{バイナリ種別判定}
    H -->|Archive| I[dumpArchive: 子要素を再帰処理]
    H -->|ObjectFile| J[dumpCXXData]
    H -->|その他| K[エラー: 未対応形式]
    I --> J
    J --> L[セクションリロケーションマップ構築]
    L --> M[シンボル走査]
    M --> N{シンボル名パターン判定}
    N -->|??_7| O[VFTable解析]
    N -->|??_8| P[VBTable解析]
    N -->|??_R0-R4| Q[RTTI解析]
    N -->|_ZTV等| R[Itanium ABI解析]
    N -->|その他| S[スキップ]
    O --> T[結果出力]
    P --> T
    Q --> T
    R --> T
    S --> M
    T --> U[終了]
    K --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | デフォルト入力 | 入力ファイル未指定時は標準入力を使用 | InputFilenamesが空の場合 |
| BR-002 | シンボル名パターン | MS-ABIシンボルは??_で始まる | シンボル名判定時 |
| BR-003 | Itaniumシンボル | Itanium ABIシンボルは_Z（または__Z）で始まる | シンボル名判定時 |
| BR-004 | アーカイブ展開 | アーカイブは子要素を個別に処理 | 入力がアーカイブの場合 |
| BR-005 | BSS/仮想セクション除外 | BSS・仮想セクションのシンボルはスキップ | セクション判定時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（ファイルベースのツール）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| unrecognized_file_format | ファイル形式エラー | 未対応のファイル形式 | エラーメッセージ出力 |
| - | ファイル読み込みエラー | ファイルが開けない | エラーメッセージ出力後終了 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に規定なし

## セキュリティ考慮事項

- 入力ファイルの検証（不正な形式への対応）

## 備考

- MS-ABIとItanium ABI両方に対応
- 32ビットと64ビットの両アドレスサイズに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

dumpCXXData関数内で定義されるローカル構造体がABIデータを表現する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-cxxdump.cpp | `llvm/tools/llvm-cxxdump/llvm-cxxdump.cpp` | 127-169行目のローカル構造体定義を確認 |

**読解のコツ**:
- CompleteObjectLocator, ClassHierarchyDescriptor, BaseClassDescriptor, TypeDescriptor はMS-ABI RTTI構造
- ThrowInfo, CatchableTypeArray, CatchableType はMS-ABI例外処理構造
- little32_t/little64_t はリトルエンディアン整数型

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-cxxdump.cpp | `llvm/tools/llvm-cxxdump/llvm-cxxdump.cpp` | main関数（543-562行目）の処理フロー |

**主要処理フロー**:
1. **543-544行目**: InitLLVMとターゲット初期化
2. **550-553行目**: コマンドライン解析
3. **555-557行目**: デフォルト入力（stdin）設定
4. **559行目**: for_eachでdumpInput呼び出し

#### Step 3: 入力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-cxxdump.cpp | `llvm/tools/llvm-cxxdump/llvm-cxxdump.cpp` | dumpInput関数（525-541行目） |

**主要処理フロー**:
- **527行目**: createBinaryでファイルを開く
- **535-536行目**: Archive判定→dumpArchive呼び出し
- **537-538行目**: ObjectFile判定→dumpCXXData呼び出し
- **539-540行目**: その他→エラー

#### Step 4: C++データダンプを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-cxxdump.cpp | `llvm/tools/llvm-cxxdump/llvm-cxxdump.cpp` | dumpCXXData関数（126-498行目） |

**主要処理フロー**:
- **176-185行目**: セクション→リロケーションマップの構築
- **189-191行目**: シンボルサイズ計算
- **192-343行目**: シンボル走査とパターンマッチング
  - **220-225行目**: ??_7（VFTable）処理
  - **228-233行目**: ??_8（VBTable）処理
  - **235-242行目**: ??_R4（COL）処理
  - **269-280行目**: ??_R0（TypeDescriptor）処理
  - **312-320行目**: _ZTT（VTT）処理
  - **321-338行目**: _ZTV（VTable）処理
- **344-497行目**: 収集データの出力

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitLLVM / InitializeAllTargetInfos
    │
    ├─ cl::ParseCommandLineOptions
    │
    └─ for_each(InputFilenames, dumpInput)
           │
           ├─ createBinary()
           │
           └─ Archive? ──▶ dumpArchive()
              │                 └─ dumpCXXData() [再帰]
              │
              └─ ObjectFile? ──▶ dumpCXXData()
                                    │
                                    ├─ SectionRelocMap構築
                                    ├─ computeSymbolSizes()
                                    ├─ シンボル走査ループ
                                    │   ├─ collectRelocatedSymbols()
                                    │   └─ collectRelocationOffsets()
                                    └─ 結果出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

オブジェクトファイル ───▶ createBinary ───▶ ObjectFile
        │                      │
        │                      ▼
        │               dumpCXXData
        │                      │
        │        ┌─────────────┼─────────────┐
        │        ▼             ▼             ▼
        │   VFTable解析   RTTI解析    Itanium解析
        │        │             │             │
        │        └─────────────┼─────────────┘
        │                      ▼
        └──────────────▶ 標準出力
                        (テキスト形式)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-cxxdump.cpp | `llvm/tools/llvm-cxxdump/` | ソース | メイン処理 |
| llvm-cxxdump.h | `llvm/tools/llvm-cxxdump/` | ヘッダ | 共通宣言 |
| Error.cpp | `llvm/tools/llvm-cxxdump/` | ソース | エラー処理 |
| Error.h | `llvm/tools/llvm-cxxdump/` | ヘッダ | エラー定義 |
| CMakeLists.txt | `llvm/tools/llvm-cxxdump/` | 設定 | ビルド設定 |
