# 機能設計書 113-llvm-cxxmap

## 概要

本ドキュメントは、LLVMプロジェクトにおけるC++マングル名リマッピングツール「llvm-cxxmap」の機能設計を記述する。

### 本機能の処理概要

llvm-cxxmapは、C++マングル名（シンボル名）間の対応関係を計算するツールである。シンボル等価性ファイル（remapping file）を使用して、古いシンボルリストから新しいシンボルリストへのマッピングを生成する。これは主にプロファイルデータの移行やシンボル名変更時のプロファイル互換性維持に使用される。

**業務上の目的・背景**：C++プログラムの最適化において、PGO（Profile-Guided Optimization）は重要な手法である。しかし、ソースコードの変更によりシンボル名が変わると、以前のプロファイルデータが使えなくなる。本ツールは、シンボル名の等価性ルールを定義することで、異なるシンボル名間のマッピングを生成し、プロファイルデータの再利用を可能にする。

**機能の利用シーン**：
- PGOプロファイルデータの移行
- コンパイラアップグレード時のプロファイル互換性維持
- 名前空間変更後のプロファイル再利用
- テンプレートインスタンス化の変更への対応

**主要な処理内容**：
1. コマンドライン引数の解析
2. 旧シンボルファイルの読み込み
3. 新シンボルファイルの読み込み
4. リマッピングファイルの読み込みと等価性ルール構築
5. 新シンボルの正規化（canonicalize）
6. 旧シンボルから新シンボルへのマッピング計算
7. マッピング結果の出力

**関連システム・外部連携**：LLVM ProfileData/SymbolRemappingReaderライブラリを使用してシンボル等価性の処理を行う。

**権限による制御**：特になし。ファイルシステムへのアクセス権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

データ変換 / マッピング生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| OldSymbolFile | string | Yes | 旧シンボルリストファイル | ファイル存在確認 |
| NewSymbolFile | string | Yes | 新シンボルリストファイル | ファイル存在確認 |
| -r/--remapping-file | string | Yes | シンボル等価性定義ファイル | ファイル存在確認 |
| -o/--output | string | No | 出力ファイル（デフォルト: 標準出力） | パス妥当性確認 |
| -Wambiguous | bool | No | 出力シンボルリスト内の等価シンボルを警告 | - |
| -Wincomplete | bool | No | 出力シンボルに対応しない入力シンボルを警告 | - |

### 入力データソース

- 旧シンボルファイル: 1行1シンボルのテキストファイル（#でコメント）
- 新シンボルファイル: 1行1シンボルのテキストファイル（#でコメント）
- リマッピングファイル: シンボル等価性ルール定義ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SymbolMapping | text | 「旧シンボル 新シンボル」の対応行 |

### 出力先

- 標準出力（デフォルト）
- 指定されたファイル（-oオプション）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ InitLLVM
2. コマンドライン解析
   └─ オプション取得
3. ファイル読み込み
   ├─ 旧シンボルファイル読み込み
   ├─ 新シンボルファイル読み込み
   └─ リマッピングファイル読み込み
4. 出力ファイル準備
   └─ 出力先オープン
5. シンボルリマッピング実行
   ├─ SymbolRemappingReader初期化
   ├─ 新シンボルの正規化と登録
   │   ├─ 各シンボルをReaderに挿入
   │   └─ 重複等価シンボル警告（-Wambiguous時）
   └─ 旧シンボルから新シンボルへのマッピング
       ├─ 各旧シンボルのルックアップ
       ├─ マッピング結果の出力
       └─ 未マッチシンボル警告（-Wincomplete時）
6. 終了処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[InitLLVM]
    B --> C[コマンドライン解析]
    C --> D[旧シンボルファイル読み込み]
    D --> E[新シンボルファイル読み込み]
    E --> F[リマッピングファイル読み込み]
    F --> G[出力ファイルオープン]
    G --> H[SymbolRemappingReader作成]
    H --> I[新シンボル走査ループ]
    I --> J{パース可能?}
    J -->|No| K[UnparseableSymbols登録]
    J -->|Yes| L[Readerに挿入]
    L --> M{重複等価?}
    M -->|Yes| N[-Wambiguous警告]
    M -->|No| O[MappedNamesに登録]
    K --> P{次のシンボル?}
    N --> P
    O --> P
    P -->|Yes| I
    P -->|No| Q[旧シンボル走査ループ]
    Q --> R[Reader.lookup実行]
    R --> S{マッチあり?}
    S -->|Yes| T[マッピング出力]
    S -->|No| U{-Wincomplete?}
    U -->|Yes| V[警告出力]
    U -->|No| W[スキップ]
    T --> X{次のシンボル?}
    V --> X
    W --> X
    X -->|Yes| Q
    X -->|No| Y[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | コメント行スキップ | #で始まる行はコメントとしてスキップ | シンボルファイル読み込み時 |
| BR-002 | 空行スキップ | 空白のみの行はスキップ | シンボルファイル読み込み時 |
| BR-003 | 重複等価シンボル | 出力リスト内で等価なシンボルは後のものが無視される | -Wambiguous有効時に警告 |
| BR-004 | パース不能シンボル | デマングルできないシンボルはマッピング対象外 | シンボル処理時 |
| BR-005 | 大文字小文字区別 | シンボル名の比較は大文字小文字を区別する | デフォルト動作 |

### 計算ロジック

シンボル等価性の判定はSymbolRemappingReaderライブラリが行う。等価性ルールに基づいて正規化されたキーが一致するシンボルを等価とみなす。

## データベース操作仕様

該当なし（ファイルベースのツール）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルオープンエラー | 入力/出力ファイルが開けない | エラーメッセージ出力後終了 |
| - | リマッピングファイルエラー | リマッピングファイルの形式不正 | エラーメッセージ出力後終了 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に規定なし

## セキュリティ考慮事項

- 入力ファイルの検証

## 備考

- llvm-profdataツールと連携してプロファイルのリマッピングに使用
- SymbolRemappingReaderの等価性ルール形式は別途ドキュメント参照

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SymbolRemappingReaderがシンボル等価性を管理する中心的なクラスである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SymbolRemappingReader.h | `llvm/include/ProfileData/SymbolRemappingReader.h` | Readerのインターフェース |

**読解のコツ**: insert()でシンボルを登録し、lookup()で等価シンボルを検索する。Keyは等価性ルールで正規化された値。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-cxxmap.cpp | `llvm/tools/llvm-cxxmap/llvm-cxxmap.cpp` | main関数（142-170行目） |

**主要処理フロー**:
1. **143行目**: InitLLVM
2. **145-146行目**: コマンドライン解析
3. **148-161行目**: ファイル読み込み
4. **163-166行目**: 出力ファイルオープン
5. **168-169行目**: remapSymbols呼び出し

#### Step 3: リマッピング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-cxxmap.cpp | `llvm/tools/llvm-cxxmap/llvm-cxxmap.cpp` | remapSymbols関数（88-140行目） |

**主要処理フロー**:
- **93-95行目**: SymbolRemappingReader作成とリマッピングファイル読み込み
- **98-119行目**: 新シンボル処理ループ
  - **104-108行目**: パース不能シンボルの処理
  - **110-118行目**: MappedNamesへの登録と重複警告
- **122-139行目**: 旧シンボル処理ループ
  - **126-127行目**: lookup実行
  - **129-136行目**: マッチなし時の警告
  - **138行目**: マッピング結果出力

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitLLVM
    │
    ├─ cl::ParseCommandLineOptions
    │
    ├─ MemoryBuffer::getFileOrSTDIN (x3)
    │      ├─ OldSymbolFile
    │      ├─ NewSymbolFile
    │      └─ RemappingFile
    │
    ├─ raw_fd_ostream (出力ファイル)
    │
    └─ remapSymbols()
           │
           ├─ SymbolRemappingReader::read()
           │      └─ リマッピングルール解析
           │
           ├─ 新シンボル処理ループ
           │      ├─ Reader.insert()
           │      └─ MappedNames登録
           │
           └─ 旧シンボル処理ループ
                  ├─ Reader.lookup()
                  └─ Out << マッピング結果
```

### データフロー図

```
[入力]                        [処理]                         [出力]

旧シンボルファイル ──────▶
                           remapSymbols()
新シンボルファイル ──────▶      │                      ──▶ マッピングファイル
                              │                          (old new)
リマッピングファイル ────▶ SymbolRemapping
                              Reader
                              │
                        ┌─────┴─────┐
                        ▼           ▼
                   新シンボル   旧シンボル
                   正規化       ルックアップ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-cxxmap.cpp | `llvm/tools/llvm-cxxmap/` | ソース | メイン処理 |
| SymbolRemappingReader.h | `llvm/include/ProfileData/` | ヘッダ | シンボル等価性処理 |
| SymbolRemappingReader.cpp | `llvm/lib/ProfileData/` | ソース | シンボル等価性実装 |
| CMakeLists.txt | `llvm/tools/llvm-cxxmap/` | 設定 | ビルド設定 |
