# 機能設計書 115-llvm-cgdata

## 概要

本ドキュメントは、LLVMプロジェクトにおけるコードグラフデータ操作ツール「llvm-cgdata」の機能設計を記述する。

### 本機能の処理概要

llvm-cgdataは、コンパイル済みバイナリファイルに埋め込まれたコードグラフデータ（codegen data）を解析・マージし、.cgdataファイルを生成・操作するツールである。コードグラフデータには、アウトライニング情報（Outlined Hash Tree）やStable Function Mapなどが含まれ、後続のビルドでコード最適化に使用される。

**業務上の目的・背景**：LTOやマシンアウトライナーなどの最適化において、複数のコンパイルユニット間で共通するコードパターンを識別することは効率化に重要である。本ツールは、個別にコンパイルされたオブジェクトファイルからコードグラフデータを抽出・マージし、後続ビルドで再利用可能な形式に統合する。これにより、繰り返しビルドの最適化効率が向上する。

**機能の利用シーン**：
- 複数オブジェクトファイルからのコードグラフデータ抽出
- .cgdataファイルのマージ
- コードグラフデータの形式変換（テキスト/バイナリ）
- コードグラフデータの内容確認

**主要な処理内容**：
1. アクション（show/convert/merge）の判定
2. 入力ファイルの読み込み
3. コードグラフデータの解析
4. データのマージ・変換
5. 出力ファイルへの書き込み

**関連システム・外部連携**：LLVM CGData/CodeGenDataReader、CodeGenDataWriterライブラリを使用。

**権限による制御**：特になし。ファイルシステムへのアクセス権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | CLI | 主機能 | コマンドラインインターフェースによる操作 |

## 機能種別

データ変換 / データマージ / データ表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| アクション | enum | Yes | show, convert, merge のいずれか | 有効なアクション |
| 入力ファイル | string[] | Yes | 入力ファイル（オブジェクト、アーカイブ、.cgdata） | ファイル存在確認 |
| -o/--output | string | No | 出力ファイル（デフォルト: 標準出力） | パス妥当性確認 |
| --format | enum | No | 出力形式（text/binary） | 有効な形式 |
| --cgdata-version | bool | No | バージョン表示フラグ | - |
| --skip-trim | bool | No | トリム処理スキップフラグ | - |

### 入力データソース

- オブジェクトファイル（ELF/COFF/Mach-O形式）
- アーカイブファイル（.a形式）
- .cgdataファイル（テキストまたはバイナリ形式）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CGData | text/binary | コードグラフデータ |
| Summary | text | show時のサマリー情報 |

### 出力先

- 標準出力（デフォルト）
- 指定されたファイル（-oオプション）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン解析
   └─ アクション、オプション取得
2. アクション判定
   ├─ show: データ表示
   │   ├─ CodeGenDataReader作成
   │   ├─ バージョン表示（オプション）
   │   └─ 各データ種別の統計情報出力
   ├─ convert: 形式変換
   │   ├─ CodeGenDataReader作成
   │   ├─ データ読み込み
   │   └─ 指定形式で出力
   └─ merge: データマージ
       ├─ 各入力ファイル処理
       │   ├─ オブジェクト/アーカイブからデータ抽出
       │   └─ グローバルレコードにマージ
       ├─ ファイナライズ（トリムオプション考慮）
       └─ 結果出力
3. 終了処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C{アクション判定}
    C -->|show| D[show_main]
    C -->|convert| E[convert_main]
    C -->|merge| F[merge_main]
    D --> G[CodeGenDataReader作成]
    G --> H[バージョン表示?]
    H -->|Yes| I[バージョン出力]
    H -->|No| J[データ統計出力]
    I --> J
    J --> K[終了]
    E --> L[CodeGenDataReader作成]
    L --> M[データ読み込み]
    M --> N{出力形式}
    N -->|text| O[writeText]
    N -->|binary| P[write]
    O --> K
    P --> K
    F --> Q[入力ファイルループ]
    Q --> R{ファイル種別}
    R -->|Object| S[mergeFromObjectFile]
    R -->|Archive| T[handleArchive]
    S --> U[GlobalRecordにマージ]
    T --> U
    U --> V{次のファイル?}
    V -->|Yes| Q
    V -->|No| W[finalize]
    W --> X[結果出力]
    X --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | アクション必須 | show/convert/mergeのいずれかが必要 | 起動時 |
| BR-002 | show/convertは単一入力 | show/convertは1ファイルのみ受け付ける | show/convert時 |
| BR-003 | mergeは複数入力可 | mergeは複数ファイルを受け付ける | merge時 |
| BR-004 | convertデフォルト出力 | convertのデフォルト出力形式はtext | convert時 |
| BR-005 | mergeデフォルト出力 | mergeのデフォルト出力形式はbinary | merge時 |
| BR-006 | 入出力ファイル重複禁止 | 入力と出力が同じファイルは不可 | 常時 |

### 計算ロジック

- Outlined Hash Tree: ハッシュベースのコードパターンマッチング
- Stable Function Map: 関数の安定したハッシュによるマッピング

## データベース操作仕様

該当なし（ファイルベースのツール）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルエラー | 入力ファイルが開けない | エラーメッセージ出力後終了 |
| - | 形式エラー | サポートされていないファイル形式 | エラーメッセージ出力後終了 |
| - | マージ失敗 | マージ処理でエラー発生 | エラーメッセージ出力後終了 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特に規定なし

## セキュリティ考慮事項

- 入力ファイルの検証

## 備考

- LTO最適化との連携を想定
- マシンアウトライナーとの連携を想定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OutlinedHashTreeRecordとStableFunctionMapRecordがコードグラフデータの主要構造。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeGenDataReader.h | `llvm/include/CGData/CodeGenDataReader.h` | データリーダーのインターフェース |

**読解のコツ**: hasOutlinedHashTree()、hasStableFunctionMap()でデータ存在を確認し、release*()でデータを取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-cgdata.cpp | `llvm/tools/llvm-cgdata/llvm-cgdata.cpp` | llvm_cgdata_main関数（369-383行目） |

**主要処理フロー**:
1. **371行目**: parseArgs呼び出し
2. **373-380行目**: アクション分岐
  - **374-375行目**: Convert
  - **376-377行目**: Merge
  - **378-379行目**: Show

#### Step 3: 各アクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-cgdata.cpp | `llvm/tools/llvm-cgdata/llvm-cgdata.cpp` | show_main（247-281行目）、convert_main（112-146行目）、merge_main（209-245行目） |

**show_main処理フロー**:
- **254-256行目**: CodeGenDataReader作成
- **259-260行目**: バージョン表示
- **262-269行目**: Outlined Hash Tree統計出力
- **270-278行目**: Stable Function Map統計出力

**convert_main処理フロー**:
- **122-124行目**: CodeGenDataReader作成
- **128-131行目**: OutlinedHashTreeRecord取得
- **132-135行目**: StableFunctionMapRecord取得
- **137-143行目**: 形式に応じた出力

**merge_main処理フロー**:
- **213-215行目**: 入力ファイルループでhandleFile呼び出し
- **220行目**: ファイナライズ（SkipTrimオプション考慮）
- **222-226行目**: レコード追加
- **236-242行目**: 形式に応じた出力

### プログラム呼び出し階層図

```
llvm_cgdata_main()
    │
    ├─ parseArgs()
    │      ├─ アクション解析
    │      ├─ 入力ファイル解析
    │      └─ オプション解析
    │
    ├─ show_main()
    │      └─ CodeGenDataReader::create()
    │
    ├─ convert_main()
    │      ├─ CodeGenDataReader::create()
    │      └─ CodeGenDataWriter::write/writeText()
    │
    └─ merge_main()
           ├─ handleFile() [各入力]
           │      ├─ handleBuffer()
           │      │      ├─ ObjectFile → mergeFromObjectFile()
           │      │      └─ Archive → handleArchive()
           │      └─ GlobalRecordにマージ
           ├─ finalize()
           └─ CodeGenDataWriter::write/writeText()
```

### データフロー図

```
[show]
.cgdataファイル ───▶ CodeGenDataReader ───▶ 統計情報表示
                          │
                    ┌─────┴─────┐
                    ▼           ▼
              HashTree     FunctionMap
               統計          統計

[convert]
.cgdataファイル ───▶ CodeGenDataReader ───▶ CodeGenDataWriter ───▶ text/binary

[merge]
オブジェクト1 ──┐
オブジェクト2 ──┼──▶ mergeFromObjectFile ──▶ GlobalRecord ──▶ finalize ──▶ .cgdata
アーカイブ   ──┘              │                   │
                        OutlinedHashTree    StableFunctionMap
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-cgdata.cpp | `llvm/tools/llvm-cgdata/` | ソース | メイン処理 |
| Opts.td | `llvm/tools/llvm-cgdata/` | テーブルジェン | オプション定義 |
| CodeGenDataReader.h | `llvm/include/CGData/` | ヘッダ | データ読み込み |
| CodeGenDataWriter.h | `llvm/include/CGData/` | ヘッダ | データ書き込み |
| CMakeLists.txt | `llvm/tools/llvm-cgdata/` | 設定 | ビルド設定 |
