# 機能設計書 12-Compiler-RT

## 概要

本ドキュメントは、LLVMプロジェクトにおけるCompiler-RT（Compiler Runtime）の機能設計書である。Compiler-RTは、コンパイラが生成するコードが必要とするランタイムサポートルーチンを提供するライブラリ群であり、サニタイザ、プロファイラ、組み込み関数などを含む。

### 本機能の処理概要

Compiler-RTは、コンパイラが生成するコードの実行時に必要となる様々なサポートルーチンを提供する。これには、ハードウェアが直接サポートしない演算のソフトウェア実装、メモリ安全性を検証するサニタイザ、性能プロファイリング機能などが含まれる。

**業務上の目的・背景**：現代のコンパイラは、ターゲットハードウェアが直接サポートしない機能や、デバッグ・品質保証のための追加機能を必要とする。Compiler-RTは、これらの機能を統一されたインターフェースで提供し、LLVMベースのコンパイラ（Clang等）が様々なプラットフォームで動作することを可能にする。特にサニタイザは、本番環境にリリースする前にメモリバグやデータ競合を検出するために不可欠なツールである。

**機能の利用シーン**：
- ソフトウェア除算、128ビット演算など（builtins）：組み込みシステムや特殊なハードウェア環境
- AddressSanitizer（ASan）：メモリバグ（バッファオーバーフロー等）の検出
- ThreadSanitizer（TSan）：データ競合の検出
- MemorySanitizer（MSan）：未初期化メモリの読み取り検出
- UndefinedBehaviorSanitizer（UBSan）：未定義動作の検出
- プロファイラ：コードカバレッジ収集、PGO用プロファイル生成

**主要な処理内容**：
1. **builtins**：コンパイラが生成する組み込み関数の実装（除算、乗算、浮動小数点演算等）
2. **sanitizers**：実行時メモリ・スレッド安全性チェック
3. **profile**：コードカバレッジとプロファイルデータ収集
4. **xray**：関数トレーシングとプロファイリング
5. **fuzzer**：ファジングテスト用ランタイム（libFuzzer）
6. **orc**：ORC JITコンパイラ用ランタイムサポート

**関連システム・外部連携**：
- Clang：コンパイル時に-fsanitize=オプションでサニタイザを有効化
- LLVM：LLVMパスによるインストルメンテーション
- llvm-cov：カバレッジデータの可視化
- llvm-profdata：プロファイルデータのマージ・変換

**権限による制御**：特になし。ただし、一部のサニタイザは特権操作（mmap等）を必要とする。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ランタイムライブラリのため画面なし |

## 機能種別

ランタイムライブラリ / コンパイラサポートルーチン / サニタイザ / プロファイラ

## 入力仕様

### 入力パラメータ

Compiler-RTはライブラリであり、コンパイラオプションを通じて使用される。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -fsanitize=address | flag | No | AddressSanitizerを有効化 | - |
| -fsanitize=thread | flag | No | ThreadSanitizerを有効化 | - |
| -fsanitize=memory | flag | No | MemorySanitizerを有効化 | - |
| -fsanitize=undefined | flag | No | UBSanを有効化 | - |
| -fprofile-instr-generate | flag | No | プロファイル収集を有効化 | - |
| -fcoverage-mapping | flag | No | カバレッジ収集を有効化 | - |
| -fxray-instrument | flag | No | XRayを有効化 | - |
| ASAN_OPTIONS | env | No | ASanランタイムオプション | 形式チェック |
| TSAN_OPTIONS | env | No | TSanランタイムオプション | 形式チェック |

### 入力データソース

- コンパイラオプション（ビルド時）
- 環境変数（実行時）
- 設定ファイル（一部サニタイザ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 静的ライブラリ | .a | リンク時に結合されるライブラリ |
| 動的ライブラリ | .so/.dylib | 実行時にロードされるライブラリ |
| エラーレポート | stderr | サニタイザが検出した問題のレポート |
| プロファイルデータ | .profraw | llvm-profdataで処理するプロファイル |
| カバレッジデータ | .profdata | llvm-covで可視化するカバレッジ |

### 出力先

- ライブラリファイル：ビルドディレクトリ/インストールディレクトリ
- エラーレポート：標準エラー出力（または指定ファイル）
- プロファイル：default.profraw（またはLLVM_PROFILE_FILE環境変数で指定）

## 処理フロー

### 処理シーケンス（AddressSanitizer例）

```
1. コンパイル時
   └─ Clangが-fsanitize=addressを検出
   └─ LLVMパスでメモリアクセスにインストルメンテーション挿入
   └─ リンク時にlibasan.aをリンク

2. プログラム起動時
   └─ ASanランタイムの初期化（__asan_init）
   └─ シャドウメモリのセットアップ
   └─ インターセプタの設定（malloc/free等）

3. 実行時
   └─ 各メモリアクセスでシャドウメモリをチェック
   └─ malloc/freeでレッドゾーンを設定/チェック

4. エラー検出時
   └─ スタックトレース収集
   └─ エラーレポート出力
   └─ プログラム終了（または継続）
```

### フローチャート

```mermaid
flowchart TD
    A[コンパイル開始] --> B{サニタイザ有効?}
    B -->|Yes| C[インストルメンテーション挿入]
    B -->|No| D[通常コンパイル]
    C --> E[ランタイムライブラリリンク]
    D --> F[実行ファイル生成]
    E --> F
    F --> G[プログラム実行]
    G --> H{エラー検出?}
    H -->|Yes| I[エラーレポート出力]
    H -->|No| J[正常終了]
    I --> K{継続モード?}
    K -->|Yes| G
    K -->|No| L[異常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | サニタイザ排他 | ASanとMSanは同時使用不可 | コンパイル時 |
| BR-02 | デバッグ情報推奨 | -gオプションでより詳細なレポート | サニタイザ使用時 |
| BR-03 | 64ビット推奨 | 一部サニタイザは32ビットで制限あり | 常時 |
| BR-04 | プラットフォーム制限 | 全サニタイザが全プラットフォームで利用可能ではない | 常時 |

### 計算ロジック

**シャドウメモリマッピング（ASan）**：
- アプリケーションメモリの各8バイトに対して1バイトのシャドウメモリ
- シャドウアドレス = (アプリアドレス >> 3) + オフセット

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ASAN | heap-buffer-overflow | ヒープバッファオーバーフロー | コードを修正 |
| ASAN | stack-buffer-overflow | スタックバッファオーバーフロー | コードを修正 |
| ASAN | use-after-free | 解放済みメモリアクセス | コードを修正 |
| TSAN | data race | データ競合検出 | 同期を追加 |
| MSAN | use-of-uninitialized-value | 未初期化変数の使用 | 初期化を追加 |
| UBSAN | undefined-behavior | 未定義動作検出 | コードを修正 |

### リトライ仕様

該当なし（エラー検出ツール）

## トランザクション仕様

該当なし

## パフォーマンス要件

- **ASan**：約2倍のメモリ使用量、約2倍の実行時間オーバーヘッド
- **TSan**：約5-15倍の実行時間オーバーヘッド
- **MSan**：約3倍の実行時間オーバーヘッド
- **UBSan**：最小限のオーバーヘッド

## セキュリティ考慮事項

- サニタイザは本番環境での使用は非推奨（オーバーヘッドとセキュリティリスク）
- SafeStackはスタックベースの攻撃を軽減（本番使用可）
- CFI（Control Flow Integrity）は制御フロー攻撃を軽減（本番使用可）

## 備考

- Compiler-RTはLLVMとは独立してビルド可能
- 多くのコンポーネントはGCCのlibgccと互換性がある
- 組み込みシステム向けのbuiltinsのみのビルドも可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CMakeLists.txt | `compiler-rt/CMakeLists.txt` | ビルドオプション、有効なコンポーネントの一覧 |
| 1-2 | lib/CMakeLists.txt | `compiler-rt/lib/CMakeLists.txt` | 各ライブラリのビルド構成 |

**読解のコツ**: CMakeLists.txtの`option()`ディレクティブで有効化できるコンポーネントを確認。`COMPILER_RT_BUILD_*`オプションが各コンポーネントに対応。

#### Step 2: builtins（組み込み関数）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | builtins/ | `compiler-rt/lib/builtins/` | 組み込み関数の実装 |
| 2-2 | divdi3.c | `compiler-rt/lib/builtins/divdi3.c` | 64ビット除算の例 |

**読解のコツ**: builtinsは純粋なC言語で実装されており、特定のABI規約に従う。関数名は`__<operation><type>`形式（例：`__divdi3`は64ビット符号付き除算）。

#### Step 3: サニタイザ共通基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sanitizer_common/ | `compiler-rt/lib/sanitizer_common/` | サニタイザ共通コード |
| 3-2 | sanitizer_common.h | `compiler-rt/lib/sanitizer_common/sanitizer_common.h` | 共通インターフェース |
| 3-3 | sanitizer_symbolizer.h | `compiler-rt/lib/sanitizer_common/sanitizer_symbolizer.h` | シンボル解決 |

#### Step 4: AddressSanitizer（ASan）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | asan/ | `compiler-rt/lib/asan/` | ASan実装 |
| 4-2 | asan_rtl.cpp | `compiler-rt/lib/asan/asan_rtl.cpp` | ASanランタイム初期化 |
| 4-3 | asan_allocator.cpp | `compiler-rt/lib/asan/asan_allocator.cpp` | カスタムアロケータ |

#### Step 5: プロファイルランタイムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | profile/ | `compiler-rt/lib/profile/` | プロファイル収集 |
| 5-2 | InstrProfiling.c | `compiler-rt/lib/profile/InstrProfiling.c` | プロファイルデータ収集 |

### プログラム呼び出し階層図

```
[コンパイル時]
Clang Frontend
    │
    └─ LLVM Pass Pipeline
           │
           ├─ AddressSanitizer Pass
           │      └─ メモリアクセスにチェック挿入
           │
           ├─ ThreadSanitizer Pass
           │      └─ メモリアクセスにチェック挿入
           │
           └─ InstrProfiling Pass
                  └─ カウンタ増分コード挿入

[実行時 - ASan例]
main()
    │
    ├─ __asan_init() [asan_rtl.cpp]
    │      ├─ InitializeAllocator()
    │      ├─ InitializeShadowMemory()
    │      └─ InitializeInterceptors()
    │
    ├─ ユーザーコード実行
    │      │
    │      ├─ __asan_load4() [各メモリ読み取り]
    │      │      └─ シャドウメモリチェック
    │      │
    │      └─ __asan_store4() [各メモリ書き込み]
    │             └─ シャドウメモリチェック
    │
    └─ プログラム終了
           └─ __asan_report_*() [エラー時]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ソースコード ─────────▶ Clang+LLVM ─────────────────▶ インストルメント済みバイナリ
                              │
                              └─▶ Compiler-RTライブラリリンク
                                      │
                                      ▼
                              [実行時]
                              ユーザー入力 ───▶ インストルメント済みコード
                                                    │
                                                    ├─▶ シャドウメモリ更新
                                                    │
                                                    ├─▶ エラーレポート（stderr）
                                                    │
                                                    └─▶ プロファイルデータ（.profraw）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CMakeLists.txt | `compiler-rt/CMakeLists.txt` | 設定 | トップレベルビルド設定 |
| lib/CMakeLists.txt | `compiler-rt/lib/CMakeLists.txt` | 設定 | ライブラリビルド設定 |
| builtins/ | `compiler-rt/lib/builtins/` | ソース | 組み込み関数群 |
| asan/ | `compiler-rt/lib/asan/` | ソース | AddressSanitizer |
| tsan/ | `compiler-rt/lib/tsan/` | ソース | ThreadSanitizer |
| msan/ | `compiler-rt/lib/msan/` | ソース | MemorySanitizer |
| ubsan/ | `compiler-rt/lib/ubsan/` | ソース | UndefinedBehaviorSanitizer |
| lsan/ | `compiler-rt/lib/lsan/` | ソース | LeakSanitizer |
| dfsan/ | `compiler-rt/lib/dfsan/` | ソース | DataFlowSanitizer |
| hwasan/ | `compiler-rt/lib/hwasan/` | ソース | HardwareAddressSanitizer |
| nsan/ | `compiler-rt/lib/nsan/` | ソース | NumericalSanitizer |
| rtsan/ | `compiler-rt/lib/rtsan/` | ソース | RealtimeSanitizer |
| tysan/ | `compiler-rt/lib/tysan/` | ソース | TypeSanitizer |
| profile/ | `compiler-rt/lib/profile/` | ソース | プロファイルランタイム |
| ctx_profile/ | `compiler-rt/lib/ctx_profile/` | ソース | コンテキストプロファイル |
| xray/ | `compiler-rt/lib/xray/` | ソース | XRayトレーシング |
| fuzzer/ | `compiler-rt/lib/fuzzer/` | ソース | libFuzzer |
| orc/ | `compiler-rt/lib/orc/` | ソース | ORC JITランタイム |
| safestack/ | `compiler-rt/lib/safestack/` | ソース | SafeStack |
| cfi/ | `compiler-rt/lib/cfi/` | ソース | Control Flow Integrity |
| scudo/ | `compiler-rt/lib/scudo/` | ソース | Scudoアロケータ |
| gwp_asan/ | `compiler-rt/lib/gwp_asan/` | ソース | GWP-ASan |
| memprof/ | `compiler-rt/lib/memprof/` | ソース | メモリプロファイラ |
| sanitizer_common/ | `compiler-rt/lib/sanitizer_common/` | ソース | サニタイザ共通コード |
| interception/ | `compiler-rt/lib/interception/` | ソース | 関数インターセプト |
