# 機能設計書 16-libunwind

## 概要

本ドキュメントは、LLVMプロジェクトにおけるlibunwind（LLVM Unwinder）の機能設計書である。libunwindは、スタックアンワインド（巻き戻し）機能を提供するライブラリであり、C++例外処理やデバッガでのスタックトレース取得に必要な低レベル機能を実装する。

### 本機能の処理概要

libunwindは、HP libunwindプロジェクトで定義されたインターフェースの実装であり、C++例外処理機構のための`_Unwind_*`関数と、汎用スタックアンワインドのための`unw_*`関数を提供する。

**業務上の目的・背景**：C++例外が発生した際、スタックを正しく巻き戻してリソースを解放し、適切なcatchブロックに制御を移す必要がある。libunwindは、このスタックアンワインド処理を担当し、DWARF CFI（Call Frame Information）やARM EHABI等の様々なアンワインド情報形式をサポートする。Appleが貢献したこのライブラリは、システムアンワインダが利用できないプラットフォームでもclang++を動作させることを可能にする。

**機能の利用シーン**：
- C++例外処理（throw/catch）でのスタックアンワインド
- デバッガでのスタックトレース取得
- クラッシュハンドラでのバックトレース生成
- プロファイラでの呼び出し履歴取得

**主要な処理内容**：
1. **_Unwind_* API**：C++例外処理用の高レベルAPI
2. **unw_* API**：汎用アンワインド用の低レベルAPI
3. **DWARF CFI解析**：デバッグ情報からアンワインド情報を取得
4. **レジスタ復元**：各スタックフレームのレジスタ状態を復元
5. **パーソナリティルーチン呼び出し**：言語固有の例外ハンドリング

**関連システム・外部連携**：
- libc++abi：C++例外処理
- Clang/GCC：コンパイラ
- DWARF：デバッグ情報形式

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ランタイムライブラリのため画面なし |

## 機能種別

アンワインドライブラリ / 例外処理サポート / ランタイムライブラリ

## 入力仕様

### 入力パラメータ

libunwindは自動的にリンクされ、通常は明示的なオプション指定は不要。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -lunwind | flag | No | 明示的なlibunwindリンク | - |
| LIBUNWIND_ENABLE_SHARED | cmake | No | 共有ライブラリビルド | ON/OFF |
| LIBUNWIND_ENABLE_STATIC | cmake | No | 静的ライブラリビルド | ON/OFF |

### 入力データソース

- DWARF .eh_frameセクション
- ARM EHABIデータ
- SjLjデータ（一部プラットフォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libunwind.a | 静的ライブラリ | リンク時に結合 |
| libunwind.so / libunwind.dylib | 動的ライブラリ | 実行時にロード |

### 出力先

- インストールディレクトリのlib/

## 処理フロー

### 処理シーケンス（例外アンワインド例）

```
1. 例外発生
   └─ libc++abiの__cxa_throwから_Unwind_RaiseExceptionを呼び出し

2. アンワインドフェーズ1（検索フェーズ）
   └─ スタックをスキャンしてハンドラを検索
   └─ 各フレームでパーソナリティルーチンを呼び出し
   └─ _URC_HANDLER_FOUNDが返されるまで継続

3. アンワインドフェーズ2（クリーンアップフェーズ）
   └─ スタックを実際に巻き戻し
   └─ 各フレームでデストラクタ等のクリーンアップを実行
   └─ ハンドラフレームに到達したらジャンプ

4. 例外ハンドラ実行
   └─ catchブロックに制御を移す
```

### フローチャート

```mermaid
flowchart TD
    A[_Unwind_RaiseException] --> B[Phase 1: 検索]
    B --> C{ハンドラ発見?}
    C -->|No| D[次のフレームへ]
    D --> B
    C -->|Yes| E[Phase 2: クリーンアップ]
    E --> F[フレームのクリーンアップ実行]
    F --> G{ハンドラフレーム?}
    G -->|No| H[レジスタ復元]
    H --> F
    G -->|Yes| I[ハンドラにジャンプ]
    I --> J[例外処理完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | HP libunwind互換 | HP libunwind APIと互換 | 常時 |
| BR-02 | DWARF CFIサポート | .eh_frameセクションを解析 | x86/x86_64/ARM64等 |
| BR-03 | ARM EHABI | ARM例外処理ABIをサポート | ARM |
| BR-04 | SjLjサポート | setjmp/longjmpベースの例外 | 一部プラットフォーム |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| _URC_END_OF_STACK | アンワインド | スタック終端到達 | std::terminate呼び出し |
| _URC_FATAL_PHASE1_ERROR | アンワインド | Phase1エラー | プログラム終了 |
| _URC_FATAL_PHASE2_ERROR | アンワインド | Phase2エラー | プログラム終了 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 例外を投げない通常パスではゼロオーバーヘッド
- アンワインド情報のキャッシュによる高速化

## セキュリティ考慮事項

- スタック情報の安全な取り扱い
- バッファオーバーフロー対策

## 備考

- リモートアンワインド機能は未実装（将来の課題）
- macOS、iOS、FreeBSD、Linux等で使用可能
- Clang 3.5以降、GCC 4.7以降を推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 公開APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | unwind.h | `libunwind/include/unwind.h` | _Unwind_* API定義 |
| 1-2 | libunwind.h | `libunwind/include/libunwind.h` | unw_* API定義 |

**読解のコツ**: `_Unwind_*`は高レベルAPI（C++例外用）、`unw_*`は低レベルAPI（汎用アンワインド）。

#### Step 2: 実装の概要を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | src/ | `libunwind/src/` | 実装ソースファイル |
| 2-2 | UnwindCursor.hpp | `libunwind/src/UnwindCursor.hpp` | アンワインドカーソル |

#### Step 3: アーキテクチャ固有の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UnwindRegistersRestore.S | `libunwind/src/UnwindRegistersRestore.S` | レジスタ復元（アセンブリ） |
| 3-2 | UnwindRegistersSave.S | `libunwind/src/UnwindRegistersSave.S` | レジスタ保存（アセンブリ） |

### プログラム呼び出し階層図

```
[例外発生時]
__cxa_throw() [libc++abi]
    │
    └─ _Unwind_RaiseException() [libunwind]
           │
           ├─ Phase 1: 検索
           │      │
           │      └─ unwind_phase1()
           │             │
           │             └─ __personality_routine() [各フレーム]
           │
           └─ Phase 2: クリーンアップ
                  │
                  └─ unwind_phase2()
                         │
                         ├─ クリーンアップコード実行
                         │
                         └─ _Unwind_Resume() [必要時]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CMakeLists.txt | `libunwind/CMakeLists.txt` | 設定 | ビルド設定 |
| unwind.h | `libunwind/include/unwind.h` | ヘッダー | _Unwind_* API |
| libunwind.h | `libunwind/include/libunwind.h` | ヘッダー | unw_* API |
| src/ | `libunwind/src/` | ソース群 | 実装コード |
| Unwind-EHABI.cpp | `libunwind/src/Unwind-EHABI.cpp` | ソース | ARM EHABI |
| Unwind-sjlj.c | `libunwind/src/Unwind-sjlj.c` | ソース | SjLj |
| UnwindCursor.hpp | `libunwind/src/UnwindCursor.hpp` | ヘッダー | カーソル |
| DwarfParser.hpp | `libunwind/src/DwarfParser.hpp` | ヘッダー | DWARF解析 |
