# 機能設計書 18-Offload

## 概要

本ドキュメントは、LLVMプロジェクトにおけるOffload（ヘテロジニアスコンピューティング用オフロードランタイム）の機能設計書である。Offloadサブプロジェクトは、CPU以外のアクセラレータ（GPU、FPGA等）にコードを「オフロード」して実行するためのランタイムとツーリングを提供する。

### 本機能の処理概要

Offloadは、OpenMPオフロード（target構文）やその他のヘテロジニアスプログラミングモデルのためのランタイムサポートを提供する。CPUからGPU等のアクセラレータへのコード実行、データ転送、同期を管理する。

**業務上の目的・背景**：現代のHPC（High Performance Computing）やAI/ML処理では、GPUなどのアクセラレータを活用した並列計算が不可欠である。Offloadプロジェクトは、OpenMPのtarget指示文やその他のプログラミングモデルを通じて、開発者がアクセラレータを簡単に利用できる環境を提供する。NVIDIA GPU、AMD GPU、Intel GPU等、様々なターゲットをサポートしている。

**機能の利用シーン**：
- GPUによる科学技術計算の高速化
- AI/MLワークロードのGPU実行
- HPC向け大規模並列計算
- OpenMP target構文によるオフロード

**主要な処理内容**：
1. **デバイス管理**：GPUの列挙、初期化、選択
2. **メモリ管理**：ホスト-デバイス間のデータ転送
3. **カーネル実行**：デバイス上でのコード実行
4. **同期**：ホスト-デバイス間の同期
5. **プラグインシステム**：各種GPUバックエンドのサポート

**関連システム・外部連携**：
- OpenMP：target構文のランタイムサポート
- CUDA：NVIDIA GPUバックエンド
- HIP/ROCm：AMD GPUバックエンド
- Level Zero：Intel GPUバックエンド
- Clang：-fopenmpオプションとターゲット指定

**権限による制御**：GPUドライバへのアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ランタイムライブラリのため画面なし |

## 機能種別

オフロードランタイム / ヘテロジニアスコンピューティング / GPUプログラミング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -fopenmp | flag | Yes | OpenMP有効化 | - |
| -fopenmp-targets | flag | No | ターゲットアーキテクチャ指定 | 有効なターゲット |
| OMP_DEFAULT_DEVICE | env | No | デフォルトデバイス | デバイスID |
| OMP_TARGET_OFFLOAD | env | No | オフロード制御 | MANDATORY/DISABLED/DEFAULT |
| LIBOMPTARGET_DEBUG | env | No | デバッグ出力 | 整数 |

### 入力データソース

- OpenMP target指示文を含むソースコード
- 環境変数による実行時設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libomptarget.so | 動的ライブラリ | オフロードランタイム本体 |
| libomptarget.rtl.*.so | 動的ライブラリ | 各GPUバックエンドプラグイン |
| liboffload.so | 動的ライブラリ | 汎用オフロードAPI |

### 出力先

- インストールディレクトリのlib/

## 処理フロー

### 処理シーケンス（OpenMP target例）

```
1. target構文の検出
   └─ Clangがtarget構文をトランスフォーム
   └─ デバイスカーネルを分離してコンパイル

2. 実行時初期化
   └─ libomptargetがプラグインをロード
   └─ 利用可能なデバイスを列挙

3. target領域の実行
   └─ データ転送（map句に従う）
   └─ カーネル起動
   └─ 結果の転送

4. 後処理
   └─ デバイスメモリの解放
   └─ 同期完了
```

### フローチャート

```mermaid
flowchart TD
    A[#pragma omp target] --> B[Clangによるコード分離]
    B --> C[ホストコード + デバイスカーネル]
    C --> D[実行時: libomptarget初期化]
    D --> E[プラグインロード]
    E --> F[デバイス選択]
    F --> G[データ転送 Host to Device]
    G --> H[カーネル実行]
    H --> I[データ転送 Device to Host]
    I --> J[同期・クリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | OpenMP準拠 | OpenMP target仕様に準拠 | OpenMP使用時 |
| BR-02 | プラグインアーキテクチャ | 各GPUバックエンドはプラグインとして実装 | 常時 |
| BR-03 | フォールバック | デバイスなしの場合はホストで実行 | OMP_TARGET_OFFLOAD=DEFAULT |
| BR-04 | 統合メモリ | 可能な場合は統合メモリを使用 | サポートされるハードウェア |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | デバイス未検出 | GPUドライバなし | ドライバをインストール |
| - | メモリ不足 | デバイスメモリ不足 | データサイズを削減 |
| - | カーネル起動失敗 | 不正なカーネル | コードを修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 効率的なデータ転送
- カーネル起動オーバーヘッドの最小化
- 非同期実行のサポート

## セキュリティ考慮事項

- GPUドライバへの安全なアクセス
- デバイスメモリの分離

## 備考

- OpenMPオフロード用のlibomptargetを含む
- 新しいliboffload APIは開発中
- NVIDIA/AMD/Intel GPUをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | README.md | `offload/README.md` | プロジェクト概要 |
| 1-2 | CMakeLists.txt | `offload/CMakeLists.txt` | ビルド構成 |

#### Step 2: libomptargetを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | libomptarget/ | `offload/libomptarget/` | オフロードランタイム |
| 2-2 | include/ | `offload/include/` | 公開API |

#### Step 3: プラグインを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | plugins-nextgen/ | `offload/plugins-nextgen/` | GPUプラグイン |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| README.md | `offload/README.md` | ドキュメント | 概要 |
| CMakeLists.txt | `offload/CMakeLists.txt` | 設定 | ビルド設定 |
| libomptarget/ | `offload/libomptarget/` | ソース群 | オフロードランタイム |
| liboffload/ | `offload/liboffload/` | ソース群 | 汎用オフロードAPI |
| plugins-nextgen/ | `offload/plugins-nextgen/` | ソース群 | GPUプラグイン |
| include/ | `offload/include/` | ヘッダー群 | 公開API |
| tools/ | `offload/tools/` | ツール群 | ユーティリティ |
| test/ | `offload/test/` | テスト | テストスイート |
