# 機能設計書 19-libSYCL

## 概要

本ドキュメントは、LLVMプロジェクトにおけるlibSYCL（SYCL Runtime Library）の機能設計書である。libSYCLは、SYCL 2020規格に準拠したランタイムライブラリ実装であり、C++でヘテロジニアスコンピューティングを行うための基盤を提供する。

### 本機能の処理概要

libSYCLは、SYCL（Specification for Unified Compute Language）規格に基づき、C++アプリケーションからGPUやアクセラレータを利用するためのランタイムサポートを提供する。デバイス管理、メモリ管理、カーネル実行、同期機構などを実装している。

**業務上の目的・背景**：GPUやFPGAなどのアクセラレータを活用したヘテロジニアスコンピューティングの需要が増大している。SYCLは、標準C++を使用してこれらのデバイスをプログラミングできる抽象化レイヤーを提供する。OpenCLとは異なり、SYCLは純粋なC++コードとして記述でき、コンパイラが自動的にホストコードとデバイスコードを分離する。libSYCLは、LLVMエコシステム内でのSYCL規格のリファレンス実装を目指している。

**機能の利用シーン**：
- GPUを使用した並列計算
- AI/MLワークロードのアクセラレータ実行
- 科学技術計算の高速化
- データ並列処理
- マルチデバイス環境での計算

**主要な処理内容**：
1. **プラットフォーム管理**：利用可能なバックエンドの列挙と選択
2. **デバイス管理**：GPUやアクセラレータの検出と選択
3. **コンテキスト管理**：デバイス上での実行環境の管理
4. **キュー管理**：コマンドのキューイングと実行
5. **メモリ管理**：USM（Unified Shared Memory）、バッファ管理
6. **カーネル実行**：デバイスコードの起動と同期

**関連システム・外部連携**：
- Clang：SYCLフロントエンドサポート
- Offload/libomptarget：デバイスランタイムバックエンド
- Level Zero：Intel GPUバックエンド
- OpenCL：OpenCLバックエンド（計画中）

**権限による制御**：GPUドライバへのアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ランタイムライブラリのため画面なし |

## 機能種別

ヘテロジニアスコンピューティングランタイム / SYCL実装 / GPUプログラミング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -fsycl | flag | Yes | SYCL有効化 | - |
| -fsycl-targets | flag | No | ターゲットデバイス指定 | 有効なターゲット |
| SYCL_DEVICE_FILTER | env | No | デバイスフィルタ | デバイス指定文字列 |

### 入力データソース

- SYCLコードを含むC++ソースファイル
- 環境変数による実行時設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libsycl.so | 動的ライブラリ | SYCLランタイム本体 |
| sycl/sycl.hpp | ヘッダー | メインヘッダー |
| sycl/__impl/*.hpp | ヘッダー群 | 内部実装ヘッダー |

### 出力先

- インストールディレクトリのlib/
- インストールディレクトリのinclude/sycl/

## 処理フロー

### 処理シーケンス（SYCL並列処理例）

```
1. SYCLアプリケーション初期化
   └─ プラットフォームの検出
   └─ デバイスの列挙

2. キューの作成
   └─ デバイスの選択
   └─ コンテキストの作成

3. メモリ割り当て
   └─ USMメモリの確保（malloc_shared）
   └─ データの初期化

4. カーネル実行
   └─ queue.submit()でコマンド送信
   └─ parallel_for()でカーネル起動
   └─ queue.wait()で完了待ち

5. 結果取得とクリーンアップ
   └─ 結果データの取得
   └─ メモリの解放
```

### フローチャート

```mermaid
flowchart TD
    A[SYCLアプリケーション開始] --> B[sycl::platform::get_platforms]
    B --> C[sycl::queue作成]
    C --> D[sycl::malloc_shared]
    D --> E[queue.submit]
    E --> F[handler.parallel_for]
    F --> G[queue.wait]
    G --> H[結果確認]
    H --> I[sycl::free]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | SYCL 2020準拠 | SYCL 2020規格に準拠 | 常時 |
| BR-02 | C++17必須 | C++17以上が必要 | 常時 |
| BR-03 | USMサポート | Unified Shared Memoryをサポート | デバイスがサポートする場合 |
| BR-04 | 非同期実行 | キューベースの非同期実行 | 常時 |

### 計算ロジック

**カーネル実行モデル**：
- NDRange：多次元インデックス空間でのカーネル実行
- 単一タスク：単一ワークアイテムでの実行
- 階層的並列：ワークグループ/サブグループ階層

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| errc::runtime | ランタイムエラー | 実行時エラー | エラー内容を確認 |
| errc::kernel | カーネルエラー | カーネル実行失敗 | カーネルコードを修正 |
| errc::memory_allocation | メモリエラー | メモリ確保失敗 | メモリサイズを削減 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 効率的なデバイスメモリ管理
- 非同期実行による高スループット
- USMによるシームレスなメモリアクセス

## セキュリティ考慮事項

- デバイスメモリの分離
- GPUドライバへの安全なアクセス

## 備考

- 開発初期段階でアップストリーム中
- Level Zeroバックエンドが必要
- Windowsは現在未サポート（liboffload依存）
- バージョン0.1.0

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | README.md | `libsycl/README.md` | プロジェクト概要、SYCL 2020規格への準拠（1-21行目） |
| 1-2 | CMakeLists.txt | `libsycl/CMakeLists.txt` | ビルド構成、C++17要件（11-13行目）、バージョン情報（68-71行目） |
| 1-3 | index.rst | `libsycl/docs/index.rst` | 現在のステータス、ビルド手順（1-94行目） |

#### Step 2: 公開APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sycl.hpp | `libsycl/include/sycl/sycl.hpp` | メインヘッダー、インクルード構造（14-20行目） |
| 2-2 | __impl/platform.hpp | `libsycl/include/sycl/__impl/platform.hpp` | プラットフォームクラス定義 |
| 2-3 | __impl/exception.hpp | `libsycl/include/sycl/__impl/exception.hpp` | 例外クラス定義 |

#### Step 3: ランタイム実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | platform.cpp | `libsycl/src/platform.cpp` | プラットフォーム実装、get_platforms()（19-28行目） |
| 3-2 | exception.cpp | `libsycl/src/exception.cpp` | 例外処理実装、エラーカテゴリ（15-19行目） |
| 3-3 | exception_list.cpp | `libsycl/src/exception_list.cpp` | 例外リスト実装 |

### プログラム呼び出し階層図

```
ユーザーコード（sycl::queue.submit）
    │
    └─ libsycl ランタイム
           │
           ├─ sycl::platform [platform.cpp]
           │      └─ platform::get_platforms()
           │             └─ detail::PlatformImpl::getPlatforms()
           │
           ├─ sycl::device
           │      └─ デバイス列挙・選択
           │
           ├─ sycl::queue
           │      └─ コマンドキュー管理
           │
           └─ liboffload（バックエンド）
                  └─ Level Zero / OpenCL
```

### データフロー図

```
┌─────────────────────────────────────────────────────────┐
│                    SYCLアプリケーション                    │
│  sycl::queue q;                                         │
│  int *ptr = sycl::malloc_shared<int>(n, q);            │
│  q.submit([&](sycl::handler &h) {                      │
│      h.parallel_for<Kernel>(...);                       │
│  });                                                    │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                    libsycl ランタイム                     │
│  ┌─────────────┐  ┌─────────────┐  ┌─────────────┐    │
│  │  platform   │  │   device    │  │   queue     │    │
│  └─────────────┘  └─────────────┘  └─────────────┘    │
│  ┌─────────────┐  ┌─────────────┐  ┌─────────────┐    │
│  │  context    │  │   handler   │  │   memory    │    │
│  └─────────────┘  └─────────────┘  └─────────────┘    │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                    liboffload                            │
│              （デバイスランタイムバックエンド）              │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│               Level Zero / OpenCL / CUDA                 │
│                    （デバイスドライバ）                    │
└─────────────────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| README.md | `libsycl/README.md` | ドキュメント | 概要 |
| CMakeLists.txt | `libsycl/CMakeLists.txt` | 設定 | ビルド設定 |
| index.rst | `libsycl/docs/index.rst` | ドキュメント | ステータス |
| sycl.hpp | `libsycl/include/sycl/sycl.hpp` | ヘッダー | メインヘッダー |
| __impl/ | `libsycl/include/sycl/__impl/` | ヘッダー群 | 内部実装ヘッダー |
| platform.cpp | `libsycl/src/platform.cpp` | ソース | プラットフォーム実装 |
| exception.cpp | `libsycl/src/exception.cpp` | ソース | 例外実装 |
| exception_list.cpp | `libsycl/src/exception_list.cpp` | ソース | 例外リスト |
| detail/ | `libsycl/src/detail/` | ソース群 | 内部実装 |
| tools/ | `libsycl/tools/` | ツール群 | ユーティリティ |
