# 機能設計書 2-llc

## 概要

本ドキュメントは、llc（LLVM静的コンパイラ）の機能設計を記述する。llcは、LLVM中間表現（IR）またはMachine IR（MIR）からターゲットアーキテクチャのアセンブリファイルまたはオブジェクトファイルを生成する静的コンパイラツールである。

### 本機能の処理概要

llcは、LLVMコンパイラパイプラインのバックエンド処理を担当し、最適化されたLLVM IRを特定のCPUアーキテクチャ向けのマシンコードに変換する。

**業務上の目的・背景**：コンパイル過程において、言語非依存の最適化が完了したLLVM IRを、実行可能なマシンコードに変換する必要がある。llcはこの変換を担い、様々なターゲットアーキテクチャ（x86, ARM, RISC-V等）向けのコード生成を統一的なインターフェースで提供する。これにより、コンパイラ開発者はターゲット固有の詳細を意識せずにフロントエンドを開発できる。

**機能の利用シーン**：
- LLVMビットコードからネイティブコードへの変換
- コンパイラのバックエンド処理のデバッグ・テスト
- 特定の最適化パスの効果検証
- MIRレベルでのコード生成パイプラインのテスト
- アセンブリ出力による低レベル最適化の確認

**主要な処理内容**：
1. LLVM IRまたはMIRの読み込みと解析
2. ターゲットマシンの初期化と設定
3. コード生成パスパイプラインの構築と実行
4. 命令選択、レジスタ割り当て、命令スケジューリング
5. アセンブリまたはオブジェクトファイルの出力

**関連システム・外部連携**：
- LLVM Coreライブラリとの連携
- ターゲット固有バックエンド（X86, ARM, AArch64等）との連携
- アセンブラ（統合アセンブラまたは外部アセンブラ）との連携
- プロファイルガイド最適化（PGO）データとの連携

**権限による制御**：特になし（コマンドラインツールとして実行）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | llcはCLIツールであり、GUI画面は持たない |

## 機能種別

コード生成 / コンパイラツール / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InputFilename | string | No | 入力ビットコードファイル（デフォルト: stdin） | .bc/.ll/.mirファイル |
| -o | string | No | 出力ファイル名 | 有効なパス |
| -O | char | No | 最適化レベル（0-3、デフォルト: 2） | 0, 1, 2, 3 |
| -mtriple | string | No | ターゲットトリプル | 有効なトリプル形式 |
| -mcpu | string | No | ターゲットCPU | 有効なCPU名 |
| -mattr | string | No | ターゲット属性 | 有効な属性リスト |
| -filetype | string | No | 出力ファイルタイプ | asm, obj, null |
| -passes | string | No | 実行するパスパイプライン | 有効なパス名 |
| -run-pass | string | No | 特定のMIRパスのみ実行 | 有効なパス名 |

### 入力データソース

- LLVMビットコードファイル（.bc）
- LLVMアセンブリファイル（.ll）
- Machine IRファイル（.mir）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アセンブリファイル | .s | ターゲットアセンブリ言語 |
| オブジェクトファイル | .o / .obj | ネイティブオブジェクト形式 |
| MIRファイル | .mir | Machine IR出力（デバッグ用） |
| 最適化レマーク | YAML | 最適化に関する情報 |

### 出力先

- ファイル（-oオプションで指定）
- 標準出力（-o - または出力ファイル未指定時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン解析
   └─ オプションとファイル名の解析
2. ターゲット初期化
   └─ 全ターゲットの初期化、ターゲットマシン生成
3. 入力ファイル読み込み
   └─ IR/MIRの解析とモジュール生成
4. ターゲットマシン設定
   └─ CPU、属性、最適化レベルの設定
5. パスパイプライン構築
   └─ コード生成パスの追加
6. パス実行
   └─ 命令選択、レジスタ割り当て、スケジューリング
7. 出力生成
   └─ アセンブリまたはオブジェクトファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[ターゲット初期化]
    C --> D{入力形式判定}
    D -->|IR| E[parseIRFile]
    D -->|MIR| F[createMIRParser]
    E --> G[モジュール検証]
    F --> G
    G --> H[TargetMachine生成]
    H --> I{パスモード判定}
    I -->|標準| J[addPassesToEmitFile]
    I -->|run-pass| K[個別パス実行]
    J --> L{出力形式}
    K --> L
    L -->|asm| M[アセンブリ出力]
    L -->|obj| N[オブジェクト出力]
    M --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ターゲット指定 | ターゲットトリプル未指定時はホストアーキテクチャを使用 | mtriple未指定 |
| BR-002 | 最適化レベル | -O2がデフォルト最適化レベル | Oオプション未指定 |
| BR-003 | 出力形式 | 出力拡張子から自動的に形式を決定 | filetypeオプション未指定 |
| BR-004 | MIRパス制限 | run-passオプションは.mirファイルにのみ適用可能 | run-pass指定時 |

### 計算ロジック

- ターゲットトリプル正規化：Triple::normalize()による正規化処理
- コードモデル決定：モジュールまたはコマンドラインからの決定
- リロケーションモデル決定：ターゲットとオプションに基づく決定

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | llcはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ターゲットエラー | 無効なターゲットトリプル | 有効なトリプルを指定 |
| 1 | 最適化レベルエラー | 無効な最適化レベル | 0-3の値を指定 |
| 1 | ファイルエラー | 入力ファイルが存在しない | ファイルパスを確認 |
| 1 | 解析エラー | 不正なIR/MIR形式 | 入力ファイルを修正 |
| 1 | run-passエラー | run-passが.mir以外に適用 | .mirファイルを使用 |

### リトライ仕様

リトライは行わない。エラー発生時は即座に終了コード1で終了。

## トランザクション仕様

llcはデータベーストランザクションを使用しない。ファイル出力は直接書き込みで行われる。

## パフォーマンス要件

- 大規模モジュールの効率的な処理
- time-compilationsオプションによるベンチマーク対応
- 時間プロファイラによる処理時間計測

## セキュリティ考慮事項

- 入力IRの検証による不正コードの検出
- ファイルシステムアクセスの権限確認

## 備考

llcは新しいパスマネージャ（-enable-new-pm）と従来のパスマネージャの両方をサポートしている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

llcのメイン処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llc.cpp | `llvm/tools/llc/llc.cpp` | メイン関数とコマンドライン処理 |

**主要処理フロー**:
1. **370-465行目**: main関数 - ターゲット初期化、オプション解析
2. **377-380行目**: InitializeAllTargets - 全ターゲットの初期化
3. **435行目**: LLVMContext生成
4. **457-459行目**: compileModule呼び出し

**読解のコツ**: main関数は初期化とセットアップに専念し、実際のコンパイル処理はcompileModule関数に委譲されている。

#### Step 2: コンパイル処理を理解する

compileModule関数の詳細を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llc.cpp | `llvm/tools/llc/llc.cpp` | compileModule関数 |

**主要処理フロー**:
1. **496-637行目**: compileModule関数
2. **596-602行目**: SetDataLayout - ターゲットからDataLayoutを取得
3. **624-633行目**: IR/MIRの読み込み分岐
4. **679行目**: GetOutputStream - 出力ファイル準備
5. **740-745行目**: 新パスマネージャへの分岐
6. **748-868行目**: レガシーパスマネージャでのコード生成

#### Step 3: 新パスマネージャドライバを理解する

新パスマネージャ使用時の処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NewPMDriver.cpp | `llvm/tools/llc/NewPMDriver.cpp` | 新パスマネージャ用ドライバ |

**主要処理フロー**:
- compileModuleWithNewPM関数の実装
- PassBuilderを使用したパイプライン構築

#### Step 4: ターゲットマシン設定を理解する

ターゲット固有の設定処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llc.cpp | `llvm/tools/llc/llc.cpp` | InitializeOptions関数 |

**主要処理フロー**:
- **537-586行目**: InitializeOptions - ターゲットオプション初期化
- **615-622行目**: createTargetMachine - ターゲットマシン生成

### プログラム呼び出し階層図

```
main (llc.cpp:370)
    │
    ├─ InitializeAllTargets()
    ├─ InitializeAllTargetMCs()
    ├─ InitializeAllAsmPrinters()
    ├─ InitializeAllAsmParsers()
    │
    ├─ cl::ParseCommandLineOptions()
    │
    └─ compileModule (llc.cpp:496)
           │
           ├─ parseIRFile / createMIRParser
           │      └─ Module生成
           │
           ├─ TargetRegistry::lookupTarget
           │      └─ ターゲット検索
           │
           ├─ createTargetMachine
           │      └─ TargetMachine生成
           │
           ├─ [NewPM] compileModuleWithNewPM
           │      └─ 新パスマネージャでコード生成
           │
           └─ [LegacyPM] addPassesToEmitFile
                  └─ レガシーパスマネージャでコード生成
```

### データフロー図

```
[入力]                    [処理]                           [出力]

LLVM IR (.bc/.ll) ──▶ parseIRFile ──▶ Module
       │                                 │
       │                                 ▼
MIR (.mir) ──────▶ createMIRParser ─▶ Module + MachineFunction
                                         │
                                         ▼
                                  TargetMachine設定
                                         │
                                         ▼
                                  ┌──────────────────┐
                                  │ コード生成パス     │
                                  │ - 命令選択        │
                                  │ - レジスタ割り当て │
                                  │ - スケジューリング │
                                  └──────────────────┘
                                         │
                                         ▼
                              アセンブリ (.s) / オブジェクト (.o)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llc.cpp | `llvm/tools/llc/llc.cpp` | ソース | メインドライバ |
| NewPMDriver.cpp | `llvm/tools/llc/NewPMDriver.cpp` | ソース | 新パスマネージャドライバ |
| NewPMDriver.h | `llvm/tools/llc/NewPMDriver.h` | ヘッダ | 新パスマネージャドライバ定義 |
| CommandFlags.h | `llvm/include/llvm/CodeGen/CommandFlags.h` | ヘッダ | 共通コマンドラインフラグ |
| TargetMachine.h | `llvm/include/llvm/Target/TargetMachine.h` | ヘッダ | ターゲットマシン抽象化 |
| TargetPassConfig.h | `llvm/include/llvm/CodeGen/TargetPassConfig.h` | ヘッダ | パス設定 |
| MIRParser.h | `llvm/include/llvm/CodeGen/MIRParser/MIRParser.h` | ヘッダ | MIR解析 |
| IRReader.h | `llvm/include/llvm/IRReader/IRReader.h` | ヘッダ | IR読み込み |
