# 機能設計書 20-libclc

## 概要

本ドキュメントは、LLVMプロジェクトにおけるlibclc（OpenCL C Builtin Library）の機能設計書である。libclcは、OpenCL C言語仕様で定義されたビルトイン関数のオープンソース実装を提供するライブラリである。

### 本機能の処理概要

libclcは、OpenCL 1.1以降の仕様で要求されるライブラリ関数（数学関数、整数関数、変換関数、アトミック関数など）の実装を提供する。ClangのOpenCLフロントエンドと連携して、GPUやその他のOpenCLデバイス向けのコンパイルをサポートする。

**業務上の目的・背景**：OpenCLは、CPU、GPU、FPGA等の異種デバイスで並列計算を行うための標準規格である。OpenCL Cは、このプログラミングモデルで使用されるC言語の拡張であり、多数のビルトイン関数を定義している。libclcは、これらのビルトイン関数をポータブルかつ拡張可能な形で実装し、LLVMベースのOpenCLコンパイラ（Clang）で使用できるようにする。

**機能の利用シーン**：
- OpenCL Cコードのコンパイル
- GPU上での数学計算
- NVIDIA（PTX）、AMD（AMDGPU）、SPIR-V等のターゲット向けコンパイル
- Mesa 3Dグラフィックスドライバでの利用

**主要な処理内容**：
1. **数学関数**：sin, cos, exp, log, pow等の数学演算
2. **整数関数**：abs, clz, popcount等の整数演算
3. **変換関数**：型変換、リインタプリット
4. **幾何関数**：dot, cross, distance, normalize等
5. **アトミック関数**：アトミック操作
6. **同期関数**：バリア、メモリフェンス

**関連システム・外部連携**：
- Clang：OpenCLフロントエンド
- LLVM：ターゲットバックエンド（AMDGPU、NVPTX）
- llvm-spirv：SPIR-V変換ツール
- Mesa 3D：グラフィックスドライバ

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ライブラリのため画面なし |

## 機能種別

OpenCLビルトインライブラリ / GPUコンピューティング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LIBCLC_TARGETS_TO_BUILD | CMake | No | ビルドするターゲット | all または有効なターゲット |
| ENABLE_RUNTIME_SUBNORMAL | CMake | No | 実行時サブノーマル | ON/OFF |
| LIBCLC_USE_SPIRV_BACKEND | CMake | No | SPIR-Vバックエンド使用 | ON/OFF |

### サポートターゲット

| ターゲット | 説明 |
|-----------|------|
| amdgcn-- | AMD GCN GPU |
| amdgcn-amd-amdhsa | AMD HSA |
| amdgcn-mesa-mesa3d | Mesa 3D用AMD |
| nvptx64-- | NVIDIA PTX |
| nvptx64--nvidiacl | NVIDIA CL |
| nvptx64-nvidia-cuda | NVIDIA CUDA |
| r600-- | AMD R600 |
| clspv-- | Vulkan用CLSPV（32bit） |
| clspv64-- | Vulkan用CLSPV（64bit） |
| spirv-mesa3d- | SPIR-V Mesa 3D（32bit） |
| spirv64-mesa3d- | SPIR-V Mesa 3D（64bit） |

### 入力データソース

- OpenCL Cソースコード
- CLCビルトイン実装ファイル（.cl）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| *.bc | ビットコード | LLVMビットコードライブラリ |
| libclc.pc | pkg-config | パッケージ設定 |

### 出力先

- share/clc/ または lib/clang/\<version\>/lib/

## 処理フロー

### 処理シーケンス（ビルトイン関数呼び出し）

```
1. OpenCL Cソースのコンパイル
   └─ Clangがソースを解析
   └─ ビルトイン関数呼び出しを検出

2. libclcリンク
   └─ ターゲット固有のlibclc.bcをリンク
   └─ ビルトイン関数の実装を取り込み

3. 最適化
   └─ インライン化
   └─ ターゲット固有の最適化

4. コード生成
   └─ ターゲット（PTX/AMDGPU/SPIR-V）向けコード出力
```

### フローチャート

```mermaid
flowchart TD
    A[OpenCL Cソース] --> B[Clangフロントエンド]
    B --> C[LLVM IR生成]
    C --> D[libclc.bcリンク]
    D --> E[最適化パス]
    E --> F{ターゲット}
    F -->|PTX| G[NVPTXバックエンド]
    F -->|AMDGPU| H[AMDGPUバックエンド]
    F -->|SPIR-V| I[SPIR-Vバックエンド/llvm-spirv]
    G --> J[PTXコード]
    H --> K[AMDGPUバイナリ]
    I --> L[SPIR-Vバイナリ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | OpenCL準拠 | OpenCL 1.1以降の仕様に準拠 | 常時 |
| BR-02 | ポータブル設計 | ジェネリック実装をベースに、ターゲット固有実装でオーバーライド可能 | 常時 |
| BR-03 | OpenCL 3.0 | CL 3.0スタンダードでビルド | 常時 |
| BR-04 | CLC内部ライブラリ | 内部CLCビルトインと外部OpenCLビルトインを分離 | 常時 |

### OpenCL仕様カバレッジ

- 6.1: サポートデータ型
- 6.2.3: 明示的変換
- 6.2.4.2: as_type()によるリインタプリット
- 6.9: プリプロセッサ指示子とマクロ
- 6.11: ビルトイン関数
- 9.3: 倍精度浮動小数点
- 9.4: 64ビットアトミック
- 9.5: 3Dイメージメモリへの書き込み
- 9.6: 半精度浮動小数点

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | Clangが見つからない | Clangをビルド |
| - | ターゲットエラー | 無効なターゲット指定 | 有効なターゲットを指定 |
| - | llvm-spirvエラー | SPIR-Vツールなし | llvm-spirvをインストール |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ビルトイン関数のインライン化
- ターゲット固有の最適化実装
- ネイティブ関数（native_*）による高速近似計算

## セキュリティ考慮事項

- GPUメモリの分離
- 安全な型変換

## 備考

- PTX、AMDGPU、SPIR-V、CLSPVターゲットをサポート
- LLVM 3.9以上が必要
- Clangと共にビルドする必要あり
- https://libclc.llvm.org/ で公開

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | README.md | `libclc/README.md` | プロジェクト概要、OpenCL仕様カバレッジ（1-68行目） |
| 1-2 | CMakeLists.txt | `libclc/CMakeLists.txt` | ビルド構成、ターゲット定義（154-164行目）、デバイスエイリアス（220-234行目） |

#### Step 2: ビルトイン実装構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clc/lib/generic/SOURCES | `libclc/clc/lib/generic/SOURCES` | CLCビルトイン一覧 |
| 2-2 | opencl/lib/generic/SOURCES | `libclc/opencl/lib/generic/SOURCES` | OpenCLビルトイン一覧 |

#### Step 3: 関数実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clc/lib/generic/math/ | `libclc/clc/lib/generic/math/` | 数学関数実装 |
| 3-2 | clc/lib/generic/integer/ | `libclc/clc/lib/generic/integer/` | 整数関数実装 |
| 3-3 | clc/lib/generic/atomic/ | `libclc/clc/lib/generic/atomic/` | アトミック関数実装 |

#### Step 4: ターゲット固有実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | clc/lib/amdgcn/ | `libclc/clc/lib/amdgcn/` | AMD GCN固有実装 |
| 4-2 | clc/lib/ptx-nvidiacl/ | `libclc/clc/lib/ptx-nvidiacl/` | NVIDIA PTX固有実装 |
| 4-3 | clc/lib/spirv/ | `libclc/clc/lib/spirv/` | SPIR-V固有実装 |

### プログラム呼び出し階層図

```
OpenCL Cソースコード
    │
    └─ Clang OpenCLフロントエンド
           │
           └─ ビルトイン関数呼び出し
                  │
                  ├─ libclc ライブラリリンク
                  │      │
                  │      ├─ clc/lib/generic/ [汎用実装]
                  │      │      ├─ math/     [数学関数]
                  │      │      ├─ integer/  [整数関数]
                  │      │      ├─ atomic/   [アトミック]
                  │      │      └─ ...
                  │      │
                  │      └─ clc/lib/{target}/ [ターゲット固有]
                  │             ├─ amdgcn/
                  │             ├─ ptx-nvidiacl/
                  │             └─ spirv/
                  │
                  └─ opencl/lib/ [OpenCL固有ビルトイン]
                         ├─ generic/
                         └─ {target}/
```

### データフロー図

```
┌─────────────────────────────────────────────────────────┐
│                  OpenCL Cソースファイル                    │
│   kernel void foo(...) { float x = sin(y); }            │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                    Clang コンパイラ                       │
│        -target amdgcn-- -cl-std=CL3.0                   │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                    LLVM IR 中間表現                       │
│         call float @_Z3sinf(float %y)                   │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                    libclc リンク                          │
│  ┌─────────────────────────────────────────────────┐   │
│  │              libclc-amdgcn.bc                    │   │
│  │  ┌─────────┐  ┌─────────┐  ┌─────────┐        │   │
│  │  │  math   │  │ integer │  │ atomic  │        │   │
│  │  │  sin    │  │  abs    │  │  add    │        │   │
│  │  │  cos    │  │  clz    │  │  xchg   │        │   │
│  │  └─────────┘  └─────────┘  └─────────┘        │   │
│  └─────────────────────────────────────────────────┘   │
└───────────────────────────┬─────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────┐
│                ターゲットコード生成                        │
│           AMDGPU / NVPTX / SPIR-V バックエンド            │
└─────────────────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| README.md | `libclc/README.md` | ドキュメント | 概要・ビルド方法 |
| CMakeLists.txt | `libclc/CMakeLists.txt` | 設定 | ビルド設定・ターゲット定義 |
| clc/lib/generic/ | `libclc/clc/lib/generic/` | ソース群 | CLC汎用ビルトイン |
| clc/lib/amdgcn/ | `libclc/clc/lib/amdgcn/` | ソース群 | AMD GCN固有 |
| clc/lib/amdgpu/ | `libclc/clc/lib/amdgpu/` | ソース群 | AMDGPU共通 |
| clc/lib/ptx-nvidiacl/ | `libclc/clc/lib/ptx-nvidiacl/` | ソース群 | NVIDIA PTX固有 |
| clc/lib/spirv/ | `libclc/clc/lib/spirv/` | ソース群 | SPIR-V固有 |
| clc/lib/r600/ | `libclc/clc/lib/r600/` | ソース群 | AMD R600固有 |
| clc/lib/clspv/ | `libclc/clc/lib/clspv/` | ソース群 | CLSPV固有 |
| opencl/lib/generic/ | `libclc/opencl/lib/generic/` | ソース群 | OpenCL汎用ビルトイン |
| clc/include/ | `libclc/clc/include/` | ヘッダー群 | CLCヘッダー |
| opencl/include/ | `libclc/opencl/include/` | ヘッダー群 | OpenCLヘッダー |
| test/ | `libclc/test/` | テスト | テストスイート |
| cmake/modules/ | `libclc/cmake/modules/` | CMake | ビルドモジュール |
