# 機能設計書 21-llvm-libgcc

## 概要

本ドキュメントは、LLVM llvm-libgccの機能設計について記述する。llvm-libgccは、GCCランタイムライブラリ（libgcc）との互換性を提供するレイヤーであり、compiler-rtとlibunwindをlibgccファミリーとして公開することで、glibcなどのGCC依存コンポーネントとの互換性を実現する。

### 本機能の処理概要

llvm-libgccは、LLVMのcompiler-rtとlibunwindを、GCCのlibgccファミリー（libgcc.a、libgcc_eh.a、libgcc_s.so）として公開するためのビルドインフラストラクチャを提供する機能である。

**業務上の目的・背景**：Linux標準ベース（LSB）ではlibgcc_s.soが必須の依存関係として定義されており、glibcは`__GI___backtrace`などの関数で直接libgcc_sをdlopenする。libunwindとlibgccは同じABIを持つが実装が異なるため、両者が混在するとクロストークによりセグメンテーション違反が発生する。この問題を解決するため、llvm-libgccはcompiler-rtとlibunwindを「libgcc」として公開し、glibcの呼び出しを適切なオブジェクトに転送する。

**機能の利用シーン**：Linuxディストリビューションの管理者が、システム全体でlibgccをcompiler-rt/libunwindに置き換えたいが、glibcへの依存のため完全に切り離せない場合に使用される。特にclangベースのツールチェーンを採用するディストロビルド環境で有用である。

**主要な処理内容**：
1. compiler-rtのビルトイン関数をビルド（シンボル公開モード）
2. libunwindの静的・共有ライブラリをビルド
3. バージョンスクリプト（gcc_s.ver）の生成とリンク
4. libunwind.soにcompiler-rtオブジェクトをリンク
5. libgcc.a、libgcc_eh.a、libgcc_s.soへのシンボリックリンク作成

**関連システム・外部連携**：compiler-rt（ビルトイン関数提供）、libunwind（スタックアンワインド提供）、glibc（互換性対象）

**権限による制御**：特になし。ビルド時の設定オプションによる制御のみ。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はランタイムライブラリであり、直接的な画面は存在しない |

## 機能種別

ビルドインフラストラクチャ / ライブラリ互換性レイヤー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| LLVM_LIBGCC_EXPLICIT_OPT_IN | boolean | Yes | 明示的なオプトインフラグ | Yes以外はビルド拒否 |
| LLVM_LIBGCC_LIBUNWIND_PATH | path | No | libunwindソースパス | 存在確認 |
| LLVM_LIBGCC_COMPILER_RT_PATH | path | No | compiler-rtソースパス | 存在確認 |
| LLVM_ENABLE_PER_TARGET_RUNTIME_DIR | boolean | No | ターゲット別ディレクトリ使用 | - |

### 入力データソース

- compiler-rtソースコード（../compiler-rt）
- libunwindソースコード（../libunwind）
- gcc_s.ver.inバージョンスクリプトテンプレート

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libgcc.a | symlink | compiler-rtビルトインへのシンボリックリンク |
| libgcc_eh.a | symlink | libunwind.aへのシンボリックリンク |
| libgcc_s.so | symlink | libgcc_s.so.1へのシンボリックリンク |
| libgcc_s.so.1 | symlink | libgcc_s.so.1.0へのシンボリックリンク |
| libgcc_s.so.1.0 | symlink | libunwind.soへのシンボリックリンク |
| libunwind.so | shared library | compiler-rtオブジェクト付きの共有ライブラリ |
| libunwind.a | static library | 静的ライブラリ |

### 出力先

ビルドディレクトリのlib/配下、またはLLVM_ENABLE_PER_TARGET_RUNTIME_DIR有効時はターゲット別サブディレクトリ

## 処理フロー

### 処理シーケンス

```
1. CMake設定の検証
   └─ LLVM_LIBGCC_EXPLICIT_OPT_INが設定されているか確認
   └─ compiler-rt/libunwindとの重複ビルドがないか確認

2. compiler-rtのビルド
   └─ COMPILER_RT_BUILD_BUILTINS=ON
   └─ COMPILER_RT_BUILTINS_HIDE_SYMBOLS=OFF（シンボル公開）

3. libunwindのビルド
   └─ 静的・共有両方をビルド
   └─ GCCライブラリへのリンクを無効化

4. バージョンスクリプトの生成
   └─ gcc_s.ver.inをCプリプロセッサで処理
   └─ アーキテクチャ固有のシンボルを選択

5. libunwind共有ライブラリのリンク
   └─ バージョンスクリプトを適用
   └─ compiler-rtオブジェクトをリンク
   └─ libmをリンク

6. シンボリックリンクの作成
   └─ libgcc.a → compiler-rt builtins
   └─ libgcc_eh.a → libunwind.a
   └─ libgcc_s.so.1.0 → libunwind.so
   └─ libgcc_s.so.1 → libgcc_s.so.1.0
   └─ libgcc_s.so → libgcc_s.so.1
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{LLVM_LIBGCC_EXPLICIT_OPT_IN?}
    B -->|No| C[FATAL_ERROR]
    B -->|Yes| D{compiler-rt重複?}
    D -->|Yes| E[FATAL_ERROR]
    D -->|No| F{libunwind重複?}
    F -->|Yes| G[FATAL_ERROR]
    F -->|No| H[compiler-rtビルド]
    H --> I[libunwindビルド]
    I --> J[gcc_s.ver生成]
    J --> K[libunwind_sharedリンク]
    K --> L[シンボリックリンク作成]
    L --> M[インストールターゲット設定]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 明示的オプトイン | ビルドには明示的なオプトインが必要 | 常時 |
| BR-002 | 排他的ビルド | compiler-rt/libunwindとの同時ビルド禁止 | 常時 |
| BR-003 | アーキテクチャ制限 | x86_64/i386/aarch64/arm-gnueabihfのみサポート | ビルド時 |

### 計算ロジック

バージョンスクリプト内のシンボル選択はCプリプロセッサマクロにより決定：
- `GLOBAL_X86`: x86/x86_64共通シンボル
- `GLOBAL_32BIT`: 32ビットプラットフォーム用シンボル
- `GLOBAL_64BIT`: 64ビットプラットフォーム用シンボル
- `ARM_GNUEABIHF`: ARM EABI用シンボル

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FATAL_ERROR | 設定エラー | LLVM_LIBGCC_EXPLICIT_OPT_IN未設定 | -DLLVM_LIBGCC_EXPLICIT_OPT_IN=Yesを追加 |
| FATAL_ERROR | 重複エラー | compiler-rtが同時に有効 | LLVM_ENABLE_RUNTIMESからcompiler-rtを除外 |
| FATAL_ERROR | 重複エラー | libunwindが同時に有効 | LLVM_ENABLE_RUNTIMESからlibunwindを除外 |

### リトライ仕様

CMakeエラーはリトライ不可。設定を修正して再実行する必要がある。

## トランザクション仕様

該当なし（ビルドシステム）

## パフォーマンス要件

特になし。ビルド時間はcompiler-rtとlibunwindのビルド時間に依存。

## セキュリティ考慮事項

- 生成されるライブラリはシステムの低レベルコンポーネントとして動作
- バージョンスクリプトによりエクスポートシンボルを制限
- compiler-rtのビルトイン関数は意図的にシンボルを公開

## 備考

- llvm-libgccは一般的なLLVMユーザー向けではなく、ディストリビューション管理者向けの機能
- LLVM_ENABLE_RUNTIMES=allを使用する場合、llvm-libgccは含まれない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ドキュメントで目的を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LLVMLibgcc.rst | `llvm-libgcc/docs/LLVMLibgcc.rst` | llvm-libgccの動機と設計背景を理解 |

**読解のコツ**: ドキュメントはreStructuredText形式。Motivation、Alternatives、Target audienceの各セクションで設計意図が説明されている。

#### Step 2: ビルドシステムのエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CMakeLists.txt | `llvm-libgcc/CMakeLists.txt` | ビルド全体の流れとターゲット定義 |

**主要処理フロー**:
- **38-46行目**: LLVM_LIBGCC_EXPLICIT_OPT_INのチェックとエラーメッセージ
- **48-58行目**: compiler-rt/libunwindとの重複チェック
- **91-100行目**: compiler-rtとlibunwindのサブディレクトリ追加
- **102-107行目**: バージョンスクリプト生成のカスタムターゲット
- **113-120行目**: libunwind_sharedへのリンクオプション追加
- **136-143行目**: シンボリックリンク作成のカスタムターゲット

#### Step 3: バージョンスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gcc_s.ver.in | `llvm-libgcc/gcc_s.ver.in` | エクスポートシンボルの定義とアーキテクチャ分岐 |

**主要処理フロー**:
- **1-23行目**: プリプロセッサマクロの定義（ARM_GNUEABIHF、GLOBAL_X86等）
- **25-37行目**: GCC_3.0バージョンのベースシンボル
- **46-70行目**: 32/64ビット固有シンボル
- **72-76行目**: x86固有シンボル
- **126-138行目**: aarch64固有シンボル

**読解のコツ**: このファイルはCプリプロセッサで処理される。`#if defined()`による条件分岐でアーキテクチャごとのシンボルが選択される。

#### Step 4: バージョンスクリプト生成ツールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | generate_version_script.py | `llvm-libgcc/generate_version_script.py` | 新規アーキテクチャ追加時のスクリプト生成方法 |

**主要処理フロー**:
- **11-27行目**: `split_suffix()` - シンボル名からバージョン情報を抽出
- **43-61行目**: `intersection()` - LLVM/GCCシンボルの共通部分を抽出
- **64-79行目**: `find_function_names()` - readelfでシンボル一覧を取得

### プログラム呼び出し階層図

```
CMakeLists.txt（エントリーポイント）
    │
    ├─ add_subdirectory(compiler-rt)
    │      └─ compiler-rtのビルド（シンボル公開モード）
    │
    ├─ add_subdirectory(libunwind)
    │      └─ libunwindのビルド（静的・共有）
    │
    ├─ add_custom_target(gcc_s.ver)
    │      └─ Cプリプロセッサ実行
    │             └─ gcc_s.ver.in → gcc_s.ver
    │
    └─ add_custom_target(llvm-libgcc)
           ├─ create_symlink(libgcc.a)
           ├─ create_symlink(libgcc_eh.a)
           └─ create_symlink(libgcc_s.so*)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

compiler-rt/    ─────────▶  CMakeビルド  ─────────────▶  clang_rt.builtins.a
                                │
libunwind/      ─────────▶  CMakeビルド  ─────────────▶  libunwind.a
                                │                          libunwind.so
                                │
gcc_s.ver.in    ─────────▶  Cプリプロセッサ ──────────▶  gcc_s.ver
                                │
                                ▼
                          リンク処理
                         （バージョンスクリプト適用）
                                │
                                ▼
                          シンボリックリンク作成
                                │
                                ▼
                          libgcc.a（→ clang_rt.builtins.a）
                          libgcc_eh.a（→ libunwind.a）
                          libgcc_s.so*（→ libunwind.so）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CMakeLists.txt | `llvm-libgcc/CMakeLists.txt` | ビルド設定 | メインビルドスクリプト |
| gcc_s.ver.in | `llvm-libgcc/gcc_s.ver.in` | テンプレート | バージョンスクリプトテンプレート |
| generate_version_script.py | `llvm-libgcc/generate_version_script.py` | スクリプト | 新アーキテクチャ用スクリプト生成 |
| LLVMLibgcc.rst | `llvm-libgcc/docs/LLVMLibgcc.rst` | ドキュメント | 設計説明ドキュメント |
