# 機能設計書 22-ORC-RT

## 概要

本ドキュメントは、LLVM ORC-RT（ORC Runtime）の機能設計について記述する。ORC-RTは、ORC JITコンパイラ用のランタイムライブラリであり、JITセッションにおけるエグゼキュータプロセス側のAPIを提供する。

### 本機能の処理概要

ORC-RTは、LLVMのOn Request Compilation（ORC）APIにおいて、JITコードを実行するエグゼキュータプロセス側のサポートを提供するランタイムライブラリである。コントローラプロセス（JITコードを定義・リンク）とエグゼキュータプロセス（JITコードを実行）間の連携を支援する。

**業務上の目的・背景**：LLVM ORCはクロスプロセスJITコンパイルをサポートしており、コントローラプロセスとエグゼキュータプロセスの分離が可能である。ORC-RTはエグゼキュータ側で動作するランタイムとして、JITコード実行に必要なリソース管理、タスクディスパッチ、コントローラとの通信機能を提供する。

**機能の利用シーン**：
- JITコンパイルされたコードをリモートプロセスで実行する場合
- JITセッションにおけるリソース（メモリ、動的ライブラリハンドル等）の管理
- コントローラとエグゼキュータ間の双方向RPC通信

**主要な処理内容**：
1. Session管理 - JITプログラムのルートオブジェクトとしてResourceManagerを所有
2. ControllerAccess - コントローラとの双方向RPC通信を提供
3. TaskDispatcher - コントローラからの呼び出しをタスクとしてディスパッチ
4. WrapperFunction - バイト列の入出力を持つ標準的な関数インターフェース
5. SimplePackedSerialization - シリアライゼーション/デシリアライゼーション

**関連システム・外部連携**：LLVM ORC ExecutionSession（コントローラ側）、JITコンパイルされたコード

**権限による制御**：特になし。プロセス間通信のセキュリティはControllerAccessの実装に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はランタイムライブラリであり、直接的な画面は存在しない |

## 機能種別

ランタイムライブラリ / JITコンパイル支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ORC_RT_ENABLE_RTTI | boolean | No | RTTI有効化 | - |
| ORC_RT_ENABLE_EXCEPTIONS | boolean | No | 例外処理有効化 | - |
| ORC_RT_INCLUDE_TESTS | boolean | No | テストビルド | - |
| ORC_RT_ENABLE_ASSERTIONS | boolean | No | アサーション有効化 | - |

### 入力データソース

- コントローラプロセスからのRPC呼び出し（WrapperFunctionBuffer）
- JITコードからの関数呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| WrapperFunctionBuffer | struct | RPC呼び出しの結果バイト列 |
| Error | class | エラー情報 |

### 出力先

- コントローラプロセスへのRPC応答
- JITコードへの戻り値

## 処理フロー

### 処理シーケンス

```
1. Session初期化
   └─ TaskDispatcherの設定
   └─ ErrorReporterの設定

2. ControllerAccess設定
   └─ setController()でコントローラアクセスを登録
   └─ 双方向RPC通信の確立

3. ResourceManager登録
   └─ addResourceManager()でリソースマネージャを追加
   └─ メモリ、ライブラリハンドル等のリソース管理

4. JITコード実行
   └─ コントローラからのWrapperFunction呼び出し
   └─ TaskDispatcherによるタスク実行
   └─ 結果をコントローラに返送

5. シャットダウン
   └─ shutdown()でリソースマネージャを逆順に終了
   └─ TaskDispatcherのタスク完了待ち
```

### フローチャート

```mermaid
flowchart TD
    A[Session作成] --> B[ControllerAccess設定]
    B --> C[ResourceManager登録]
    C --> D{コントローラからの呼び出し?}
    D -->|Yes| E[handleWrapperCall]
    E --> F[TaskDispatcher.dispatch]
    F --> G[WrapperFunction実行]
    G --> H[結果をコントローラに送信]
    H --> D
    D -->|shutdown| I[ResourceManager終了]
    I --> J[TaskDispatcher終了]
    J --> K[Session終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | Session寿命 | SessionはすべてのJITコード実行より長く存続する必要がある | 常時 |
| BR-002 | シャットダウン順序 | ResourceManagerは登録の逆順でシャットダウン | shutdown時 |
| BR-003 | タスク完了保証 | TaskDispatcherはSessionシャットダウン時に全タスク完了を保証 | shutdown時 |

### 計算ロジック

SimplePackedSerializationによるデータのシリアライズ/デシリアライズ。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfBandError | RPC Error | コントローラ未接続時の呼び出し | ControllerAccess確認 |
| ResourceError | Resource Error | リソース確保失敗 | エラーレポーターに報告 |

### リトライ仕様

エラーはErrorReporterを通じて報告される。リトライは呼び出し元の責任。

## トランザクション仕様

該当なし（ランタイムライブラリ）

## パフォーマンス要件

- TaskDispatcherはスレッドプールまたはキューイングベースの実装を提供
- WrapperFunctionは効率的なバイト列の受け渡しを実現

## セキュリティ考慮事項

- ControllerAccessはタグベースの呼び出し制御（エグゼキュータから意図的に公開されたエントリポイントのみ呼び出し可能）
- プロセス間通信のセキュリティはControllerAccess実装に依存

## 備考

- ORC-RTはC++17を要求
- RTTIと例外処理はオプションで有効/無効を選択可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設計ドキュメントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Design.md | `orc-rt/docs/Design.md` | ORC-RTの全体設計と各コンポーネントの役割 |

**読解のコツ**: Background、APIs、各コンポーネントの説明を順に読む。

#### Step 2: 中核クラスSessionを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Session.h | `orc-rt/include/orc-rt/Session.h` | Sessionクラスの定義とControllerAccessの関係 |

**主要処理フロー**:
- **44-47行目**: ErrorReporterとOnShutdownCompleteFnの型定義
- **54-108行目**: ControllerAccessネストクラスの定義
- **118-121行目**: Sessionコンストラクタ
- **132行目**: dispatch()メソッド - タスクディスパッチ
- **140行目**: shutdown()メソッド - シャットダウン開始
- **146行目**: addResourceManager()メソッド
- **149行目**: setController()メソッド
- **174-179行目**: handleWrapperCall()の実装

#### Step 3: TaskDispatcherを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TaskDispatcher.h | `orc-rt/include/orc-rt/TaskDispatcher.h` | TaskDispatcherの抽象インターフェース |
| 3-2 | ThreadPoolTaskDispatcher.h | `orc-rt/include/orc-rt/ThreadPoolTaskDispatcher.h` | スレッドプール実装 |
| 3-3 | QueueingTaskDispatcher.h | `orc-rt/include/orc-rt/QueueingTaskDispatcher.h` | キューイング実装 |

#### Step 4: WrapperFunctionを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WrapperFunction.h | `orc-rt/include/orc-rt/WrapperFunction.h` | WrapperFunctionの定義と使用方法 |
| 4-2 | SPSWrapperFunction.h | `orc-rt/include/orc-rt/SPSWrapperFunction.h` | SPS版WrapperFunction |

#### Step 5: シリアライゼーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | SimplePackedSerialization.h | `orc-rt/include/orc-rt/SimplePackedSerialization.h` | SPSの実装 |

### プログラム呼び出し階層図

```
Session（ルートオブジェクト）
    │
    ├─ TaskDispatcher
    │      ├─ ThreadPoolTaskDispatcher
    │      └─ QueueingTaskDispatcher
    │
    ├─ ControllerAccess
    │      ├─ callController()
    │      ├─ sendWrapperResult()
    │      └─ handleWrapperCall()
    │
    ├─ ResourceManager[]
    │      ├─ detach()
    │      └─ shutdown()
    │
    └─ ErrorReporter
           └─ reportError()
```

### データフロー図

```
[コントローラ]                 [エグゼキュータ（ORC-RT）]

                               Session
                                  │
callWrapper() ─────────────▶ ControllerAccess
                                  │
                                  ▼
                            handleWrapperCall()
                                  │
                                  ▼
                            TaskDispatcher.dispatch()
                                  │
                                  ▼
                            WrapperFunction実行
                                  │
                                  ▼
                            sendWrapperResult()
                                  │
◀──────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Session.h | `orc-rt/include/orc-rt/Session.h` | ヘッダ | Sessionクラス定義 |
| Session.cpp | `orc-rt/lib/executor/Session.cpp` | ソース | Session実装 |
| TaskDispatcher.h | `orc-rt/include/orc-rt/TaskDispatcher.h` | ヘッダ | TaskDispatcher抽象クラス |
| ThreadPoolTaskDispatcher.h | `orc-rt/include/orc-rt/ThreadPoolTaskDispatcher.h` | ヘッダ | スレッドプール実装 |
| QueueingTaskDispatcher.h | `orc-rt/include/orc-rt/QueueingTaskDispatcher.h` | ヘッダ | キューイング実装 |
| WrapperFunction.h | `orc-rt/include/orc-rt/WrapperFunction.h` | ヘッダ | WrapperFunction定義 |
| ResourceManager.h | `orc-rt/include/orc-rt/ResourceManager.h` | ヘッダ | ResourceManager定義 |
| Error.h | `orc-rt/include/orc-rt/Error.h` | ヘッダ | エラーハンドリング |
| SimplePackedSerialization.h | `orc-rt/include/orc-rt/SimplePackedSerialization.h` | ヘッダ | シリアライゼーション |
| Design.md | `orc-rt/docs/Design.md` | ドキュメント | 設計説明 |
| CMakeLists.txt | `orc-rt/CMakeLists.txt` | ビルド設定 | ビルドスクリプト |
