# 機能設計書 23-Flang-RT

## 概要

本ドキュメントは、LLVM Flang-RT（Flang Runtime）の機能設計について記述する。Flang-RTは、Flangコンパイラが生成するコードのためのランタイムライブラリであり、Fortranプログラムの実行に必要なI/O処理、数値計算、配列操作などの機能を提供する。

### 本機能の処理概要

Flang-RTは、Fortran言語のランタイムサポートを提供するライブラリである。Flangコンパイラが生成するコードから呼び出され、Fortranの組み込み関数、I/O操作、メモリ管理、派生型処理などを実装する。

**業務上の目的・背景**：Fortranプログラムの実行には、言語仕様で定義された組み込み関数やI/O処理のランタイムサポートが必要である。Flang-RTはFlangコンパイラとペアで動作し、標準準拠のFortran実行環境を提供する。

**機能の利用シーン**：
- Flangでコンパイルされたプログラムの実行時
- Fortran I/O操作（READ、WRITE、OPEN、CLOSE等）の実行
- 配列組み込み関数（MATMUL、RESHAPE等）の実行
- 派生型のコピー、代入、終了化処理

**主要な処理内容**：
1. I/O処理 - 書式付き/リスト指向/非同期I/O
2. 数値計算 - REAL(16)サポートを含む数学関数
3. 配列操作 - 変形、削減、行列演算
4. メモリ管理 - ALLOCATABLE/POINTERの管理
5. 派生型処理 - コピー、代入、終了化
6. コマンドライン/環境変数アクセス

**関連システム・外部連携**：Flangコンパイラ、OpenMPランタイム（並列処理時）、CUDAランタイム（GPUオフロード時）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はランタイムライブラリであり、直接的な画面は存在しない |

## 機能種別

ランタイムライブラリ / 言語サポート

## 入力仕様

### 入力パラメータ（ビルド時）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FLANG_RT_INCLUDE_TESTS | boolean | No | テストビルド有効化 | - |
| FLANG_RUNTIME_F128_MATH_LIB | string | No | REAL(16)数学ライブラリ | libquadmath/空 |
| FLANG_RT_EXPERIMENTAL_OFFLOAD_SUPPORT | string | No | GPUオフロードサポート | CUDA/OpenMP/空 |
| FLANG_RT_INCLUDE_CUF | boolean | No | CUDA Fortranライブラリビルド | - |

### 入力データソース

- Flangコンパイラが生成したコードからの関数呼び出し
- ファイルシステム（I/O操作）
- コマンドライン引数、環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libflang_rt.runtime.a/.so | ライブラリ | メインランタイムライブラリ |
| libflang_rt.cuda_*.a/.so | ライブラリ | CUDA Fortranサポート |

### 出力先

- Fortranプログラムへの戻り値
- ファイルシステム（I/O出力）
- 標準出力/標準エラー出力

## 処理フロー

### 処理シーケンス

```
1. プログラム初期化
   └─ ランタイム初期化
   └─ I/Oユニット初期化

2. I/O処理（例：WRITE文）
   └─ IoStatementBase作成
   └─ フォーマット解析
   └─ データ出力
   └─ ステートメント終了

3. 配列操作（例：MATMUL）
   └─ Descriptor検証
   └─ 次元/形状チェック
   └─ 計算実行
   └─ 結果格納

4. メモリ管理（例：ALLOCATE）
   └─ サイズ計算
   └─ メモリ確保
   └─ Descriptor更新

5. プログラム終了
   └─ 終了化処理
   └─ I/Oユニットクローズ
   └─ リソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[Fortranプログラム開始] --> B[ランタイム初期化]
    B --> C{ランタイム呼び出し}
    C -->|I/O| D[I/O処理]
    C -->|配列操作| E[配列処理]
    C -->|メモリ管理| F[メモリ処理]
    C -->|派生型| G[派生型処理]
    D --> H[結果返却]
    E --> H
    F --> H
    G --> H
    H --> C
    C -->|終了| I[終了化処理]
    I --> J[リソース解放]
    J --> K[プログラム終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | Fortran標準準拠 | Fortran 2018標準に準拠した動作 | 常時 |
| BR-002 | ABIコンパチビリティ | FlangコンパイラとのABI一致が必要 | 常時 |
| BR-003 | スレッドセーフティ | I/O操作はスレッドセーフ | マルチスレッド時 |

### 計算ロジック

- MATMULは最適化されたBLAS呼び出しまたは直接実装
- REAL(16)数学関数はlibquadmathまたはコンパイラ組み込みを使用

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOSTAT | I/O Error | I/O操作失敗 | IOSTATで取得可能 |
| STAT | Allocation Error | メモリ確保失敗 | STATで取得可能 |
| Runtime Error | Fatal Error | 回復不能エラー | プログラム終了 |

### リトライ仕様

Fortranプログラム側でIOSTAT/STATによるエラーハンドリングが可能。

## トランザクション仕様

該当なし（ランタイムライブラリ）

## パフォーマンス要件

- I/Oはバッファリングによる効率化
- 配列操作は可能な限りベクトル化
- GPUオフロードサポート（実験的）

## セキュリティ考慮事項

- ファイルI/Oはオペレーティングシステムの権限に従う
- バッファオーバーフロー対策

## 備考

- Flang-RTはFlangと同じGitコミットでビルドする必要がある（ABI互換性）
- CUDA/OpenMPオフロードサポートは実験的機能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: READMEで全体像を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | README.md | `flang-rt/README.md` | ビルド方法と設定オプション |

**読解のコツ**: Bootstrapping/Standalone Runtimesの2つのビルドモードを理解する。

#### Step 2: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | descriptor.h | `flang-rt/include/flang-rt/runtime/descriptor.h` | Fortran配列のメタデータ |
| 2-2 | type-info.h | `flang-rt/include/flang-rt/runtime/type-info.h` | 派生型情報 |
| 2-3 | type-code.h | `flang-rt/include/flang-rt/runtime/type-code.h` | 型コード定義 |

**読解のコツ**: DescriptorはFortranの配列を表現する中核データ構造。rank、extent、stride等を持つ。

#### Step 3: I/O処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | io-stmt.h | `flang-rt/include/flang-rt/runtime/io-stmt.h` | I/Oステートメント基底クラス |
| 3-2 | format.h | `flang-rt/include/flang-rt/runtime/format.h` | フォーマット処理 |
| 3-3 | connection.h | `flang-rt/include/flang-rt/runtime/connection.h` | I/O接続管理 |

#### Step 4: 配列操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | reduction-templates.h | `flang-rt/include/flang-rt/runtime/reduction-templates.h` | 削減操作のテンプレート |
| 4-2 | Matmul.cpp | `flang-rt/unittests/Runtime/Matmul.cpp` | MATMUL実装のテスト |

#### Step 5: メモリ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | memory.h | `flang-rt/include/flang-rt/runtime/memory.h` | メモリ管理API |
| 5-2 | allocator-registry.h | `flang-rt/include/flang-rt/runtime/allocator-registry.h` | アロケータレジストリ |

### プログラム呼び出し階層図

```
Fortranプログラム
    │
    ├─ I/O操作
    │      ├─ IoStatementBase
    │      │      ├─ InternalFormattedIoStatementState
    │      │      └─ ExternalFormattedIoStatementState
    │      ├─ FormatControl
    │      └─ Connection
    │
    ├─ 配列操作
    │      ├─ Descriptor
    │      ├─ ReductionOperation
    │      └─ Transformational
    │
    ├─ メモリ管理
    │      ├─ AllocatorRegistry
    │      └─ Memory
    │
    └─ 派生型処理
           ├─ TypeInfo
           └─ Derived
```

### データフロー図

```
[Fortranプログラム]          [Flang-RT]                    [OS/ハードウェア]

WRITE(*,*) x  ────────▶  IoStatementBase
                               │
                               ▼
                         FormatControl
                               │
                               ▼
                         Connection.write()
                               │
                         ──────────────────▶  stdout/file

MATMUL(A,B)   ────────▶  Descriptor(A)
                         Descriptor(B)
                               │
                               ▼
                         matmul実装
                               │
                               ▼
                         結果Descriptor ─────▶  呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| README.md | `flang-rt/README.md` | ドキュメント | ビルド説明 |
| CMakeLists.txt | `flang-rt/CMakeLists.txt` | ビルド設定 | メインビルドスクリプト |
| descriptor.h | `flang-rt/include/flang-rt/runtime/descriptor.h` | ヘッダ | 配列記述子 |
| type-info.h | `flang-rt/include/flang-rt/runtime/type-info.h` | ヘッダ | 型情報 |
| io-stmt.h | `flang-rt/include/flang-rt/runtime/io-stmt.h` | ヘッダ | I/Oステートメント |
| format.h | `flang-rt/include/flang-rt/runtime/format.h` | ヘッダ | フォーマット処理 |
| memory.h | `flang-rt/include/flang-rt/runtime/memory.h` | ヘッダ | メモリ管理 |
| connection.h | `flang-rt/include/flang-rt/runtime/connection.h` | ヘッダ | I/O接続 |
| terminator.h | `flang-rt/include/flang-rt/runtime/terminator.h` | ヘッダ | エラー終了処理 |
| environment.h | `flang-rt/include/flang-rt/runtime/environment.h` | ヘッダ | 環境変数アクセス |
