# 機能設計書 26-llvm-mc

## 概要

本ドキュメントは、LLVM llvm-mcの機能設計について記述する。llvm-mcは、マシンコードのアセンブル（アセンブリからオブジェクトコードへの変換）および逆アセンブル（マシンコードからアセンブリへの変換）を行うツールである。

### 本機能の処理概要

llvm-mcは、LLVMのMC（Machine Code）レイヤーを直接操作するためのツールである。アセンブリ言語のアセンブル、マシンコードの逆アセンブル、アセンブリのトークン化など、低レベルのマシンコード操作を行う。

**業務上の目的・背景**：コンパイラのバックエンド開発やマシンコード生成のテスト・デバッグには、アセンブリとマシンコードを直接操作できるツールが必要である。llvm-mcはこの目的で使用され、特にLLVMターゲット開発において重要な役割を果たす。

**機能の利用シーン**：
- アセンブリファイルのアセンブル（.sから.oへ）
- マシンコードの逆アセンブル（ヘキサバイトからアセンブリへ）
- アセンブリのレキシング（トークン化）
- ターゲット固有のアセンブリ構文テスト
- 命令エンコーディングの確認

**主要な処理内容**：
1. ターゲットの決定（--triple、--arch）
2. アセンブリ入力の読み込み
3. アクション実行（アセンブル/逆アセンブル/レキシング）
4. 出力生成（アセンブリ/オブジェクト/null）

**関連システム・外部連携**：LLVMターゲットバックエンド、MCレイヤー、アセンブラ/逆アセンブラ

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコマンドラインツールであり、画面は存在しない |

## 機能種別

マシンコード操作ツール / アセンブラ・逆アセンブラ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input file | string | No | 入力ファイル（デフォルト: stdin） | - |
| -o | string | No | 出力ファイル | - |
| --triple | string | No | ターゲットトリプル | 有効なトリプル |
| --arch | string | No | アーキテクチャ名 | サポートされるアーキテクチャ |
| --filetype | enum | No | 出力形式（asm/obj/null） | - |
| --mcpu | string | No | ターゲットCPU | - |
| --mattr | string[] | No | ターゲット属性 | - |
| --assemble | flag | No | アセンブルモード（デフォルト） | - |
| --disassemble | flag | No | 逆アセンブルモード | - |
| --as-lex | flag | No | レキシングモード | - |
| --show-encoding | flag | No | エンコーディング表示 | - |
| --show-inst | flag | No | 内部命令表現表示 | - |
| -g | flag | No | デバッグ情報生成 | - |
| --hex | flag | No | ヘキサバイト入力（逆アセンブル時） | - |

### 入力データソース

- アセンブリファイル（.s）
- ヘキサバイト文字列（逆アセンブル時）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アセンブリ | text | --filetype=asm時 |
| オブジェクトファイル | binary | --filetype=obj時 |
| トークン一覧 | text | --as-lex時 |

### 出力先

- 標準出力または指定されたファイル

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ InitLLVMでLLVM初期化
   └─ 全ターゲットの初期化
   └─ コマンドライン引数解析

2. ターゲット取得
   └─ ターゲットトリプル決定
   └─ TargetRegistry::lookupTarget()

3. MCコンテキスト構築
   └─ MCRegisterInfo作成
   └─ MCAsmInfo作成
   └─ MCSubtargetInfo作成
   └─ MCObjectFileInfo作成

4. ストリーマー作成
   └─ アクションとfiletypeに応じたStreamer選択
   └─ MCCodeEmitter作成（必要時）
   └─ MCAsmBackend作成（必要時）

5. アクション実行
   └─ AC_AsLex: トークン出力
   └─ AC_Assemble: アセンブル実行
   └─ AC_Disassemble: 逆アセンブル実行

6. 出力ファイル保持
   └─ エラーがなければ出力を確定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[LLVM初期化]
    B --> C[全ターゲット初期化]
    C --> D[コマンドライン解析]
    D --> E[ターゲット決定]
    E --> F{ターゲット存在?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[MCContext構築]
    H --> I[Streamer作成]
    I --> J{Action?}
    J -->|as-lex| K[AsLexInput]
    J -->|assemble| L[AssembleInput]
    J -->|disassemble| M[Disassembler::disassemble]
    K --> N{成功?}
    L --> N
    M --> N
    N -->|Yes| O[出力確定]
    N -->|No| P[エラー終了]
    O --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | デフォルトアクション | アクション未指定時はassemble | 常時 |
| BR-002 | デフォルト出力 | filetype未指定時はasm | 常時 |
| BR-003 | ターゲット必須 | 有効なターゲットが必要 | 常時 |

### 計算ロジック

ターゲット固有の命令エンコーディング/デコーディング。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Target Error | ターゲット不明 | --triple/--arch確認 |
| 1 | Parse Error | アセンブリパース失敗 | 入力構文確認 |
| 1 | Disassemble Error | 逆アセンブル失敗 | 入力バイト確認 |

### リトライ仕様

エラー時は終了コード1で終了。

## トランザクション仕様

該当なし

## パフォーマンス要件

- --runsオプションでベンチマーク実行可能
- 時間プロファイル出力オプション

## セキュリティ考慮事項

- 入力ファイルの妥当性チェック
- 出力ファイルのパーミッション管理

## 備考

- LLVMターゲット開発の必須ツール
- 複数の出力バリアント（--output-asm-variant）をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインソースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-mc.cpp | `llvm/tools/llvm-mc/llvm-mc.cpp` | ツール全体の実装 |

**主要処理フロー**:
- **52-244行目**: コマンドラインオプション定義
- **263-281行目**: GetTarget() - ターゲット取得
- **313-328行目**: AsLexInput() - レキシングモード
- **351-378行目**: AssembleInput() - アセンブルモード
- **380-681行目**: main()関数 - メイン処理フロー

**読解のコツ**: ActionTypeとOutputFileTypeの列挙型を理解することで、ツールのモード切り替えが理解できる。

#### Step 2: ターゲット決定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-mc.cpp | `llvm/tools/llvm-mc/llvm-mc.cpp` | GetTarget関数 |

**主要処理フロー**:
- **265-267行目**: デフォルトターゲットトリプル取得
- **271-272行目**: TargetRegistry::lookupTarget()呼び出し
- **279行目**: TripleName更新

#### Step 3: 逆アセンブラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Disassembler.h | `llvm/tools/llvm-mc/Disassembler.h` | 逆アセンブラインターフェース |
| 3-2 | Disassembler.cpp | `llvm/tools/llvm-mc/Disassembler.cpp` | 逆アセンブラ実装 |

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitLLVM()
    │
    ├─ InitializeAllTargetInfos()
    ├─ InitializeAllTargetMCs()
    ├─ InitializeAllAsmParsers()
    ├─ InitializeAllDisassemblers()
    │
    ├─ GetTarget()
    │      └─ TargetRegistry::lookupTarget()
    │
    ├─ TheTarget->createMCRegInfo()
    ├─ TheTarget->createMCAsmInfo()
    ├─ TheTarget->createMCSubtargetInfo()
    ├─ TheTarget->createMCObjectFileInfo()
    │
    └─ switch(Action)
           │
           ├─ AC_AsLex
           │      └─ AsLexInput()
           │             └─ AsmLexer
           │
           ├─ AC_Assemble
           │      └─ AssembleInput()
           │             ├─ createMCAsmParser()
           │             └─ Parser->Run()
           │
           └─ AC_Disassemble
                  └─ Disassembler::disassemble()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

.sファイル/stdin ────────▶ MCAsmParser
                                │
                                ▼
                           MCStreamer
                                │
                ┌───────────────┼───────────────┐
                ▼               ▼               ▼
         AsmStreamer     ObjectStreamer    NullStreamer
                │               │               │
                ▼               ▼               ▼
         .s出力          .o出力            /dev/null

ヘキサバイト ────────────▶ MCDisassembler
                                │
                                ▼
                           MCInst
                                │
                                ▼
                           MCInstPrinter ──────▶ アセンブリ出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-mc.cpp | `llvm/tools/llvm-mc/llvm-mc.cpp` | ソース | メイン実装 |
| Disassembler.h | `llvm/tools/llvm-mc/Disassembler.h` | ヘッダ | 逆アセンブラ宣言 |
| Disassembler.cpp | `llvm/tools/llvm-mc/Disassembler.cpp` | ソース | 逆アセンブラ実装 |
| CMakeLists.txt | `llvm/tools/llvm-mc/CMakeLists.txt` | ビルド設定 | ビルドスクリプト |
| MCAsmInfo.h | `llvm/include/llvm/MC/MCAsmInfo.h` | ヘッダ | アセンブリ情報 |
| MCContext.h | `llvm/include/llvm/MC/MCContext.h` | ヘッダ | MCコンテキスト |
| MCStreamer.h | `llvm/include/llvm/MC/MCStreamer.h` | ヘッダ | MCストリーマー |
| TargetRegistry.h | `llvm/include/llvm/MC/TargetRegistry.h` | ヘッダ | ターゲット登録 |
