# 機能設計書 27-llvm-objdump

## 概要

本ドキュメントは、LLVM llvm-objdumpの機能設計について記述する。llvm-objdumpは、オブジェクトファイルの内容を表示するツールであり、GNU binutilsのobjdumpと互換性のある機能を提供する。

### 本機能の処理概要

llvm-objdumpは、様々なフォーマット（ELF、COFF、MachO、Wasm等）のオブジェクトファイルの内容をダンプするツールである。セクション、シンボル、リロケーション、逆アセンブリなどの情報を表示する。

**業務上の目的・背景**：オブジェクトファイルの内容を検査することは、コンパイラ開発、デバッグ、リバースエンジニアリングにおいて重要である。llvm-objdumpはGNU objdumpとの互換性を保ちながら、LLVMのツールチェーンに統合された形で同等の機能を提供する。

**機能の利用シーン**：
- コンパイル結果の検証
- バイナリの逆アセンブル
- セクション内容の確認
- シンボルテーブルの調査
- リロケーション情報の確認
- デバッグ情報の解析

**主要な処理内容**：
1. オブジェクトファイルの読み込みとフォーマット判定
2. 指定されたオプションに応じた情報抽出
3. 逆アセンブル（-dオプション）
4. セクションヘッダ、シンボルテーブル等の表示
5. 出力フォーマット調整

**関連システム・外部連携**：llvm-readobj、llvm-nm、llvm-symbolizer（デバッグ情報）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコマンドラインツールであり、画面は存在しない |

## 機能種別

バイナリ解析ツール / オブジェクトファイルダンプ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input files | string[] | Yes | 入力オブジェクトファイル | ファイル存在確認 |
| -d/--disassemble | flag | No | テキストセクションを逆アセンブル | - |
| -D/--disassemble-all | flag | No | 全セクションを逆アセンブル | - |
| -h/--headers | flag | No | セクションヘッダを表示 | - |
| -t/--syms | flag | No | シンボルテーブルを表示 | - |
| -r/--reloc | flag | No | リロケーションを表示 | - |
| -s/--full-contents | flag | No | セクション内容を表示 | - |
| -x/--all-headers | flag | No | 全ヘッダを表示 | - |
| --demangle | flag | No | シンボル名をデマングル | - |
| -S/--source | flag | No | ソースコードを表示 | - |
| -l/--line-numbers | flag | No | 行番号を表示 | - |
| --triple | string | No | ターゲットトリプル | - |
| -M | string[] | No | 逆アセンブラオプション | - |

### 入力データソース

- ELF、COFF、MachO、Wasm、DXContainer等のオブジェクトファイル
- アーカイブファイル（.a）
- ユニバーサルバイナリ（MachO）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルヘッダ | text | オブジェクトフォーマット情報 |
| セクションヘッダ | text | セクション一覧と属性 |
| シンボルテーブル | text | シンボル名、アドレス、サイズ |
| 逆アセンブリ | text | マシンコードとアセンブリ |
| リロケーション | text | リロケーションエントリ |

### 出力先

- 標準出力

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ LLVM初期化
   └─ 全ターゲットの初期化
   └─ コマンドライン引数解析

2. 各入力ファイルの処理
   └─ createBinary()でバイナリ読み込み
   └─ フォーマット判定（ELF/COFF/MachO等）

3. オブジェクトタイプ別処理
   └─ Archive: 各メンバーを処理
   └─ MachOUniversal: 指定アーキテクチャを処理
   └─ ObjectFile: 直接処理

4. 情報ダンプ
   └─ オプションに応じた情報表示
   └─ 逆アセンブル（-d/-D時）
   └─ ヘッダ表示（-h/-x時）
   └─ シンボル表示（-t時）
   └─ リロケーション表示（-r時）

5. 出力完了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[LLVM/ターゲット初期化]
    B --> C[コマンドライン解析]
    C --> D[入力ファイルループ]
    D --> E[createBinary]
    E --> F{ファイルタイプ?}
    F -->|Archive| G[アーカイブメンバー処理]
    F -->|MachOUniversal| H[アーキテクチャ選択]
    F -->|ObjectFile| I[オブジェクト処理]
    G --> I
    H --> I
    I --> J{オプション?}
    J -->|disassemble| K[逆アセンブル]
    J -->|headers| L[ヘッダ表示]
    J -->|syms| M[シンボル表示]
    J -->|reloc| N[リロケーション表示]
    K --> O[次のファイル]
    L --> O
    M --> O
    N --> O
    O --> D
    D -->|完了| P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | GNU objdump互換 | 出力形式はGNU objdumpに近似 | 常時 |
| BR-002 | デマングル | --demangleでC++名をデマングル | C++シンボル時 |
| BR-003 | ソース表示 | -Sでデバッグ情報からソース表示 | デバッグ情報存在時 |

### 計算ロジック

逆アセンブルはターゲット固有のMCDisassemblerを使用。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | File Error | ファイル読み込み失敗 | ファイルパス確認 |
| 1 | Format Error | 未サポートフォーマット | フォーマット確認 |
| 1 | Target Error | ターゲット不明 | --triple指定 |

### リトライ仕様

エラー時は該当ファイルをスキップして継続可能。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 大規模バイナリでも効率的に処理
- 逆アセンブルはセクション単位で処理

## セキュリティ考慮事項

- 入力ファイルの妥当性検証
- バッファオーバーフロー対策

## 備考

- llvm-otoolとして起動するとmacOS otool互換モード
- BBAddrMap、PGOAnalysisMapのサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインソースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-objdump.cpp | `llvm/tools/llvm-objdump/llvm-objdump.cpp` | メイン処理フロー |

**主要処理フロー**:
- **92-175行目**: ObjdumpOptTable/OtoolOptTable - オプションテーブル定義
- **176-288行目**: BBAddrMapInfo - BBアドレスマップ関連クラス
- **294-300行目**: グローバル設定変数
- main関数からの呼び出しチェーン

**読解のコツ**: objdump_optネームスペースとotoolネームスペースの2つのオプション体系がある。

#### Step 2: フォーマット別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ELFDump.cpp | `llvm/tools/llvm-objdump/ELFDump.cpp` | ELF固有処理 |
| 2-2 | COFFDump.cpp | `llvm/tools/llvm-objdump/COFFDump.cpp` | COFF固有処理 |
| 2-3 | MachODump.cpp | `llvm/tools/llvm-objdump/MachODump.cpp` | MachO固有処理 |
| 2-4 | WasmDump.cpp | `llvm/tools/llvm-objdump/WasmDump.cpp` | Wasm固有処理 |

#### Step 3: ソース表示機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SourcePrinter.h | `llvm/tools/llvm-objdump/SourcePrinter.h` | ソースプリンタ宣言 |
| 3-2 | SourcePrinter.cpp | `llvm/tools/llvm-objdump/SourcePrinter.cpp` | ソースプリンタ実装 |

### プログラム呼び出し階層図

```
main() / llvm_objdump_main()
    │
    ├─ InitializeAllTargetInfos()
    ├─ InitializeAllTargetMCs()
    ├─ InitializeAllDisassemblers()
    │
    └─ for each InputFilename
           │
           ├─ createBinary()
           │
           └─ switch(BinaryType)
                  │
                  ├─ Archive
                  │      └─ dumpArchive()
                  │
                  ├─ MachOUniversalBinary
                  │      └─ dumpMachOUniversalBinary()
                  │
                  └─ ObjectFile
                         └─ dumpObject()
                                │
                                ├─ ELFObjectFile
                                │      └─ ELF固有処理
                                │
                                ├─ COFFObjectFile
                                │      └─ COFF固有処理
                                │
                                ├─ MachOObjectFile
                                │      └─ MachO固有処理
                                │
                                └─ disassembleObject()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

オブジェクトファイル ────────▶ createBinary()
                                   │
                                   ▼
                           ObjectFile解析
                                   │
                ┌──────────────────┼──────────────────┐
                ▼                  ▼                  ▼
          ELFDumper          COFFDumper         MachODumper
                │                  │                  │
                └──────────────────┼──────────────────┘
                                   │
                                   ▼
                           MCDisassembler
                                   │
                                   ▼
                           SourcePrinter（-S時）
                                   │
                                   ▼
                           stdout ──────────────────▶ テキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-objdump.cpp | `llvm/tools/llvm-objdump/llvm-objdump.cpp` | ソース | メイン実装 |
| llvm-objdump.h | `llvm/tools/llvm-objdump/llvm-objdump.h` | ヘッダ | 共通宣言 |
| ELFDump.cpp | `llvm/tools/llvm-objdump/ELFDump.cpp` | ソース | ELF処理 |
| COFFDump.cpp | `llvm/tools/llvm-objdump/COFFDump.cpp` | ソース | COFF処理 |
| MachODump.cpp | `llvm/tools/llvm-objdump/MachODump.cpp` | ソース | MachO処理 |
| WasmDump.cpp | `llvm/tools/llvm-objdump/WasmDump.cpp` | ソース | Wasm処理 |
| XCOFFDump.cpp | `llvm/tools/llvm-objdump/XCOFFDump.cpp` | ソース | XCOFF処理 |
| SourcePrinter.cpp | `llvm/tools/llvm-objdump/SourcePrinter.cpp` | ソース | ソース表示 |
| OffloadDump.cpp | `llvm/tools/llvm-objdump/OffloadDump.cpp` | ソース | オフロード処理 |
| ObjdumpOpts.td | `llvm/tools/llvm-objdump/ObjdumpOpts.td` | 定義 | オプション定義 |
