# 機能設計書 28-llvm-readobj

## 概要

本ドキュメントは、LLVM llvm-readobjの機能設計について記述する。llvm-readobjは、オブジェクトファイルの詳細情報を読み取り、構造化された出力形式で表示するツールである。

### 本機能の処理概要

llvm-readobjは、readelfに類似した機能を持つが、複数のオブジェクトファイルフォーマットに対応し、FileCheckテストに適した詳細な出力を提供する。LLVM、GNU、JSON形式の出力をサポートする。

**業務上の目的・背景**：オブジェクトファイルの詳細な構造情報を取得することは、コンパイラ開発、バイナリ解析、テスト自動化において重要である。llvm-readobjはreadelfのフラグと類似した操作性を提供しながら、より詳細でテストしやすい出力を生成する。

**機能の利用シーン**：
- LLVMのFileCheckを使用したテスト
- オブジェクトファイルの詳細構造確認
- ELFセクション、シンボル、リロケーションの解析
- COFF/PE固有情報の取得
- MachO loadコマンドの確認

**主要な処理内容**：
1. オブジェクトファイルの読み込みとフォーマット判定
2. フォーマット別ダンパー（ObjDumper）の選択
3. 指定されたオプションに応じた情報抽出
4. LLVM/GNU/JSON形式での出力

**関連システム・外部連携**：llvm-objdump、llvm-nm、FileCheck

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコマンドラインツールであり、画面は存在しない |

## 機能種別

バイナリ解析ツール / オブジェクトファイル読み取り

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input files | string[] | Yes | 入力オブジェクトファイル | ファイル存在確認 |
| -a/--all | flag | No | 全情報を表示 | - |
| -h/--file-header | flag | No | ファイルヘッダを表示 | - |
| -S/--section-headers | flag | No | セクションヘッダを表示 | - |
| -s/--symbols | flag | No | シンボルを表示 | - |
| -r/--relocs | flag | No | リロケーションを表示 | - |
| -u/--unwind | flag | No | アンワインド情報を表示 | - |
| -d/--dynamic-table | flag | No | 動的テーブルを表示（ELF） | - |
| -l/--program-headers | flag | No | プログラムヘッダを表示（ELF） | - |
| -n/--notes | flag | No | ノートセクションを表示（ELF） | - |
| --elf-output-style | enum | No | 出力形式（LLVM/GNU/JSON） | - |
| --demangle | flag | No | シンボル名をデマングル | - |
| --hex-dump | string | No | 指定セクションを16進ダンプ | - |
| --string-dump | string | No | 指定セクションを文字列ダンプ | - |

### 入力データソース

- ELF、COFF、MachO、Wasm、XCOFFオブジェクトファイル
- アーカイブファイル
- Windowsリソースファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルヘッダ | text/json | オブジェクト基本情報 |
| セクション情報 | text/json | セクション一覧と属性 |
| シンボル情報 | text/json | シンボルテーブル |
| リロケーション | text/json | リロケーションエントリ |
| 動的情報 | text/json | ELF動的セクション |

### 出力先

- 標準出力（fouts()）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ コマンドライン引数解析（OptTable使用）
   └─ オプション検証

2. 各入力ファイルの処理
   └─ createBinary()でバイナリ読み込み
   └─ フォーマット判定

3. ダンパー作成
   └─ ELFDumper
   └─ COFFDumper
   └─ MachODumper
   └─ WasmDumper
   └─ XCOFFDumper

4. 情報ダンプ
   └─ 出力スタイル（LLVM/GNU/JSON）に応じた出力
   └─ ScopedPrinterまたはJSON出力

5. エラー処理
   └─ 警告の収集と報告
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[入力ファイルループ]
    C --> D[createBinary]
    D --> E{ファイルタイプ?}
    E -->|ELF| F[createELFDumper]
    E -->|COFF| G[createCOFFDumper]
    E -->|MachO| H[createMachODumper]
    E -->|Wasm| I[createWasmDumper]
    E -->|XCOFF| J[createXCOFFDumper]
    F --> K{出力スタイル?}
    G --> K
    H --> K
    I --> K
    J --> K
    K -->|LLVM| L[LLVM形式出力]
    K -->|GNU| M[GNU形式出力]
    K -->|JSON| N[JSON形式出力]
    L --> O[次のファイル]
    M --> O
    N --> O
    O --> C
    C -->|完了| P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | readelf類似フラグ | readelfと類似のフラグを使用 | 常時 |
| BR-002 | FileCheck適合 | 出力はFileCheckでテスト可能な形式 | LLVM形式時 |
| BR-003 | フォーマット特化 | 各フォーマットに特化した情報を出力 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | File Error | ファイル読み込み失敗 | ファイル確認 |
| 1 | Format Error | 未サポートフォーマット | フォーマット確認 |
| 警告 | Warning | 軽微な問題 | 処理継続 |

### リトライ仕様

エラー時はreportError()で終了。警告はreportWarning()で継続。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 大規模バイナリでも効率的に処理
- 必要なセクションのみ読み込み可能

## セキュリティ考慮事項

- 入力ファイルの妥当性検証

## 備考

- llvm-readelfとして起動するとGNU出力形式がデフォルト
- CodeView情報の詳細ダンプ（COFF）
- マージ型テーブルサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインソースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-readobj.cpp | `llvm/tools/llvm-readobj/llvm-readobj.cpp` | メイン処理フロー |

**主要処理フロー**:
- **53-93行目**: オプションID定義とOptTable
- **95-176行目**: optsネームスペース - グローバルオプション変数
- **182-211行目**: エラー/警告報告関数
- **215-300行目以降**: parseOptions()関数とメイン処理

**読解のコツ**: OutputStyleTyでLLVM/GNU/JSONの3形式を切り替える。

#### Step 2: ObjDumperインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ObjDumper.h | `llvm/tools/llvm-readobj/ObjDumper.h` | ダンパー基底クラス |
| 2-2 | ObjDumper.cpp | `llvm/tools/llvm-readobj/ObjDumper.cpp` | 共通実装 |

#### Step 3: フォーマット別ダンパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ELFDumper.cpp | `llvm/tools/llvm-readobj/ELFDumper.cpp` | ELFダンパー |
| 3-2 | COFFDumper.cpp | `llvm/tools/llvm-readobj/COFFDumper.cpp` | COFFダンパー |
| 3-3 | MachODumper.cpp | `llvm/tools/llvm-readobj/MachODumper.cpp` | MachOダンパー |

### プログラム呼び出し階層図

```
llvm_readobj_main()
    │
    ├─ parseOptions()
    │
    └─ for each InputFilename
           │
           ├─ createBinary()
           │
           └─ dumpInput()
                  │
                  ├─ createDumper()
                  │      │
                  │      ├─ ELFDumper
                  │      ├─ COFFDumper
                  │      ├─ MachODumper
                  │      ├─ WasmDumper
                  │      └─ XCOFFDumper
                  │
                  └─ Dumper->printXXX()
                         │
                         ├─ printFileHeaders()
                         ├─ printSectionHeaders()
                         ├─ printSymbols()
                         ├─ printRelocations()
                         └─ ...
```

### データフロー図

```
[入力]                      [処理]                         [出力]

オブジェクトファイル ────────▶ createBinary()
                                   │
                                   ▼
                           createDumper()
                                   │
                                   ▼
                           ObjDumper派生クラス
                                   │
                                   ▼
                ┌──────────────────┼──────────────────┐
                ▼                  ▼                  ▼
         ScopedPrinter      LLVMStyle           JSONScopedPrinter
         (LLVM形式)         (GNU形式)           (JSON形式)
                │                  │                  │
                └──────────────────┼──────────────────┘
                                   ▼
                           fouts() ──────────────────▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-readobj.cpp | `llvm/tools/llvm-readobj/llvm-readobj.cpp` | ソース | メイン実装 |
| llvm-readobj.h | `llvm/tools/llvm-readobj/llvm-readobj.h` | ヘッダ | 共通宣言 |
| ObjDumper.h | `llvm/tools/llvm-readobj/ObjDumper.h` | ヘッダ | ダンパー基底 |
| ObjDumper.cpp | `llvm/tools/llvm-readobj/ObjDumper.cpp` | ソース | 共通実装 |
| ELFDumper.cpp | `llvm/tools/llvm-readobj/ELFDumper.cpp` | ソース | ELFダンパー |
| COFFDumper.cpp | `llvm/tools/llvm-readobj/COFFDumper.cpp` | ソース | COFFダンパー |
| MachODumper.cpp | `llvm/tools/llvm-readobj/MachODumper.cpp` | ソース | MachOダンパー |
| WasmDumper.cpp | `llvm/tools/llvm-readobj/WasmDumper.cpp` | ソース | Wasmダンパー |
| XCOFFDumper.cpp | `llvm/tools/llvm-readobj/XCOFFDumper.cpp` | ソース | XCOFFダンパー |
| WindowsResourceDumper.cpp | `llvm/tools/llvm-readobj/WindowsResourceDumper.cpp` | ソース | Windowsリソース |
| Opts.td | `llvm/tools/llvm-readobj/Opts.td` | 定義 | オプション定義 |
