# 機能設計書 43-llvm-cov

## 概要

本ドキュメントは、LLVM llvm-covツールの機能設計を記述したものである。llvm-covはコードカバレッジデータを可視化・分析するためのツールである。

### 本機能の処理概要

llvm-covは、Clangのインストルメンテーションによって収集されたコードカバレッジ情報を解析し、人間が読める形式で表示・エクスポートするツールである。ソースコードにカバレッジ情報をアノテーションとして付加したり、サマリーレポートを生成したりする機能を提供する。

**業務上の目的・背景**：ソフトウェア品質保証において、コードカバレッジはテストの網羅性を測定する重要な指標である。llvm-covは、開発者やQAエンジニアがテストの効果を評価し、未テスト領域を特定するための可視化と分析機能を提供する。

**機能の利用シーン**：
- テスト実行後にカバレッジレポートを生成する場合
- 特定のソースファイルのカバレッジ状況を詳細に確認する場合
- CIパイプラインでカバレッジデータをJSON/LCOV形式でエクスポートする場合
- gcov互換モードでカバレッジを処理する場合

**主要な処理内容**：
1. show: ソースコードにカバレッジアノテーションを付けて表示
2. report: カバレッジサマリーレポートを生成
3. export: カバレッジデータをJSON/LCOV形式でエクスポート
4. gcov: gcov互換モードでの処理
5. convert-for-testing: テスト用のカバレッジデータ変換

**関連システム・外部連携**：
- Clangの-fprofile-instr-generateと-fcoverage-mappingフラグ
- プロファイルマージツール（llvm-profdata）
- CI/CDシステムへのカバレッジレポート提供

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | サブコマンドとオプションの指定 |
| - | HTMLレポート | 結果表示画面 | ブラウザでのカバレッジ閲覧 |

## 機能種別

レポート出力 / データ変換処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| サブコマンド | string | Yes | show/report/export/gcov | 有効なサブコマンド名 |
| instr-profile | string | Yes | インストルメンテーションプロファイル | ファイル存在チェック |
| object | string | Yes | カバレッジマッピングを含むオブジェクト | ファイル存在チェック |
| sources | string[] | No | 対象ソースファイル | - |
| format | enum | No | 出力形式（text/html/lcov/json） | 有効な形式 |
| output-dir | string | No | 出力ディレクトリ | 書き込み可能パス |

### 入力データソース

- インストルメンテーションプロファイル（.profdata）
- 実行バイナリまたはオブジェクトファイル（カバレッジマッピングを含む）
- ソースファイル（アノテーション表示用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アノテーション付きソース | text/html | 行ごとの実行回数を表示 |
| カバレッジサマリー | text | ファイル/関数別の統計 |
| JSON出力 | json | 構造化されたカバレッジデータ |
| LCOV出力 | text | LCOV形式のカバレッジデータ |

### 出力先

- 標準出力
- 指定されたファイルまたはディレクトリ
- HTMLファイル群（--format=html時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ サブコマンドとオプションの識別
2. カバレッジマッピングの読み込み
   └─ オブジェクトファイルからマッピングデータを抽出
3. プロファイルデータの読み込み
   └─ 実行カウント情報を取得
4. カバレッジ情報の構築
   └─ マッピングとカウントを結合
5. ソースファイルの読み込み（show時）
   └─ アノテーション対象のソース取得
6. 結果の出力
   └─ 指定形式での出力生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{サブコマンド判定}
    B -->|show| C[showMain]
    B -->|report| D[reportMain]
    B -->|export| E[exportMain]
    B -->|gcov| F[gcovMain]
    C --> G[CoverageMapping読込]
    D --> G
    E --> G
    G --> H[プロファイル読込]
    H --> I[カバレッジ構築]
    C --> J[ソースファイル読込]
    J --> K[アノテーション生成]
    K --> L[出力]
    D --> M[サマリー生成]
    M --> L
    E --> N[JSON/LCOV変換]
    N --> L
    F --> O[gcov互換処理]
    O --> L
    L --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | プロファイル必須 | --instr-profileオプションは必須 | 常時 |
| BR-43-02 | オブジェクト必須 | カバレッジマッピングを含むオブジェクトが必要 | 常時 |
| BR-43-03 | パス等価性 | --path-equivalenceで異なるパスをマッピング可能 | ビルドパスと実行パスが異なる場合 |

### 計算ロジック

- 行カバレッジ: 実行された行数 / 全行数
- 関数カバレッジ: 実行された関数数 / 全関数数
- ブランチカバレッジ: 取られたブランチ数 / 全ブランチ数
- MCDC: Modified Condition/Decision Coverage

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | プロファイル不在 | プロファイルファイルが存在しない | ファイルパスを確認 |
| - | マッピング不在 | オブジェクトにカバレッジマッピングがない | -fcoverage-mappingでビルド |
| - | ソース不一致 | ソースファイルが見つからない | --path-equivalenceを使用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- マルチスレッド処理によるレポート生成の高速化
- 大規模プロジェクト（数千ファイル）のサポート

## セキュリティ考慮事項

- 入力ファイルの検証
- 出力ディレクトリの権限確認

## 備考

- gcov互換モードは従来のgcovワークフローとの互換性を提供
- MCDCカバレッジはMC/DCテスト基準に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カバレッジ処理に関わる主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CoverageMapping.h | `llvm/include/llvm/ProfileData/Coverage/CoverageMapping.h` | カバレッジマッピング構造 |
| 1-2 | CoverageSummaryInfo.h | `llvm/tools/llvm-cov/CoverageSummaryInfo.h` | サマリー情報構造 |

**読解のコツ**: CoverageMappingはソースコード領域と実行カウントのマッピングを表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-cov.cpp | `llvm/tools/llvm-cov/llvm-cov.cpp` | メイン関数とサブコマンド分岐 |

**主要処理フロー**:
1. **24-37行目**: 各サブコマンドのmain関数宣言
2. **40-50行目**: helpMain()でヘルプ出力
3. **58-93行目**: main()関数でサブコマンド分岐

#### Step 3: CodeCoverageToolを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeCoverage.cpp | `llvm/tools/llvm-cov/CodeCoverage.cpp` | 主要機能の実装 |

**主要処理フロー**:
- **60-69行目**: CodeCoverageTool::Command列挙型（Show/Report/Export）
- **71行目**: run()メソッドのシグネチャ
- **119-120行目**: load()でCoverageMappingを読み込み
- **133-145行目**: 各サブコマンドハンドラ

### プログラム呼び出し階層図

```
main()
    │
    ├─ gcovMain() ─────────▶ gcov互換処理
    │
    ├─ showMain()
    │      └─ CodeCoverageTool::run(Show)
    │              ├─ load() → CoverageMapping
    │              ├─ createSourceFileView()
    │              └─ writeSourceFileView()
    │
    ├─ reportMain()
    │      └─ CodeCoverageTool::run(Report)
    │              ├─ load()
    │              └─ CoverageReport::render()
    │
    └─ exportMain()
           └─ CodeCoverageTool::run(Export)
                   ├─ load()
                   ├─ CoverageExporterJson
                   └─ CoverageExporterLcov
```

### データフロー図

```
[入力]                         [処理]                              [出力]

object (ELF/MachO)     ───▶ CoverageMapping読込    ───┐
                                                       │
.profdata              ───▶ プロファイル読込        ───┼──▶ カバレッジ構築 ───▶ レポート
                                                       │
source files           ───▶ ソース読込（show）      ───┘                        ├─ text
                                                                                 ├─ html
                                                                                 ├─ json
                                                                                 └─ lcov
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-cov.cpp | `llvm/tools/llvm-cov/` | ソース | メインエントリーポイント |
| CodeCoverage.cpp | `llvm/tools/llvm-cov/` | ソース | 主要機能実装 |
| CoverageReport.cpp | `llvm/tools/llvm-cov/` | ソース | レポート生成 |
| SourceCoverageView.cpp | `llvm/tools/llvm-cov/` | ソース | ソースビュー生成 |
| SourceCoverageViewText.cpp | `llvm/tools/llvm-cov/` | ソース | テキスト形式出力 |
| SourceCoverageViewHTML.cpp | `llvm/tools/llvm-cov/` | ソース | HTML形式出力 |
| CoverageExporterJson.cpp | `llvm/tools/llvm-cov/` | ソース | JSONエクスポート |
| CoverageExporterLcov.cpp | `llvm/tools/llvm-cov/` | ソース | LCOVエクスポート |
| CoverageSummaryInfo.cpp | `llvm/tools/llvm-cov/` | ソース | サマリー情報 |
| CoverageFilters.cpp | `llvm/tools/llvm-cov/` | ソース | フィルタ処理 |
| gcov.cpp | `llvm/tools/llvm-cov/` | ソース | gcov互換処理 |
| TestingSupport.cpp | `llvm/tools/llvm-cov/` | ソース | テスト用変換 |
