# 機能設計書 44-llvm-lto

## 概要

本ドキュメントは、LLVM llvm-ltoツールの機能設計を記述したものである。llvm-ltoはLink Time Optimization（LTO）を実行するためのコマンドラインツールである。

### 本機能の処理概要

llvm-ltoは、複数のLLVMビットコードファイルをリンクし、リンク時最適化を適用してオブジェクトファイルを生成するツールである。従来のLTOインターフェース（libLTO）を使用し、ThinLTOモードもサポートする。

**業務上の目的・背景**：Link Time Optimization（LTO）は、コンパイル時には不可能なプログラム全体を見渡した最適化を可能にする技術である。llvm-ltoは、この強力な最適化機能をコマンドラインから直接利用することを可能にし、ビルドシステム開発者やテストエンジニアがLTO機能を検証・利用するための手段を提供する。

**機能の利用シーン**：
- 複数のビットコードファイルをリンクしてLTO最適化を適用する場合
- ThinLTOのインデックス生成やバックエンドコンパイルをテストする場合
- LTOモジュールのシンボル情報を確認する場合
- LTOワークフローをデバッグする場合

**主要な処理内容**：
1. 複数のLLVMビットコードファイルの読み込み
2. モジュールのリンク（シンボル解決）
3. 全体最適化の適用（インライン展開、定数伝播など）
4. ThinLTO固有の処理（インデックス生成、分散コンパイル等）
5. ネイティブコード生成

**関連システム・外部連携**：
- LLDリンカとの連携
- Clangのフロントエンドとの連携
- ThinLTOバックエンドコンパイラとの連携

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | オプション指定とLTO実行 |

## 機能種別

コンパイル処理 / リンク処理 / 最適化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input files | string[] | Yes | 入力ビットコードファイル | ファイル存在チェック |
| -o | string | No | 出力ファイル名 | 書き込み可能パス |
| -O | char | No | 最適化レベル（0-3、デフォルト2） | 有効な範囲 |
| --thinlto | bool | No | ThinLTOモードを有効化 | - |
| --thinlto-action | enum | No | ThinLTO操作種別 | 有効なアクション |
| --exported-symbol | string[] | No | エクスポートするシンボル | - |
| -j | unsigned | No | バックエンドスレッド数 | 正の整数 |

### 入力データソース

- LLVMビットコードファイル（.bc）
- アーカイブファイル（.a）
- ThinLTOインデックスファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | binary | ネイティブオブジェクト |
| ThinLTOインデックス | binary | サマリーインデックス |
| リンク済みモジュール | bitcode | 中間ビットコード（オプション） |

### 出力先

- 指定された出力ファイル
- ThinLTO分散モードでは複数ファイル

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプションとモードの判定
2. 入力ファイルの読み込み
   └─ LTOModuleによるビットコード解析
3. モードに応じた処理分岐
   └─ 通常LTO / ThinLTOアクション
4. シンボル解決とリンク
   └─ エクスポートシンボルの設定
5. 最適化の実行
   └─ 全体最適化パイプライン
6. コード生成
   └─ ネイティブコードへの変換
7. 出力
   └─ オブジェクトファイル書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{モード判定}
    B -->|通常LTO| C[LTOCodeGenerator作成]
    B -->|ThinLTO| D[ThinLTOCodeGenerator作成]
    C --> E[モジュール読込]
    D --> F{ThinLTOアクション}
    F -->|thinlink| G[インデックス生成]
    F -->|distributedindexes| H[分散インデックス生成]
    F -->|promote/import| I[モジュール処理]
    F -->|run| J[フルThinLTO実行]
    E --> K[シンボル解決]
    K --> L[最適化実行]
    L --> M[コード生成]
    M --> N[出力]
    G --> N
    H --> N
    I --> N
    J --> N
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | シンボル可視性 | --exported-symbolで明示的に指定されたシンボルのみエクスポート | シンボル指定時 |
| BR-44-02 | 最適化レベル | デフォルトの最適化レベルは-O2 | 常時 |
| BR-44-03 | ThinLTOインデックス | ThinLTOアクションでは--thinlto-indexが必要な場合がある | 特定アクション時 |

### 計算ロジック

- インライン展開判断: コスト分析に基づく
- デッドコード除去: 到達可能性分析
- 定数伝播: データフロー分析

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | 入力ファイルが存在しない | ファイルパスを確認 |
| - | 形式不正 | ビットコード形式でない | 正しいビットコードを入力 |
| - | シンボル未定義 | エクスポートシンボルが見つからない | シンボル名を確認 |
| - | 検証失敗 | モジュール検証でエラー | ソースを修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 並列バックエンドコンパイル（-jオプション）
- ThinLTOによるインクリメンタルコンパイルサポート
- キャッシュによる再コンパイル回避

## セキュリティ考慮事項

- 入力ビットコードの検証
- 一時ファイルの安全な管理

## 備考

- llvm-ltoは主にテストおよび開発用途で使用される
- プロダクション環境ではLLDリンカのLTO機能を直接使用することが推奨される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LTO処理に関わる主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LTOModule.h | `llvm/include/llvm/LTO/legacy/LTOModule.h` | LTOモジュール構造 |
| 1-2 | LTOCodeGenerator.h | `llvm/include/llvm/LTO/legacy/LTOCodeGenerator.h` | コード生成インターフェース |
| 1-3 | ThinLTOCodeGenerator.h | `llvm/include/llvm/LTO/legacy/ThinLTOCodeGenerator.h` | ThinLTO生成インターフェース |

**読解のコツ**: LTOModuleは単一のビットコードファイルを、LTOCodeGeneratorはLTOコンパイル全体を管理する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-lto.cpp | `llvm/tools/llvm-lto/llvm-lto.cpp` | メイン関数 |

**主要処理フロー**:
1. **66-72行目**: LTOCategory定義と最適化レベルオプション
2. **94-133行目**: ThinLTOモードとアクション定義
3. **199-206行目**: 入力ファイルと出力ファイルオプション
4. **274-292行目**: 診断ハンドラ
5. **350-366行目**: getLocalLTOModule()関数

#### Step 3: ThinLTOアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-lto.cpp | `llvm/tools/llvm-lto/llvm-lto.cpp` | ThinLTOアクション実装 |

**主要処理フロー**:
- **99-109行目**: ThinLTOModes列挙型定義
- **111-133行目**: thinlto-action オプション定義

### プログラム呼び出し階層図

```
main()
    │
    ├─ 診断ハンドラ設定
    │
    ├─ testLTOModule() ─────▶ シンボル一覧表示
    │
    ├─ printIndexStats() ───▶ インデックス統計
    │
    ├─ LTOCodeGenerator処理
    │      ├─ getLocalLTOModule()
    │      ├─ addModule()
    │      ├─ setExportedSymbol()
    │      ├─ optimize()
    │      └─ compile()
    │
    └─ ThinLTOCodeGenerator処理
           ├─ ThinLink (インデックス生成)
           ├─ DistributedIndexes (分散インデックス)
           ├─ Promote / Import / Internalize
           ├─ Optimize
           ├─ CodeGen
           └─ Run (フル実行)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

file1.bc     ───┐
file2.bc     ───┼───▶ LTOCodeGenerator     ───┐
file3.bc     ───┘      または                  │
                       ThinLTOCodeGenerator  ───┼──▶ output.o
                                               │
--exported-symbol ───▶ シンボル可視性設定      │
                                               │
-O2          ───▶ 最適化レベル設定   ─────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-lto.cpp | `llvm/tools/llvm-lto/` | ソース | メインエントリーポイント |
| LTOModule.h | `llvm/include/llvm/LTO/legacy/` | ヘッダ | LTOモジュールインターフェース |
| LTOModule.cpp | `llvm/lib/LTO/` | ソース | LTOモジュール実装 |
| LTOCodeGenerator.h | `llvm/include/llvm/LTO/legacy/` | ヘッダ | コード生成インターフェース |
| LTOCodeGenerator.cpp | `llvm/lib/LTO/` | ソース | コード生成実装 |
| ThinLTOCodeGenerator.h | `llvm/include/llvm/LTO/legacy/` | ヘッダ | ThinLTO生成インターフェース |
| ThinLTOCodeGenerator.cpp | `llvm/lib/LTO/` | ソース | ThinLTO生成実装 |
| lto.h | `llvm/include/llvm-c/` | ヘッダ | C API定義 |
