# 機能設計書 45-llvm-lto2

## 概要

本ドキュメントは、LLVM llvm-lto2ツールの機能設計を記述したものである。llvm-lto2は解像度ベースの新しいLTOインターフェースを使用したLink Time Optimizationツールである。

### 本機能の処理概要

llvm-lto2は、llvm-ltoの後継として設計されたLTOツールである。新しい解像度ベースのLTOインターフェース（lto::LTO）を使用し、シンボル解決をより明示的に制御できる。主にLTOインターフェースのテストハーネスとして使用される。

**業務上の目的・背景**：従来のllvm-ltoが使用するlegacy LTOインターフェースには、シンボル解決の制御が不十分という課題があった。llvm-lto2は、各シンボルに対して明示的な解決指定（prevailing、local、visible等）を行うことで、より精密なLTO制御を可能にする。

**機能の利用シーン**：
- 新しいLTOインターフェースの機能をテストする場合
- シンボル解決を明示的に制御したLTOを実行する場合
- Unified LTO機能を検証する場合
- DTLTO（Distributed ThinLTO）機能をテストする場合

**主要な処理内容**：
1. run: シンボル解決を指定してLTO実行
2. dump-symtab: シンボルテーブルをダンプ
3. print-guid: シンボルのGUIDを出力

**関連システム・外部連携**：
- LLDリンカのLTO実装との互換性検証
- ThinLTOバックエンドとの連携
- DTLTO分散コンパイラとの連携

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | サブコマンドとオプション指定 |

## 機能種別

コンパイル処理 / リンク処理 / テスト支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| サブコマンド | string | Yes | run/dump-symtab/print-guid | 有効なサブコマンド |
| input files | string[] | Yes | 入力ビットコードファイル | ファイル存在チェック |
| -o | string | Yes（run時） | 出力ファイル名 | 書き込み可能パス |
| -r | string[] | Yes（run時） | シンボル解決指定 | filename,symbol,resolution形式 |
| -O | char | No | 最適化レベル（デフォルト2） | 0-3の範囲 |
| --thinlto-threads | string | No | ThinLTOスレッド数 | 数値またはall |

### 入力データソース

- LLVMビットコードファイル（.bc）
- シンボル解決指定（-rオプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | binary | output.0, output.1, ... の形式 |
| シンボルテーブル | text | dump-symtab時 |
| GUID | text | print-guid時 |

### 出力先

- 指定された出力ファイル（タスク番号がサフィックスとして付加）
- 標準出力（dump-symtab、print-guid時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ サブコマンドとオプションの識別
2. サブコマンドに応じた処理分岐
   └─ run / dump-symtab / print-guid
3. run時: シンボル解決の解析
   └─ -rオプションのパース
4. LTOオブジェクトの作成と設定
   └─ lto::LTO インスタンス生成
5. 入力ファイルの追加
   └─ シンボル解決の適用
6. LTO実行
   └─ 最適化とコード生成
7. 出力ファイルの生成
   └─ タスクごとのオブジェクト出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{サブコマンド判定}
    B -->|run| C[run関数]
    B -->|dump-symtab| D[dumpSymtab関数]
    B -->|print-guid| E[GUID出力]
    C --> F[シンボル解決パース]
    F --> G[LTO Config設定]
    G --> H[LTOインスタンス作成]
    H --> I[入力ファイル追加]
    I --> J[シンボル解決適用]
    J --> K[Lto.run実行]
    K --> L[出力ファイル生成]
    D --> M[シンボル情報出力]
    E --> N[GUID計算・出力]
    L --> O[終了]
    M --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | シンボル解決必須 | 各シンボルに対して解決指定が必要 | run時 |
| BR-45-02 | 解決形式 | p=prevailing, l=local, x=visible, r=redefined | -r オプション |
| BR-45-03 | 出力命名 | 出力ファイルは output.0, output.1 の形式 | run時 |

### 計算ロジック

- GUID計算: GlobalValue::getGUIDAssumingExternalLinkage()
- シンボル解決: filename,symbolname,resolution の形式でパース

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 解決未指定 | シンボルに対する解決がない | -rオプションを追加 |
| - | 解決未使用 | 指定した解決が使用されなかった | 不要な-rを削除 |
| - | 形式不正 | -rオプションの形式が不正 | 形式を修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ThinLTOの並列バックエンドコンパイル
- heavyweight_hardware_concurrencyによるスレッド制御

## セキュリティ考慮事項

- 入力ビットコードの検証
- 一時ファイルの安全な管理

## 備考

- llvm-lto2はllvm-ltoの後継として設計されたが、主にテスト用途で使用
- 実際のリンクではLLDが同等の機能を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

新しいLTOインターフェースのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LTO.h | `llvm/include/llvm/LTO/LTO.h` | lto::LTOクラスとConfig |
| 1-2 | Config.h | `llvm/include/llvm/LTO/Config.h` | LTO設定構造 |

**読解のコツ**: lto::LTOはlegacy LTOCodeGeneratorの後継であり、より柔軟なシンボル解決制御を提供する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-lto2.cpp | `llvm/tools/llvm-lto2/llvm-lto2.cpp` | メイン関数 |

**主要処理フロー**:
1. **40-56行目**: オプション定義（OptLevel、InputFilenames等）
2. **134-145行目**: SymbolResolutionsオプション（-r）
3. **277-280行目**: usage()関数
4. **282-524行目**: run()関数
5. **526-624行目**: dumpSymtab()関数
6. **626-657行目**: main()関数

#### Step 3: シンボル解決処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-lto2.cpp | `llvm/tools/llvm-lto2/llvm-lto2.cpp` | シンボル解決パース |

**主要処理フロー**:
- **301-327行目**: シンボル解決文字列のパース
- **309-323行目**: 解決フラグ（p/l/x/r）の解析

### プログラム呼び出し階層図

```
main()
    │
    ├─ usage() ───────────▶ 使用方法表示
    │
    ├─ dumpSymtab()
    │      └─ InputFile::create()
    │              └─ シンボル情報出力
    │
    ├─ run()
    │      ├─ CommandLineResolutionsパース
    │      ├─ Config設定
    │      ├─ ThinBackend選択
    │      │      ├─ createWriteIndexesThinBackend
    │      │      ├─ createOutOfProcessThinBackend (DTLTO)
    │      │      └─ createInProcessThinBackend
    │      ├─ LTO(Config, Backend)
    │      ├─ InputFile::create()
    │      ├─ Lto.add() + 解決適用
    │      └─ Lto.run()
    │
    └─ print-guid ───────▶ GlobalValue::getGUIDAssumingExternalLinkage()
```

### データフロー図

```
[入力]                         [処理]                              [出力]

file.bc          ───┐
                    │
-r file,sym,plx  ───┼───▶ lto::LTO        ───▶ コンパイル ───▶ output.0
                    │        + Config              │            output.1
-O2              ───┘        + Backend    ─────────┘            ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-lto2.cpp | `llvm/tools/llvm-lto2/` | ソース | メインエントリーポイント |
| LTO.h | `llvm/include/llvm/LTO/` | ヘッダ | 新LTOインターフェース |
| LTO.cpp | `llvm/lib/LTO/` | ソース | 新LTO実装 |
| Config.h | `llvm/include/llvm/LTO/` | ヘッダ | LTO設定 |
| InputFile.h | `llvm/include/llvm/LTO/` | ヘッダ | 入力ファイル抽象化 |
