# 機能設計書 46-llvm-jitlink

## 概要

本ドキュメントは、LLVM llvm-jitlinkツールの機能設計を記述したものである。llvm-jitlinkはJITLinkライブラリのコマンドラインインターフェースであり、リロケータブルオブジェクトファイルをメモリ上で実行可能にするツールである。

### 本機能の処理概要

llvm-jitlinkは、オブジェクトファイル（ELF、MachO、COFF）をメモリにロードし、リンクして実行するJITリンカである。主にJITLinkライブラリのテストユーティリティとして機能するが、リンク結果の検証やデバッグにも使用される。

**業務上の目的・背景**：Just-In-Time（JIT）コンパイル環境では、動的に生成されたオブジェクトコードをメモリ上で実行可能にする必要がある。llvm-jitlinkは、LLVMのJITLinkライブラリが提供するこの機能をテスト・検証するための手段を提供し、JITコンパイラ開発者がリンク処理の正確性を確認できるようにする。

**機能の利用シーン**：
- JITLinkライブラリの機能をテストする場合
- オブジェクトファイルのリンク動作を検証する場合
- JITリンクのパフォーマンスを測定する場合
- ORC（On-Request Compilation）ランタイムとの統合をテストする場合

**主要な処理内容**：
1. オブジェクトファイルの読み込み（ELF/MachO/COFF）
2. シンボル解決とリロケーション処理
3. メモリへのコード配置
4. エントリーポイントの実行（オプション）
5. 検証チェックの実行（オプション）

**関連システム・外部連携**：
- ORC JITランタイムとの連携
- デバッガサポート（gdb/lldb）
- パフォーマンスプロファイラ（perf/VTune）

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | オプション指定とリンク実行 |

## 機能種別

リンク処理 / 実行処理 / テスト支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input files | string[] | Yes | 入力オブジェクトファイル | ファイル存在チェック |
| --entry | string | No | エントリーポイント関数名 | - |
| -L | string[] | No | ライブラリ検索パス | ディレクトリ存在チェック |
| -l | string[] | No | リンクするライブラリ | - |
| --check | string[] | No | 検証チェックファイル | ファイル存在チェック |
| --noexec | bool | No | 実行せずにリンクのみ | - |
| --orc-runtime | string | No | ORCランタイムパス | ファイル存在チェック |

### 入力データソース

- オブジェクトファイル（ELF/MachO/COFF形式）
- 動的ライブラリ
- 検証チェックファイル
- ORCランタイムライブラリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | int | プログラムの終了コード |
| リンクグラフ | text | --show-graphsで表示 |
| アドレス情報 | text | --show-addrsで表示 |
| シンボルテーブル | text | --write-symtabで出力 |

### 出力先

- 標準出力（ログ、アドレス情報等）
- 標準エラー出力（エラーメッセージ）
- 指定ファイル（シンボルテーブル）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプションと入力ファイルの識別
2. ExecutionSessionの作成
   └─ JITDylib設定
3. オブジェクトファイルの読み込み
   └─ 各形式に応じたパース
4. リンクグラフの構築
   └─ シンボルとセクションの関係構築
5. シンボル解決
   └─ 外部シンボルの解決
6. リロケーション適用
   └─ アドレス修正
7. メモリ保護設定
   └─ 実行可能権限の設定
8. 検証チェック（オプション）
   └─ チェック式の評価
9. エントリーポイント実行（オプション）
   └─ main関数等の呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[Session作成]
    C --> D[オブジェクトファイル読込]
    D --> E[リンクグラフ構築]
    E --> F[シンボル解決]
    F --> G[リロケーション適用]
    G --> H{--noexec?}
    H -->|Yes| I[リンク結果のみ]
    H -->|No| J{--check指定?}
    J -->|Yes| K[検証チェック実行]
    J -->|No| L[エントリーポイント実行]
    K --> M{チェック成功?}
    M -->|Yes| L
    M -->|No| N[エラー終了]
    I --> O[終了]
    L --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | エントリー命名 | デフォルトのエントリーポイントはmain（指定可能） | 実行時 |
| BR-46-02 | JITDylib管理 | --jdで明示的にJITDylibを指定可能 | 複数ライブラリ時 |
| BR-46-03 | 遅延リンク | --lazyで遅延リンクを有効化 | パフォーマンス最適化時 |

### 計算ロジック

- シンボル解決: JITDylib内のシンボルルックアップ
- リロケーション: ターゲットアーキテクチャに依存した計算

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（メモリ上での処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | オブジェクトファイルが存在しない | ファイルパスを確認 |
| - | 形式不正 | サポートされない形式 | 正しい形式のファイルを使用 |
| - | シンボル未定義 | 外部シンボルが解決できない | ライブラリを追加 |
| - | チェック失敗 | 検証チェックが失敗 | 実装を修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- マテリアライゼーションスレッドによる並列処理
- スラブアロケータによる効率的メモリ管理

## セキュリティ考慮事項

- メモリ保護の適切な設定
- 信頼できないコードの実行に注意

## 備考

- JITLinkはRuntimeDyldの後継ライブラリ
- ORC JITフレームワークと統合

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JITLink処理に関わる主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-jitlink.h | `llvm/tools/llvm-jitlink/llvm-jitlink.h` | Session構造定義 |
| 1-2 | JITLink.h | `llvm/include/llvm/ExecutionEngine/JITLink/JITLink.h` | LinkGraph構造 |

**読解のコツ**: SessionはExecutionSessionとJITDylibを管理し、LinkGraphはリンク単位のシンボルとセクション情報を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-jitlink.cpp | `llvm/tools/llvm-jitlink/llvm-jitlink.cpp` | メイン関数 |

**主要処理フロー**:
1. **87-91行目**: JITLinkCategory定義
2. **89-95行目**: InputFilesオプション
3. **175-176行目**: NoExecオプション
4. **314-316行目**: OrcRuntimeオプション

#### Step 3: 形式別リンク処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-jitlink-elf.cpp | `llvm/tools/llvm-jitlink/` | ELFリンク処理 |
| 3-2 | llvm-jitlink-macho.cpp | `llvm/tools/llvm-jitlink/` | MachOリンク処理 |
| 3-3 | llvm-jitlink-coff.cpp | `llvm/tools/llvm-jitlink/` | COFFリンク処理 |

### プログラム呼び出し階層図

```
main()
    │
    ├─ Session作成
    │      ├─ ExecutionSession
    │      └─ ObjectLinkingLayer
    │
    ├─ オブジェクト読込
    │      ├─ loadLinkableFile()
    │      └─ LinkGraph構築
    │
    ├─ シンボル解決
    │      ├─ JITDylib::lookup()
    │      └─ EPCDynamicLibrarySearchGenerator
    │
    ├─ 検証チェック
    │      └─ RuntimeDyldChecker互換チェック
    │
    └─ 実行
           └─ エントリーポイント呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

.o / .a files   ───▶ ObjectLinkingLayer    ───┐
                                               │
-l libraries    ───▶ シンボル解決            ───┼──▶ メモリ上実行 ───▶ 終了コード
                                               │
--orc-runtime   ───▶ ORC Platform設定        ───┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-jitlink.cpp | `llvm/tools/llvm-jitlink/` | ソース | メインエントリーポイント |
| llvm-jitlink.h | `llvm/tools/llvm-jitlink/` | ヘッダ | Session定義 |
| llvm-jitlink-elf.cpp | `llvm/tools/llvm-jitlink/` | ソース | ELFサポート |
| llvm-jitlink-macho.cpp | `llvm/tools/llvm-jitlink/` | ソース | MachOサポート |
| llvm-jitlink-coff.cpp | `llvm/tools/llvm-jitlink/` | ソース | COFFサポート |
| llvm-jitlink-statistics.cpp | `llvm/tools/llvm-jitlink/` | ソース | 統計情報 |
| llvm-jitlink-executor.cpp | `llvm/tools/llvm-jitlink/llvm-jitlink-executor/` | ソース | 外部実行器 |
