# 機能設計書 47-llvm-rtdyld

## 概要

本ドキュメントは、LLVM llvm-rtdyldツールの機能設計を記述したものである。llvm-rtdyldはRuntimeDyldライブラリのテストおよびベンチマークツールである。

### 本機能の処理概要

llvm-rtdyldは、MC-JIT（Machine Code Just-In-Time）コンポーネントのテストツールである。オブジェクトファイルを動的にロード・リンクし、メモリ上で実行する機能を提供する。主にRuntimeDyldライブラリの検証に使用される。

**業務上の目的・背景**：JITコンパイル環境では、生成されたオブジェクトコードを動的にリンクしてメモリ上で実行する必要がある。llvm-rtdyldは、LLVMのRuntimeDyldライブラリが提供するこの機能をテスト・検証するための手段を提供し、JITコンパイラ開発者がリンク処理の正確性を確認できるようにする。

**機能の利用シーン**：
- RuntimeDyldライブラリの機能をテストする場合
- オブジェクトファイルの動的リンク動作を検証する場合
- 行番号情報やデバッグ情報の処理を確認する場合
- リロケーション処理の正確性を検証する場合

**主要な処理内容**：
1. execute: オブジェクトファイルをロード、リンク、実行
2. printline: リンク後の行番号情報を表示
3. printdebugline: デバッグオブジェクト経由で行番号情報を表示
4. printobjline: ロードせずに行番号情報を表示
5. verify: メモリイメージの正確性を検証

**関連システム・外部連携**：
- MC-JITエンジンとの連携
- DWARF デバッグ情報との連携
- RuntimeDyldCheckerによる検証

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | アクションとオプション指定 |

## 機能種別

リンク処理 / 実行処理 / テスト支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| アクション | enum | No | execute/printline/verify等（デフォルト: execute） | 有効なアクション |
| input files | string[] | Yes | 入力オブジェクトファイル | ファイル存在チェック |
| --entry | string | No | エントリーポイント（デフォルト: _main） | - |
| --dylib | string[] | No | 動的ライブラリ | ファイル存在チェック |
| --check | string[] | No | 検証チェックファイル | ファイル存在チェック |
| --triple | string | No | ターゲットトリプル | - |
| --preallocate | uint64 | No | 事前割り当てメモリサイズ | 正の整数 |

### 入力データソース

- オブジェクトファイル
- 動的ライブラリ
- 検証チェックファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | int | プログラムの終了コード |
| 行番号情報 | text | printlineモードで出力 |
| 検証結果 | bool | verifyモードの結果 |

### 出力先

- 標準出力（行番号情報等）
- 標準エラー出力（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ アクションとオプションの識別
2. 動的ライブラリのロード
   └─ --dylibで指定されたライブラリ
3. メモリマネージャの初期化
   └─ TrivialMemoryManager作成
4. RuntimeDyldの作成
   └─ リンカインスタンス生成
5. オブジェクトファイルの読み込みとロード
   └─ Dyld.loadObject()
6. リロケーション解決
   └─ Dyld.resolveRelocations()
7. アクションに応じた処理
   └─ 実行/表示/検証
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[動的ライブラリロード]
    C --> D[MemoryManager作成]
    D --> E[RuntimeDyld作成]
    E --> F{アクション判定}
    F -->|execute| G[オブジェクトロード]
    F -->|printline| H[行番号情報処理]
    F -->|verify| I[検証処理]
    G --> J[リロケーション解決]
    J --> K[メモリ保護設定]
    K --> L[エントリーポイント実行]
    H --> M[DWARFContext作成]
    M --> N[行番号情報出力]
    I --> O[チェックファイル読込]
    O --> P[RuntimeDyldChecker実行]
    P --> Q{検証成功?}
    Q -->|Yes| R[成功終了]
    Q -->|No| S[エラー終了]
    L --> R
    N --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | エントリーデフォルト | デフォルトのエントリーポイントは_main | execute時 |
| BR-47-02 | トリプル必須 | --verifyモードでは--tripleが必須 | verify時 |
| BR-47-03 | 事前割り当て | --preallocateで小さなコードモデルをテスト可能 | 特定テスト時 |

### 計算ロジック

- セクション配置: ターゲットアドレス空間へのマッピング
- リロケーション: ターゲットアーキテクチャに依存した計算

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（メモリ上での処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | オブジェクトファイルが存在しない | ファイルパスを確認 |
| - | 形式不正 | オブジェクトファイル形式が不正 | 正しい形式のファイルを使用 |
| - | エントリー不在 | エントリーポイントが見つからない | エントリー名を確認 |
| - | チェック失敗 | 検証チェックが失敗 | 実装を修正 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- タイマーによる処理時間計測（--show-times）
- 効率的なメモリ割り当て

## セキュリティ考慮事項

- メモリ保護の適切な設定
- 実行権限の管理

## 備考

- RuntimeDyldはJITLinkに置き換えられつつある（レガシー）
- 主にテスト目的で使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RuntimeDyld処理に関わる主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RuntimeDyld.h | `llvm/include/llvm/ExecutionEngine/RuntimeDyld.h` | RuntimeDyldインターフェース |
| 1-2 | RTDyldMemoryManager.h | `llvm/include/llvm/ExecutionEngine/RTDyldMemoryManager.h` | メモリ管理インターフェース |

**読解のコツ**: RuntimeDyldはオブジェクトのロードとリロケーション解決を担当し、RTDyldMemoryManagerはメモリ割り当てを管理する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-rtdyld.cpp | `llvm/tools/llvm-rtdyld/llvm-rtdyld.cpp` | メイン関数 |

**主要処理フロー**:
1. **47-51行目**: RTDyldCategory定義とInputFileListオプション
2. **53-75行目**: ActionType列挙型定義
3. **77-79行目**: EntryPointオプション（デフォルト_main）
4. **189-291行目**: TrivialMemoryManagerクラス
5. **409-532行目**: printLineInfoForInput()関数
6. **545-629行目**: executeInput()関数
7. **777-1016行目**: linkAndVerify()関数
8. **1018-1055行目**: main()関数

#### Step 3: メモリ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-rtdyld.cpp | `llvm/tools/llvm-rtdyld/llvm-rtdyld.cpp` | TrivialMemoryManager |

**主要処理フロー**:
- **189-291行目**: TrivialMemoryManagerクラス定義
- **293-318行目**: allocateCodeSection()
- **321-348行目**: allocateDataSection()

### プログラム呼び出し階層図

```
main()
    │
    ├─ loadDylibs() ─────────▶ 動的ライブラリロード
    │
    ├─ executeInput()
    │      ├─ TrivialMemoryManager()
    │      ├─ RuntimeDyld(MemMgr)
    │      ├─ Dyld.loadObject()
    │      ├─ Dyld.resolveRelocations()
    │      └─ Main()呼び出し
    │
    ├─ printLineInfoForInput()
    │      ├─ RuntimeDyld.loadObject()
    │      ├─ DWARFContext::create()
    │      └─ 行番号情報出力
    │
    └─ linkAndVerify()
           ├─ RuntimeDyld(MemMgr)
           ├─ Dyld.loadObject()
           ├─ RuntimeDyldChecker作成
           └─ checkAllExpressions()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

.o files       ───▶ RuntimeDyld.loadObject()  ───┐
                                                  │
--dylib        ───▶ DynamicLibrary::Load      ───┼──▶ メモリ上実行 ───▶ 終了コード
                                                  │
--check        ───▶ RuntimeDyldChecker        ───┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-rtdyld.cpp | `llvm/tools/llvm-rtdyld/` | ソース | メインエントリーポイント |
| RuntimeDyld.h | `llvm/include/llvm/ExecutionEngine/` | ヘッダ | RuntimeDyldインターフェース |
| RuntimeDyld.cpp | `llvm/lib/ExecutionEngine/RuntimeDyld/` | ソース | RuntimeDyld実装 |
| RTDyldMemoryManager.h | `llvm/include/llvm/ExecutionEngine/` | ヘッダ | メモリ管理インターフェース |
| RuntimeDyldChecker.h | `llvm/include/llvm/ExecutionEngine/` | ヘッダ | 検証チェッカー |
