# 機能設計書 48-llvm-mca

## 概要

本ドキュメントは、LLVM llvm-mcaツールの機能設計を記述したものである。llvm-mcaはMachine Code Analyzer（マシンコード解析器）であり、CPUパイプラインのシミュレーションを通じてコードの性能特性を分析する。

### 本機能の処理概要

llvm-mcaは、アセンブリコードの性能特性を静的に分析するツールである。Intel IACA（Intel Architecture Code Analyzer）と同様の機能を提供し、命令のスケジューリング、リソース使用率、ボトルネック分析などの情報を出力する。

**業務上の目的・背景**：高性能コンピューティングや組み込みシステム開発において、コードの性能を最大化することは重要な課題である。llvm-mcaは、実際に実行することなく、ターゲットCPUのスケジューリングモデルに基づいてコードの性能特性を予測し、最適化の指針を提供する。

**機能の利用シーン**：
- アセンブリコードの性能をシミュレーションで予測する場合
- 命令レベルの並列性やリソース競合を分析する場合
- コンパイラが生成したコードのボトルネックを特定する場合
- CPUスケジューリングモデルの精度を検証する場合

**主要な処理内容**：
1. アセンブリコードの解析とMCInst列への変換
2. パイプラインシミュレーションの実行
3. リソース使用率、IPC、ボトルネックなどの統計計算
4. 各種ビュー（サマリー、タイムライン、リソース圧力等）の出力

**関連システム・外部連携**：
- LLVMのターゲット記述（TableGen）スケジューリングモデル
- アセンブラパーサー

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | オプション指定と分析実行 |

## 機能種別

性能分析処理 / シミュレーション処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input file | string | Yes | 入力アセンブリファイル | ファイル存在チェック |
| -mcpu | string | No | ターゲットCPU（デフォルト: native） | 有効なCPU名 |
| -mtriple | string | No | ターゲットトリプル | 有効なトリプル |
| -march | string | No | ターゲットアーキテクチャ | 有効なアーキテクチャ |
| -iterations | unsigned | No | シミュレーション反復回数 | 正の整数 |
| -o | string | No | 出力ファイル（デフォルト: stdout） | 書き込み可能パス |

### 入力データソース

- アセンブリソースファイル（.s）
- 標準入力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| サマリービュー | text/json | IPC、反復サイクル数など |
| 命令情報ビュー | text/json | 各命令のレイテンシ、スループット |
| タイムラインビュー | text | 命令のパイプライン進行状況 |
| リソース圧力ビュー | text/json | リソース使用率 |
| ボトルネック分析 | text | ボトルネック要因の特定 |

### 出力先

- 標準出力（デフォルト）
- 指定されたファイル

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ ターゲット、オプションの設定
2. 入力ファイルの読み込みと解析
   └─ アセンブリパーサーによるMCInst変換
3. 解析領域の特定
   └─ LLVM-MCA-BEGIN/ENDマーカー
4. パイプラインの構築
   └─ スケジューラ、ディスパッチャ等
5. シミュレーション実行
   └─ 指定回数の反復実行
6. 統計情報の収集
   └─ 各種メトリクスの計算
7. 結果の出力
   └─ 各ビューの生成と出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C[ターゲット初期化]
    C --> D[アセンブリ読込・解析]
    D --> E[解析領域特定]
    E --> F{命令テーブルモード?}
    F -->|Yes| G[命令テーブル生成]
    F -->|No| H[パイプライン構築]
    H --> I[シミュレーション実行]
    I --> J[統計情報収集]
    G --> K[結果出力]
    J --> K
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | CPU自動検出 | -mcpu=nativeでホストCPUを自動検出 | デフォルト時 |
| BR-48-02 | スケジュールモデル必須 | ターゲットCPUはInstrSchedModelを持つ必要がある | 常時 |
| BR-48-03 | 領域マーカー | LLVM-MCA-BEGIN/ENDで解析範囲を指定可能 | オプション |

### 計算ロジック

- IPC (Instructions Per Cycle): 命令数 / サイクル数
- スループット: 各命令の逆スループット（サイクル/命令）
- レイテンシ: 命令の実行遅延サイクル数

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（シミュレーション処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ターゲット不在 | 指定されたターゲットが見つからない | 有効なターゲットを指定 |
| - | スケジュールモデル不在 | CPUにスケジュールモデルがない | 対応CPUを使用 |
| - | 解析エラー | アセンブリのパースに失敗 | 構文を修正 |
| - | 命令未対応 | サポートされない命令 | --skip-unsupported-instructionsを使用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 大量の命令シーケンスの高速シミュレーション
- 効率的なパイプラインモデリング

## セキュリティ考慮事項

- 入力ファイルの検証

## 備考

- Intel IACAの代替として開発
- アウトオブオーダー/インオーダー両方のCPUモデルをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MCA処理に関わる主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pipeline.h | `llvm/include/llvm/MCA/Pipeline.h` | パイプライン構造 |
| 1-2 | Instruction.h | `llvm/include/llvm/MCA/Instruction.h` | 命令表現 |
| 1-3 | Context.h | `llvm/include/llvm/MCA/Context.h` | 実行コンテキスト |

**読解のコツ**: Pipelineは複数のStageで構成され、各Stageが命令処理の一段階を担当する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-mca.cpp | `llvm/tools/llvm-mca/llvm-mca.cpp` | メイン関数 |

**主要処理フロー**:
1. **68-69行目**: ToolOptions/ViewOptionsカテゴリ定義
2. **71-98行目**: 基本オプション（InputFilename、MCPU等）
3. **113-141行目**: シミュレーションオプション（Iterations等）
4. **172-265行目**: ビューオプション
5. **362-381行目**: main()関数開始とターゲット初期化
6. **627-731行目**: パイプライン構築と実行

#### Step 3: ビュー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SummaryView.cpp | `llvm/tools/llvm-mca/Views/SummaryView.cpp` | サマリービュー |
| 3-2 | TimelineView.cpp | `llvm/tools/llvm-mca/Views/TimelineView.cpp` | タイムラインビュー |
| 3-3 | ResourcePressureView.cpp | `llvm/tools/llvm-mca/Views/ResourcePressureView.cpp` | リソース圧力ビュー |
| 3-4 | BottleneckAnalysis.cpp | `llvm/tools/llvm-mca/Views/BottleneckAnalysis.cpp` | ボトルネック分析 |

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitializeAllTarget*()
    │
    ├─ getTarget() ─────────▶ ターゲット取得
    │
    ├─ MCSubtargetInfo作成
    │
    ├─ AsmAnalysisRegionGenerator
    │      └─ parseAnalysisRegions()
    │
    ├─ InstrBuilder作成
    │
    ├─ mca::Context作成
    │
    └─ 各リージョンごと:
           ├─ Pipeline作成
           │      ├─ EntryStage
           │      ├─ InstructionTables (テーブルモード)
           │      └─ デフォルトパイプライン (通常モード)
           │
           ├─ PipelinePrinter
           │      ├─ SummaryView
           │      ├─ InstructionInfoView
           │      ├─ TimelineView
           │      ├─ ResourcePressureView
           │      └─ BottleneckAnalysis
           │
           ├─ Pipeline.run()
           │
           └─ Printer.printReport()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

assembly.s     ───▶ AsmParser           ───┐
                                           │
-mcpu=xxx      ───▶ MCSubtargetInfo     ───┼──▶ Pipeline ───▶ Views ───▶ レポート
                                           │     シミュレーション
-iterations    ───▶ 反復設定             ───┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-mca.cpp | `llvm/tools/llvm-mca/` | ソース | メインエントリーポイント |
| CodeRegion.cpp | `llvm/tools/llvm-mca/` | ソース | コード領域管理 |
| CodeRegionGenerator.cpp | `llvm/tools/llvm-mca/` | ソース | 領域生成 |
| PipelinePrinter.cpp | `llvm/tools/llvm-mca/` | ソース | 結果出力 |
| SummaryView.cpp | `llvm/tools/llvm-mca/Views/` | ソース | サマリービュー |
| TimelineView.cpp | `llvm/tools/llvm-mca/Views/` | ソース | タイムラインビュー |
| ResourcePressureView.cpp | `llvm/tools/llvm-mca/Views/` | ソース | リソース圧力ビュー |
| BottleneckAnalysis.cpp | `llvm/tools/llvm-mca/Views/` | ソース | ボトルネック分析 |
| InstructionInfoView.cpp | `llvm/tools/llvm-mca/Views/` | ソース | 命令情報ビュー |
| DispatchStatistics.cpp | `llvm/tools/llvm-mca/Views/` | ソース | ディスパッチ統計 |
| SchedulerStatistics.cpp | `llvm/tools/llvm-mca/Views/` | ソース | スケジューラ統計 |
