# 機能設計書 5-Clang

## 概要

本ドキュメントは、Clang（C/C++/Objective-Cフロントエンドコンパイラ）の機能設計を記述する。ClangはLLVMプロジェクトのC言語ファミリー向けフロントエンドコンパイラであり、C、C++、Objective-C、Objective-C++をサポートする。

### 本機能の処理概要

Clangは、C言語ファミリーのソースコードを解析し、LLVM中間表現（IR）を生成する。また、プリプロセス、コンパイル、アセンブル、リンクの各フェーズを統合的に制御するドライバ機能も提供する。

**業務上の目的・背景**：GCCに代わる高性能で拡張性の高いC/C++コンパイラを提供する。優れた診断メッセージ、高速なコンパイル速度、モジュール化されたアーキテクチャにより、IDE統合やソースコード解析ツールの基盤としても利用される。Apache 2.0ライセンスにより商用利用も容易である。

**機能の利用シーン**：
- C/C++/Objective-Cソースコードのコンパイル
- 静的解析とLintingツールの基盤
- IDE（Xcode, Visual Studio等）のコード補完
- ソースからソースへの変換ツール
- リファクタリングツールの基盤

**主要な処理内容**：
1. ソースファイルのプリプロセス処理
2. 字句解析と構文解析（AST生成）
3. 意味解析と型チェック
4. LLVM IR生成（コード生成）
5. ドライバによるコンパイルパイプライン制御

**関連システム・外部連携**：
- LLVM Coreとの連携（コード生成、最適化）
- LLDリンカとの連携
- libclang APIによる外部ツール連携
- clangdによるLSP連携

**権限による制御**：特になし（コマンドラインツールとして実行）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ClangはCLIツールであり、GUI画面は持たない |

## 機能種別

コンパイラフロントエンド / ドライバ / コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ソースファイル | string | Yes | 入力ソースファイル | .c/.cpp/.m/.mm等 |
| -o | string | No | 出力ファイル名 | 有効なパス |
| -c | flag | No | コンパイルのみ（リンクなし） | true/false |
| -S | flag | No | アセンブリ出力 | true/false |
| -E | flag | No | プリプロセスのみ | true/false |
| -O | char | No | 最適化レベル | 0, 1, 2, 3, s, z |
| -std | string | No | 言語標準 | c11, c++17等 |
| -target | string | No | ターゲットトリプル | 有効なトリプル |
| -I | string | No | インクルードパス | 有効なディレクトリ |
| -D | string | No | マクロ定義 | 有効な識別子 |

### 入力データソース

- Cソースファイル（.c, .h）
- C++ソースファイル（.cpp, .hpp, .cc）
- Objective-Cソースファイル（.m）
- Objective-C++ソースファイル（.mm）
- プリプロセス済みファイル（.i, .ii）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | .o | コンパイル済みオブジェクト |
| 実行ファイル | - | リンク済み実行ファイル |
| アセンブリ | .s | アセンブリ出力 |
| プリプロセス出力 | .i | プリプロセス結果 |
| LLVM IR | .ll/.bc | 中間表現 |
| 診断メッセージ | text | エラー/警告 |

### 出力先

- ファイル（-oオプションで指定）
- 標準出力（プリプロセス等）
- 標準エラー（診断メッセージ）

## 処理フロー

### 処理シーケンス

```
1. ドライバ初期化
   └─ コマンドライン解析、ターゲット検出
2. コンパイルアクション構築
   └─ フェーズ（プリプロセス/コンパイル/アセンブル/リンク）決定
3. cc1フロントエンド実行
   └─ プリプロセス → 構文解析 → 意味解析 → コード生成
4. アセンブル（必要な場合）
   └─ アセンブリからオブジェクト生成
5. リンク（必要な場合）
   └─ オブジェクトファイルのリンク
6. 結果出力
   └─ 生成物の出力と診断メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ドライバ初期化]
    B --> C[コマンドライン解析]
    C --> D{-cc1モード?}
    D -->|Yes| E[cc1_main実行]
    D -->|No| F[Compilation構築]
    E --> G[フロントエンド処理]
    F --> H[ジョブ生成]
    H --> I[ExecuteCompilation]
    G --> J{出力フェーズ}
    I --> J
    J -->|-E| K[プリプロセス出力]
    J -->|-S| L[アセンブリ出力]
    J -->|-c| M[オブジェクト出力]
    J -->|リンク| N[実行ファイル出力]
    K --> O[終了]
    L --> O
    M --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 言語推定 | 拡張子から言語を自動判定 | 明示指定なし時 |
| BR-002 | ターゲット推定 | ホストシステムがデフォルトターゲット | -target未指定時 |
| BR-003 | cc1インプロセス | -fintegrated-cc1でcc1をインプロセス実行 | オプション指定時 |
| BR-004 | 出力名決定 | 入力ファイル名から出力名を決定 | -o未指定時 |

### 計算ロジック

- ヘッダ検索パス解決：システムパス、-I指定、フレームワーク検索
- マクロ展開：プリプロセッサによるマクロ処理
- 名前解決：C++のADL、オーバーロード解決

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | Clangはデータベースを使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 構文エラー | 不正なソースコード | ソースを修正 |
| 1 | リンクエラー | シンボル未解決 | ライブラリを追加 |
| 1 | ファイルエラー | ファイルが存在しない | パスを確認 |
| 70 | 内部エラー | コンパイラのバグ | バグ報告 |

### リトライ仕様

リトライは行わない。エラー発生時は終了コードで通知。

## トランザクション仕様

Clangはデータベーストランザクションを使用しない。

## パフォーマンス要件

- 大規模プロジェクトの高速コンパイル
- プリコンパイル済みヘッダ（PCH）サポート
- モジュール（C++20 Modules）サポート

## セキュリティ考慮事項

- サンドボックスモードのサポート
- -fsanitize=による各種サニタイザ統合

## 備考

Clangは継続的に新しいC++標準のサポートを追加している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ドライバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | driver.cpp | `clang/tools/driver/driver.cpp` | ドライバエントリーポイント |

**主要処理フロー**:
1. **239-477行目**: clang_main関数 - メインエントリー
2. **268-275行目**: -cc1モードの分岐
3. **357-358行目**: Driverオブジェクト生成
4. **384行目**: BuildCompilation - コンパイルジョブ構築
5. **414行目**: ExecuteCompilation - コンパイル実行

#### Step 2: cc1フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cc1_main.cpp | `clang/tools/driver/cc1_main.cpp` | cc1エントリーポイント |

**主要処理フロー**:
- cc1_main関数
- CompilerInvocation生成
- ExecuteCompilerInvocation実行

### プログラム呼び出し階層図

```
clang_main (driver.cpp:239)
    │
    ├─ [cc1] ExecuteCC1Tool
    │      └─ cc1_main
    │             └─ ExecuteCompilerInvocation
    │                    ├─ FrontendAction
    │                    └─ CodeGen
    │
    └─ [driver] Driver::BuildCompilation
           └─ Driver::ExecuteCompilation
                  └─ Command実行（cc1呼び出し）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| driver.cpp | `clang/tools/driver/driver.cpp` | ソース | ドライバエントリー |
| cc1_main.cpp | `clang/tools/driver/cc1_main.cpp` | ソース | cc1エントリー |
| Driver.cpp | `clang/lib/Driver/Driver.cpp` | ソース | ドライバ実装 |
| Compilation.cpp | `clang/lib/Driver/Compilation.cpp` | ソース | コンパイル管理 |
| FrontendAction.cpp | `clang/lib/Frontend/FrontendAction.cpp` | ソース | フロントエンド処理 |
| CodeGenAction.cpp | `clang/lib/CodeGen/CodeGenAction.cpp` | ソース | コード生成 |
