# 機能設計書 50-llvm-xray

## 概要

本ドキュメントは、LLVM llvm-xrayツールの機能設計を記述したものである。llvm-xrayはXRayトレースデータを処理・分析するためのツールスイートである。

### 本機能の処理概要

llvm-xrayは、LLVMのXRay計装機能によって生成されたトレースデータを解析するツール群を提供する。関数呼び出しのアカウンティング、コールグラフ生成、形式変換など、多様な分析機能をサブコマンドとして実装している。

**業務上の目的・背景**：XRayはLLVMの関数計装フレームワークであり、実行時に関数の入口・出口でトレースデータを記録する。llvm-xrayは、このトレースデータを人間が読める形式に変換したり、統計分析を行ったりするための手段を提供する。パフォーマンス分析やデバッグに活用される。

**機能の利用シーン**：
- XRayトレースから関数呼び出し統計を取得する場合
- トレースデータをYAMLやChrome Trace Viewer形式に変換する場合
- 関数呼び出しグラフを生成する場合
- スタックベースの分析を行う場合
- バイナリから計装マップを抽出する場合

**主要な処理内容**：
1. account: 関数呼び出しのアカウンティング（統計）
2. convert: トレース形式の変換
3. graph: コールグラフ生成
4. stack: スタックベースの分析
5. extract: 計装マップの抽出
6. fdr-dump: FDRトレースのダンプ

**関連システム・外部連携**：
- XRayランタイムライブラリ
- シンボル情報（デバッグ情報）

**権限による制御**：特になし（ローカルファイル操作のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドライン | 主画面 | サブコマンドとオプション指定 |

## 機能種別

トレース解析処理 / 形式変換処理 / 統計処理

## 入力仕様

### 入力パラメータ

#### 共通オプション

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| サブコマンド | string | Yes | account/convert/graph/stack/extract等 | 有効なサブコマンド |

#### accountサブコマンド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input file | string | Yes | XRayトレースファイル | ファイル存在チェック |
| -output | string | No | 出力ファイル（デフォルト: stdout） | - |
| -format | enum | No | text/csv | 有効な形式 |
| -sort | enum | No | ソートフィールド（funcid/count/min/med/90p/99p/max/sum） | 有効な値 |
| -sortorder | enum | No | asc/dsc | 有効な値 |
| -top | int | No | 上位N件のみ表示 | 正の整数 |
| -instr_map | string | No | 計装マップファイル | - |

#### convertサブコマンド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input file | string | Yes | XRayトレースファイル | ファイル存在チェック |
| -output-format | enum | No | raw/yaml/trace_event | 有効な形式 |
| -output | string | No | 出力ファイル | - |
| -symbolize | bool | No | 関数IDをシンボル化 | - |

### 入力データソース

- XRayトレースファイル
- 計装マップ（バイナリまたは別ファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 統計レポート | text/csv | 関数ごとの呼び出し統計 |
| 変換済みトレース | yaml/json/binary | 変換後のトレースデータ |
| コールグラフ | DOT | Graphviz形式のグラフ |
| スタック分析 | text | スタックベースの統計 |
| 計装マップ | yaml | 抽出された計装情報 |

### 出力先

- 標準出力（デフォルト）
- 指定されたファイル

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ サブコマンドの特定
2. サブコマンドのディスパッチ
   └─ 登録されたコマンドハンドラを実行
3. 各サブコマンドの処理
   ├─ account: トレース読込 → 統計計算 → 出力
   ├─ convert: トレース読込 → 形式変換 → 出力
   ├─ graph: トレース読込 → グラフ構築 → DOT出力
   ├─ stack: トレース読込 → スタック分析 → 出力
   └─ extract: バイナリ読込 → マップ抽出 → YAML出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン解析]
    B --> C{サブコマンド判定}
    C -->|account| D[関数統計処理]
    C -->|convert| E[形式変換処理]
    C -->|graph| F[グラフ生成処理]
    C -->|stack| G[スタック分析処理]
    C -->|extract| H[マップ抽出処理]
    C -->|その他| I[ヘルプ表示]
    D --> J[トレース読込]
    J --> K[LatencyAccountant処理]
    K --> L[統計出力]
    E --> M[トレース読込]
    M --> N[TraceConverter処理]
    N --> O[変換結果出力]
    F --> P[トレース読込]
    P --> Q[GraphRenderer処理]
    Q --> R[DOT出力]
    G --> S[トレース読込]
    S --> T[CallTrie構築]
    T --> U[スタック統計出力]
    H --> V[バイナリ読込]
    V --> W[InstrumentationMap抽出]
    W --> X[YAML出力]
    L --> Y[終了]
    O --> Y
    R --> Y
    U --> Y
    X --> Y
    I --> Y
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | サブコマンド必須 | いずれかのサブコマンドを指定 | 常時 |
| BR-50-02 | 計装マップ推奨 | シンボル化には計装マップが必要 | symbolize使用時 |
| BR-50-03 | 兄弟呼び出し推定 | -deduce-sibling-callsで欠落したexit推定 | オプション |

### 計算ロジック

- レイテンシ統計: min/median/90th/99th/max/sum
- TSC→マイクロ秒変換: TSC * 10^6 / CycleFrequency
- パーセンタイル: nth_element アルゴリズム

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイル処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | トレースファイルが存在しない | ファイルパスを確認 |
| - | 形式不正 | トレースファイル形式が不正 | 正しい形式のファイルを使用 |
| - | マップ読込失敗 | 計装マップの読み込みに失敗 | バイナリパスを確認 |
| - | 出力失敗 | 出力ファイルへの書き込み失敗 | 書き込み権限を確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 大規模トレースの効率的な処理
- メモリ効率の良いスタック分析

## セキュリティ考慮事項

- 入力ファイルの検証

## 備考

- Chrome Trace Viewer形式出力によりWeb UIで可視化可能
- FlameGraph形式出力によりフレームグラフ生成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-xray.cpp | `llvm/tools/llvm-xray/llvm-xray.cpp` | メイン関数 |
| 1-2 | xray-registry.h | `llvm/tools/llvm-xray/xray-registry.h` | サブコマンド登録 |
| 1-3 | xray-registry.cpp | `llvm/tools/llvm-xray/xray-registry.cpp` | ディスパッチ実装 |

**主要処理フロー**:
1. **25-29行目**: main()関数とコマンドライン解析
2. **30-43行目**: サブコマンドのディスパッチループ
3. **xray-registry.h 29-31行目**: CommandRegistration構造体

#### Step 2: 各サブコマンドを理解する

##### accountサブコマンド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | xray-account.cpp | `llvm/tools/llvm-xray/xray-account.cpp` | 統計処理 |

**主要処理フロー**:
1. **31-34行目**: Accountサブコマンド定義
2. **56-65行目**: AccountOutputFormat（TEXT/CSV）
3. **67-90行目**: SortField列挙型
4. **160-257行目**: LatencyAccountant::accountRecord()
5. **373-407行目**: exportStatsAsText()
6. **409-417行目**: exportStatsAsCSV()
7. **445-516行目**: メイン処理（CommandRegistration）

##### convertサブコマンド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-2 | xray-converter.cpp | `llvm/tools/llvm-xray/xray-converter.cpp` | 形式変換 |

**主要処理フロー**:
1. **32-35行目**: Convertサブコマンド定義
2. **36-44行目**: ConvertFormats（BINARY/YAML/CHROME_TRACE_EVENT）
3. **87-102行目**: exportAsYAML()
4. **104-163行目**: exportAsRAWv1()
5. **274-365行目**: exportAsChromeTraceEventFormat()
6. **367-419行目**: メイン処理（CommandRegistration）

##### graphサブコマンド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-3 | xray-graph.cpp | `llvm/tools/llvm-xray/xray-graph.cpp` | グラフ生成 |

**主要処理フロー**:
- **26-29行目**: GraphCサブコマンド定義
- **60-82行目**: GraphEdgeLabelオプション（StatType列挙）

##### stackサブコマンド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-4 | xray-stacks.cpp | `llvm/tools/llvm-xray/xray-stacks.cpp` | スタック分析 |

**主要処理フロー**:
- **36-39行目**: Stackサブコマンド定義
- **77-89行目**: StackOutputFormat（HUMAN/FLAMETOOL）
- **92-95行目**: AggregationType列挙型

##### extractサブコマンド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-5 | xray-extract.cpp | `llvm/tools/llvm-xray/xray-extract.cpp` | マップ抽出 |

**主要処理フロー**:
- **32-35行目**: Extractサブコマンド定義
- **55-71行目**: exportAsYAML()
- **73-97行目**: メイン処理（CommandRegistration）

### プログラム呼び出し階層図

```
main()
    │
    ├─ cl::ParseCommandLineOptions()
    │
    └─ cl::getRegisteredSubcommands()
           │
           └─ dispatch(SC)
                  │
                  ├─ Account サブコマンド
                  │      ├─ loadInstrumentationMap()
                  │      ├─ loadTraceFile()
                  │      ├─ LatencyAccountant()
                  │      │      └─ accountRecord()
                  │      └─ exportStatsAsText/CSV()
                  │
                  ├─ Convert サブコマンド
                  │      ├─ loadInstrumentationMap()
                  │      ├─ loadTraceFile()
                  │      ├─ TraceConverter()
                  │      └─ exportAsYAML/RAW/ChromeTraceEvent()
                  │
                  ├─ Graph サブコマンド
                  │      ├─ loadInstrumentationMap()
                  │      ├─ loadTraceFile()
                  │      ├─ GraphRenderer()
                  │      └─ exportGraphAsDOT()
                  │
                  ├─ Stack サブコマンド
                  │      ├─ loadInstrumentationMap()
                  │      ├─ loadTraceFile()
                  │      ├─ CallTrie構築
                  │      └─ 統計出力
                  │
                  └─ Extract サブコマンド
                         ├─ loadInstrumentationMap()
                         └─ exportAsYAML()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

xray.log       ───▶ loadTraceFile()     ───┐
                                           │
-instr_map     ───▶ loadInstrumentationMap ─┼──▶ 各サブコマンド処理 ───▶ 結果出力
                                           │
                                           ├── LatencyAccountant ───▶ 統計レポート
                                           ├── TraceConverter    ───▶ 変換済みトレース
                                           ├── GraphRenderer     ───▶ DOTファイル
                                           └── CallTrie          ───▶ スタック分析
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-xray.cpp | `llvm/tools/llvm-xray/` | ソース | メインエントリーポイント |
| xray-registry.h | `llvm/tools/llvm-xray/` | ヘッダ | サブコマンド登録 |
| xray-registry.cpp | `llvm/tools/llvm-xray/` | ソース | ディスパッチ実装 |
| xray-account.cpp | `llvm/tools/llvm-xray/` | ソース | accountサブコマンド |
| xray-account.h | `llvm/tools/llvm-xray/` | ヘッダ | LatencyAccountant |
| xray-converter.cpp | `llvm/tools/llvm-xray/` | ソース | convertサブコマンド |
| xray-converter.h | `llvm/tools/llvm-xray/` | ヘッダ | TraceConverter |
| xray-graph.cpp | `llvm/tools/llvm-xray/` | ソース | graphサブコマンド |
| xray-graph.h | `llvm/tools/llvm-xray/` | ヘッダ | GraphRenderer |
| xray-stacks.cpp | `llvm/tools/llvm-xray/` | ソース | stackサブコマンド |
| xray-extract.cpp | `llvm/tools/llvm-xray/` | ソース | extractサブコマンド |
| xray-fdr-dump.cpp | `llvm/tools/llvm-xray/` | ソース | fdr-dumpサブコマンド |
| xray-graph-diff.cpp | `llvm/tools/llvm-xray/` | ソース | graph-diffサブコマンド |
| func-id-helper.cpp | `llvm/tools/llvm-xray/` | ソース | 関数ID変換ヘルパー |
| trie-node.h | `llvm/tools/llvm-xray/` | ヘッダ | Trie構造 |
| xray-color-helper.cpp | `llvm/tools/llvm-xray/` | ソース | 色付けヘルパー |
