# 機能設計書 51-llvm-bcanalyzer

## 概要

本ドキュメントは、LLVMプロジェクトにおけるllvm-bcanalyzerツールの機能設計を記述する。llvm-bcanalyzerは、LLVMビットコードファイル（.bc）の構造を解析し、詳細な統計情報やダンプ出力を提供するツールである。

### 本機能の処理概要

llvm-bcanalyzerは、LLVMビットコードファイルの内部構造を解析・可視化するためのコマンドラインツールである。ビットコードファイルの各ブロック、レコード、略語（abbreviation）の使用状況を詳細に分析し、開発者がビットコードの読み書きソフトウェアを開発・デバッグする際の補助ツールとして機能する。

**業務上の目的・背景**：LLVMビットコード形式は、LLVMの中間表現（IR）をバイナリ形式で保存するための効率的なフォーマットである。コンパイラ開発者やLLVMツール開発者は、ビットコードファイルの構造を理解し、正しく読み書きできることを検証する必要がある。llvm-bcanalyzerは、この検証作業を支援し、ビットコードフォーマットの問題を特定するための診断ツールとして不可欠である。

**機能の利用シーン**：
- ビットコードリーダー/ライターの開発・デバッグ時
- LTOやThinLTOのビットコード出力の検証
- ビットコードファイルの破損・不整合の診断
- ビットコード形式の学習・研究

**主要な処理内容**：
1. ビットコードファイルの読み込みとバリデーション（4バイト境界チェック）
2. BitcodeAnalyzerクラスを使用した構造解析
3. ブロック・レコード情報の収集と統計計算
4. 解析結果の標準出力への表示（ダンプモードまたは統計モード）
5. オプションでBLOCKINFO情報の詳細表示

**関連システム・外部連携**：
- LLVMビットコードライブラリ（llvm/Bitcode/）との連携
- 他のLLVMツール（llc, opt, clang等）が出力するビットコードファイルの解析

**権限による制御**：本ツールはファイルシステムへの読み取りアクセスのみを必要とし、特別な権限は不要である。

## 関連画面

本ツールはCLI（コマンドラインインターフェース）ツールであり、GUI画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| N/A | コマンドライン | 主画面 | 入力ファイルとオプションの指定、解析結果の表示 |

## 機能種別

解析処理 / 診断ツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InputFilename | string | No | 解析対象のビットコードファイルパス（省略時は標準入力） | ファイルが存在すること |
| --dump | bool | No | 低レベルビットコードトレースを表示 | - |
| --dump-blockinfo | bool | No | BLOCKINFO詳細を表示（--dumpと併用） | - |
| --disable-histogram | bool | No | コード別ヒストグラムを無効化 | - |
| --non-symbolic | bool | No | シンボリック情報がある場合でも数値情報を表示 | - |
| --block-info | string | No | 外部ファイルからBLOCK_INFOを読み込む | ファイルが存在すること |
| --show-binary-blobs | bool | No | バイナリブロブを16進エスケープで表示 | - |
| --check-hash | string | No | 文字列テーブルを使用してモジュールハッシュを検証 | - |

### 入力データソース

- ファイルシステム上のLLVMビットコードファイル（.bc形式）
- 標準入力からのビットコードストリーム

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BlockInfo | text | 各ブロックの統計情報（サイズ、レコード数、略語使用率等） |
| DumpOutput | text | --dump時の低レベルビットコード構造 |
| Statistics | text | 全体の統計サマリー |

### 出力先

- 標準出力（stdout）

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ InitLLVMによるコマンドライン引数パース
2. 入力ファイル読み込み
   └─ MemoryBuffer::getFileOrSTDINでファイルまたは標準入力を読み込み
3. ビットコードバリデーション
   └─ ファイルサイズが4の倍数であることを確認
4. BitcodeAnalyzer初期化
   └─ オプションでBLOCKINFOファイルを読み込み
5. 解析オプション設定
   └─ BCDumpOptionsの設定（Histogram, Symbolic, ShowBinaryBlobs, DumpBlockinfo）
6. 解析実行
   └─ BA.analyze()でビットコード構造を解析
7. 結果出力
   └─ ダンプモードの場合は詳細構造を出力
   └─ BA.printStats()で統計情報を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン引数パース]
    B --> C[入力ファイル読み込み]
    C --> D{ファイルサイズ検証}
    D -->|4の倍数でない| E[エラー終了]
    D -->|OK| F{BLOCKINFO指定あり?}
    F -->|Yes| G[BLOCKINFOファイル読み込み]
    F -->|No| H[BitcodeAnalyzer初期化]
    G --> H
    H --> I[BCDumpOptions設定]
    I --> J[analyze実行]
    J --> K{--dump指定?}
    K -->|Yes| L[詳細ダンプ出力]
    K -->|No| M[統計情報出力]
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 4バイト境界チェック | ビットコードストリームは4バイトの倍数である必要がある | 常時 |
| BR-02 | ダンプモード排他 | --dumpが指定された場合のみ詳細構造を出力 | --dumpオプション指定時 |
| BR-03 | BLOCKINFOオーバーライド | --block-infoで外部ファイルのBLOCKINFOを使用可能 | --block-infoオプション指定時 |

### 計算ロジック

統計情報として以下を計算：
- 各ブロックタイプの出現回数
- 各レコードタイプの出現回数
- 略語（abbreviation）の使用率
- ビット使用量の内訳

## データベース操作仕様

本ツールはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| illegal_byte_sequence | 入力エラー | ファイルサイズが4の倍数でない | ファイルを確認・再生成 |
| file_not_found | 入力エラー | 指定ファイルが存在しない | ファイルパスを確認 |
| parse_error | 解析エラー | ビットコード形式が不正 | 正しいビットコードファイルを使用 |

### リトライ仕様

リトライ処理は実装されていない（単発実行ツール）。

## トランザクション仕様

該当なし（読み取り専用処理）。

## パフォーマンス要件

特に明示的な性能要件はないが、MemoryBufferを使用してファイル全体をメモリにマッピングすることで効率的な読み取りを実現している。

## セキュリティ考慮事項

- ファイル読み取り権限のみを必要とする
- 不正な形式のファイルに対してはエラーを返す（クラッシュ耐性）

## 備考

- llvm-bcanalyzerは主に開発者向けの診断ツールである
- LLVMのビットコード形式は後方互換性を維持しているが、新しいブロックタイプが追加される場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビットコード解析に使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BitcodeAnalyzer.h | `llvm/include/llvm/Bitcode/BitcodeAnalyzer.h` | BitcodeAnalyzerクラスとBCDumpOptionsの定義 |

**読解のコツ**: BCDumpOptionsは解析オプションを保持する構造体で、BitcodeAnalyzerがビットコードの解析ロジックをカプセル化している。

#### Step 2: エントリーポイントを理解する

処理の起点となるmain関数を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-bcanalyzer.cpp | `llvm/tools/llvm-bcanalyzer/llvm-bcanalyzer.cpp` | main関数とコマンドラインオプションの定義 |

**主要処理フロー**:
1. **103-107行目**: InitLLVMとコマンドライン引数パース
2. **110-113行目**: 入力ファイルとオプションのBLOCKINFOファイルの読み込み
3. **115-118行目**: BitcodeAnalyzerの初期化
4. **120-124行目**: BCDumpOptionsの設定
5. **126-128行目**: analyze()メソッドの呼び出し
6. **133行目**: printStats()で統計情報出力

#### Step 3: ファイル読み込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-bcanalyzer.cpp | `llvm/tools/llvm-bcanalyzer/llvm-bcanalyzer.cpp` | openBitcodeFile関数（88-101行目） |

**主要処理フロー**:
- **90-93行目**: MemoryBuffer::getFileOrSTDINでファイル読み込み
- **97-99行目**: 4バイト境界チェック

### プログラム呼び出し階層図

```
main()
    │
    ├─ InitLLVM()
    ├─ cl::ParseCommandLineOptions()
    ├─ openBitcodeFile()
    │      └─ MemoryBuffer::getFileOrSTDIN()
    │
    ├─ BitcodeAnalyzer::BitcodeAnalyzer()
    │
    ├─ BitcodeAnalyzer::analyze()
    │      └─ (内部でビットストリーム解析)
    │
    └─ BitcodeAnalyzer::printStats()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ビットコード     ───▶ openBitcodeFile()    ───▶ MemoryBuffer
ファイル (.bc)         │
                       ▼
                  BitcodeAnalyzer()
                       │
                       ▼
                  analyze()         ───▶ 構造解析結果
                       │
                       ▼
                  printStats()      ───▶ 統計情報
                                         (stdout)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-bcanalyzer.cpp | `llvm/tools/llvm-bcanalyzer/llvm-bcanalyzer.cpp` | ソース | メインエントリーポイント、CLI処理 |
| CMakeLists.txt | `llvm/tools/llvm-bcanalyzer/CMakeLists.txt` | ビルド設定 | ビルド構成の定義 |
| BitcodeAnalyzer.h | `llvm/include/llvm/Bitcode/BitcodeAnalyzer.h` | ヘッダー | BitcodeAnalyzerクラス定義 |
| BitcodeAnalyzer.cpp | `llvm/lib/Bitcode/Reader/BitcodeAnalyzer.cpp` | ソース | ビットコード解析実装 |
